/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.items;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import officemate.screens.setup.stock.ingredients.StockLinkableCostPanel;
import ordermate.database.stock.StockLinkable;
import ordermate.internationalization.Internationalization;

public class UsageCostPanel<T extends StockLinkable>
extends JPanel
implements StockLinkableCostPanel<T> {
    private JSpinner costExSpinner;
    private JSpinner costIncSpinner;
    private JLabel costLabelEx;
    private JLabel costLabelInc;
    private T focusOption = null;
    private T currentOption = null;

    public UsageCostPanel() {
        SpinnerNumberModel model = new SpinnerNumberModel(0.0, 0.0, 9999.0, 1.0);
        this.costExSpinner = new JSpinner(model);
        this.costExSpinner.setName("costExSpinner");
        JSpinner.NumberEditor spinnerEditor = new JSpinner.NumberEditor(this.costExSpinner, Internationalization.getLiteralFor((String)"PRICE_PATTERN"));
        this.costExSpinner.setEditor(spinnerEditor);
        JFormattedTextField costExTextField = spinnerEditor.getTextField();
        this.costExSpinner.setEnabled(false);
        this.costIncSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 9999.0, 1.0));
        this.costIncSpinner.setName("costIncSpinner");
        spinnerEditor = new JSpinner.NumberEditor(this.costIncSpinner, Internationalization.getLiteralFor((String)"PRICE_PATTERN"));
        this.costIncSpinner.setEditor(spinnerEditor);
        JFormattedTextField costIncTextField = spinnerEditor.getTextField();
        this.costIncSpinner.setEnabled(false);
        StockCostFocusListener fl = new StockCostFocusListener();
        costExTextField.addFocusListener(fl);
        costIncTextField.addFocusListener(fl);
        this.setLayout(new BorderLayout());
        this.setName("costPanel");
        this.setBorder(BorderFactory.createTitledBorder("Cost"));
        JPanel costSpinnerPanel = new JPanel();
        costSpinnerPanel.setLayout(new BoxLayout(costSpinnerPanel, 0));
        this.costLabelEx = new JLabel(COST_EX_LABEL);
        this.costLabelEx.setLabelFor(this.costExSpinner);
        JPanel costExPanel = new JPanel(new BorderLayout());
        costExPanel.add((Component)this.costLabelEx, "West");
        costExPanel.add((Component)this.costExSpinner, "Center");
        this.costLabelInc = new JLabel(COST_INC_LABEL);
        this.costLabelInc.setLabelFor(this.costIncSpinner);
        JPanel costIncPanel = new JPanel(new BorderLayout());
        costIncPanel.add((Component)this.costLabelInc, "West");
        costIncPanel.add((Component)this.costIncSpinner, "Center");
        costSpinnerPanel.add(costExPanel);
        costSpinnerPanel.add(costIncPanel);
        this.add((Component)costSpinnerPanel, "Center");
    }

    @Override
    public void updateForStockLinkableObject(T stockLinkable) {
        this.currentOption = stockLinkable;
        if (stockLinkable != null) {
            this.costIncSpinner.setEnabled(false);
            this.costIncSpinner.setValue(StockLinkableCostPanel.Helper.getDoubleForSpinner(stockLinkable.getIngredientCostIncTax()));
            this.costExSpinner.setEnabled(false);
            this.costExSpinner.setValue(StockLinkableCostPanel.Helper.getDoubleForSpinner(stockLinkable.getIngredientCostExTax()));
        } else {
            this.costIncSpinner.setEnabled(false);
            this.costIncSpinner.setValue(new Double(0.0));
            this.costExSpinner.setEnabled(false);
            this.costExSpinner.setValue(new Double(0.0));
        }
    }

    @Override
    public JComponent getGuiComponent() {
        return this;
    }

    @Override
    public void setEnabled(boolean b) {
        this.costIncSpinner.setEnabled(b);
        this.costExSpinner.setEnabled(b);
    }

    private class StockCostFocusListener
    implements FocusListener {
        private StockCostFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            UsageCostPanel.this.focusOption = UsageCostPanel.this.currentOption;
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (UsageCostPanel.this.focusOption != null) {
                UsageCostPanel.this.focusOption = (StockLinkable)PersistenceManager.reacquire((PersistentObjectI)UsageCostPanel.this.focusOption);
            }
        }
    }
}

