/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.items;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OkCancelDialogBuilder;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.fieldpanels.QuantityFieldPanel;
import officemate.adminkit.types.DoubleFieldType;
import officemate.adminkit.types.FieldType;
import officemate.adminkit.types.QuantityFieldType;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.Quantity;
import ordermate.database.stock.StockYieldHelper;
import ordermate.gui.FieldPanelBuilder;
import stockmate.database.interfaces.stock.MeasureUnitI;

public class YieldEditorPanel
extends FieldPanel {
    private JButton yieldButton;
    private double yieldPercentage;
    private Quantity yieldUnit = new Quantity(0.0);
    private DoubleFieldType fieldType;
    private SpinnerNumberModel percentSpinnerModel;
    private JSpinner percentSpinner;
    private JTextField percentText;
    private JPanel dialogPanel;
    private QuantityFieldPanel qtyPanel;
    private QuantityFieldType qtyFieldType;
    private MeasureUnitContainer measureUnitContainer;
    boolean processEventsAllowed = true;

    @Override
    public Object getValue() {
        return this.yieldUnit;
    }

    private static double getDoubleFromSpinner(JSpinner spinner) {
        return ((Number)spinner.getValue()).doubleValue();
    }

    public void setFieldType(FieldType fType) {
        this.fieldType = (DoubleFieldType)fType;
        Double minObj = this.fieldType.getMinValue();
        Double maxObj = this.fieldType.getMaxValue();
        Double defObj = this.fieldType.getDefaultValue();
        double min = minObj != null ? minObj : 0.0;
        double max = maxObj != null ? maxObj : 1.0E7;
        double def = defObj != null ? defObj : 100.0;
        this.percentSpinnerModel = new SpinnerNumberModel(def, min, max, 1.0);
        this.qtyPanel = new QuantityFieldPanel();
        this.qtyFieldType = new QuantityFieldType(min, max, def);
        this.qtyPanel.setFieldType(this.qtyFieldType);
        this.percentSpinner = new JSpinner(this.percentSpinnerModel);
        OfficeMateAdminGuiUtils.getInstance().standardSpinnerSetup(this.percentSpinner);
        this.percentSpinner.setPreferredSize(new Dimension(70, 20));
        JSpinner.DefaultEditor percentEditor = (JSpinner.DefaultEditor)this.percentSpinner.getEditor();
        this.percentText = percentEditor.getTextField();
        this.percentText.setColumns(20);
        ChangeListener sharedListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() == YieldEditorPanel.this.qtyPanel.getSpinnerComponent()) {
                    YieldEditorPanel.this.updateForNewUnit();
                } else if (e.getSource() == YieldEditorPanel.this.percentSpinner) {
                    YieldEditorPanel.this.updateForNewPercentage();
                }
            }
        };
        this.qtyPanel.addChangeListenerToComponent(sharedListener);
        this.percentSpinner.addChangeListener(sharedListener);
        FieldPanelBuilder builder = new FieldPanelBuilder();
        JPanel unitPanel = new JPanel();
        unitPanel.add(this.qtyPanel);
        builder.addRow("Unit Value", (Component)unitPanel);
        builder.addRow("Percentage Value", (Component)this.percentSpinner);
        this.dialogPanel = builder.getPanel();
        this.dialogPanel.setPreferredSize(new Dimension(100, 100));
        this.yieldButton = new JButton();
        this.yieldButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OkCancelDialogBuilder toShow = Dialogs.getOkCancelDialogBuilder(YieldEditorPanel.this.dialogPanel);
                toShow.setTitle("Edit Yield");
                toShow.setHtmlHeader("<html>This dialog allows you to edit the Yield as both a Unit and Percentage.</html>");
                if (toShow.doShow()) {
                    YieldEditorPanel.this.updatePanelVariables();
                }
            }
        });
        this.add(this.yieldButton);
    }

    protected void updatePanelVariables() {
        this.yieldPercentage = YieldEditorPanel.getDoubleFromSpinner(this.percentSpinner);
        this.yieldUnit = this.qtyPanel.getValue();
        this.yieldButton.setText("" + this.yieldUnit);
    }

    private void updateForNewPercentage() {
        if (this.processEventsAllowed) {
            this.processEventsAllowed = false;
            double ex = YieldEditorPanel.getDoubleFromSpinner(this.percentSpinner);
            if (this.measureUnitContainer != null) {
                this.qtyPanel.setValue(StockYieldHelper.convertYieldPercentageToQuantity((double)ex, (MeasureUnitContainer)this.measureUnitContainer, (MeasureUnitI)this.qtyPanel.getValue().getMeasureUnit()));
            }
            this.processEventsAllowed = true;
        }
    }

    private void updateForNewUnit() {
        if (this.processEventsAllowed) {
            this.processEventsAllowed = false;
            if (this.measureUnitContainer != null) {
                this.percentSpinner.setValue(StockYieldHelper.convertYieldQuantityToPercentage((Quantity)this.qtyPanel.getValue(), (MeasureUnitContainer)this.measureUnitContainer));
            }
            this.processEventsAllowed = true;
        }
    }

    public FieldType getFieldType() {
        return this.qtyFieldType;
    }

    @Override
    public void setValue(Object o) {
        this.yieldUnit = (Quantity)o;
        this.yieldButton.setText("" + this.yieldUnit);
        Double max = this.fieldType.getMaxValue();
        Double min = this.fieldType.getMinValue();
        if (min != null && this.yieldUnit.getRawValue() < min) {
            this.yieldUnit = new Quantity(this.yieldUnit.getMeasureUnit(), min.doubleValue());
        } else if (max != null && this.yieldUnit.getRawValue() > max) {
            this.yieldUnit = new Quantity(this.yieldUnit.getMeasureUnit(), max.doubleValue());
        }
        this.qtyPanel.setValue(this.yieldUnit);
    }

    public void setValueAsPercentage(double percentage) {
        this.yieldPercentage = percentage;
        Double max = this.fieldType.getMaxValue();
        Double min = this.fieldType.getMinValue();
        if (min != null && this.yieldPercentage < min) {
            this.yieldPercentage = min;
        } else if (max != null && this.yieldPercentage > max) {
            this.yieldPercentage = max;
        }
        this.percentSpinner.setValue(this.yieldPercentage);
        this.updateForNewPercentage();
        this.updatePanelVariables();
    }

    public double getYieldAsPercentage() {
        return this.yieldPercentage;
    }

    public void setMeasureUnitContainer(MeasureUnitContainer toUse) {
        this.measureUnitContainer = toUse;
    }

    @Override
    public JComponent getPrimaryComponent() {
        return this.yieldButton;
    }
}

