/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.items.replace;

import officemate.screens.setup.stock.items.replace.StockItemReplacer;
import ordermate.database.config.Quantity;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;

class InventoryUsageLinkReplacer
extends StockItemReplacer<StockInventoryUsageLink> {
    private boolean newRemovable;

    public InventoryUsageLinkReplacer(StockInventoryUsageLink usageLink, StockItem existingStockItem, StockItem replacementStockItem) {
        super(usageLink, existingStockItem, replacementStockItem, StockItemReplacer.StockItemReplacerType.MENU_ITEM);
        this.newRemovable = usageLink.isRemovable();
    }

    @Override
    public String getDisplayLabel() {
        InventoryItem invItem = ((StockInventoryUsageLink)this.getItem()).getInventoryItemUnit().getItem();
        return invItem.getLabel() + " (" + invItem.getMenuGroup() + ")";
    }

    public boolean isNewRemovable() {
        return this.newRemovable;
    }

    public void setNewRemovable(boolean newRemovable) {
        this.newRemovable = newRemovable;
    }

    @Override
    public void doReplace() {
        InventoryItemUnit itemUnit = ((StockInventoryUsageLink)this.getItem()).getInventoryItemUnit();
        itemUnit.setStockUsage(this.getExistingStockItem(), Quantity.ZERO(), ((StockInventoryUsageLink)this.getItem()).isFixedQuantity(), ((StockInventoryUsageLink)this.getItem()).isRemovable());
        itemUnit.setStockUsage(this.getReplacementStockItem(), new Quantity(this.getNewQty()), this.isNewFixedQty(), this.newRemovable);
        itemUnit.saveChild();
    }
}

