/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.items.replace;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import officemate.adminkit.ObjectEditorPanel;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OkCancelDialogHandler;
import officemate.adminkit.templates.Templates;
import officemate.components.search.SingleSearchDialog;
import officemate.components.search.objectsearch.StockItemSearchState;
import officemate.screens.setup.stock.items.replace.StockItemReplacementSearcher;
import officemate.screens.setup.stock.items.replace.StockItemReplacementTableModel;
import officemate.screens.setup.stock.items.replace.StockItemReplacer;
import officemate.screens.setup.stock.options.StockItemSelectorPanel;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usagelink.StockItemIngredientLink;
import ordermate.gui.FieldPanelBuilder;

class StockItemReplacementPanel
extends JPanel
implements OkCancelDialogHandler {
    private StockItem existingStockItem;
    private JComboBox replacementCombo;
    private final StockItemSearchState replacementStockItemSearchState = new StockItemSearchState();
    private StockItemSelectorPanel replacementstockPanel;
    private JTable replaceStockItemTable;
    private JCheckBox stockItemsCheckBox;
    private JCheckBox optionsCheckBox;
    private JCheckBox plusesCheckBox;
    private JCheckBox preProdIngredientsCheckBox;
    private StockItemReplacementSearcher replacementSearcher;
    private List<StockItemReplacer> replaceList;

    public StockItemReplacementPanel(StockItem existingStockItem) {
        this.existingStockItem = existingStockItem;
        this.replacementSearcher = new StockItemReplacementSearcher();
        this.setLayout(new BoxLayout(this, 1));
        this.setupComponents();
        this.updateReplaceStockItemModel();
    }

    public StockItem getExistingStockItem() {
        return this.existingStockItem;
    }

    public StockItem getReplacmentStockItem() {
        return this.replacementstockPanel.getSelectedObject();
    }

    private void setupComponents() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addRow("Existing Stock Item", (Component)this.buildExistingStockItemPanel());
        builder.addRow("Replace With Stock Item", (Component)this.buildReplaceWithStockItemPanel());
        builder.addRow("Include", (Component)this.buildOptionsPanel());
        this.add(builder.getPanel());
        this.replaceStockItemTable = new JTable();
        this.replaceStockItemTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StockItem parentStockItem;
                int row = StockItemReplacementPanel.this.replaceStockItemTable.rowAtPoint(evt.getPoint());
                int col = StockItemReplacementPanel.this.replaceStockItemTable.columnAtPoint(evt.getPoint());
                StockItemReplacementTableModel model = (StockItemReplacementTableModel)StockItemReplacementPanel.this.replaceStockItemTable.getModel();
                StockItemReplacer replacer = model.getStockItemReplacerAt(row);
                if (replacer == null) {
                    return;
                }
                if (StockItemReplacer.StockItemReplacerType.PRE_PROD_INGREDIENT.equals((Object)replacer.getType()) && 0 == col && (parentStockItem = ((StockItemIngredientLink)replacer.getItem()).getParentStockItem()).equals((Object)replacer.getReplacementStockItem())) {
                    Dialogs.showErrorDialog("Cannot Replace Stock Item", "Cannot replace stock ingredient, cyclic dependency detected!\nMake sure the ingredient is not the parent stock item.");
                }
            }
        });
        JScrollPane salesPriceScrollPane = new JScrollPane(this.replaceStockItemTable);
        this.add(salesPriceScrollPane);
        this.add(this.buildTableFooterOptions());
    }

    private JPanel buildExistingStockItemPanel() {
        JLabel existStockItemText = new JLabel();
        existStockItemText.setText(this.existingStockItem.getLabel());
        JPanel existingPanel = new JPanel(new FlowLayout(0, 5, 0));
        existingPanel.add(existStockItemText);
        return existingPanel;
    }

    private JPanel buildReplaceWithStockItemPanel() {
        EventList stockItemModel = GlazedLists.eventList((Collection)StockItemQueries.getStockItems());
        this.replacementCombo = new JComboBox(new EventComboBoxModel(stockItemModel));
        this.replacementstockPanel = new StockItemSelectorPanel(this.replacementCombo, (EventList<StockItem>)stockItemModel);
        this.replacementstockPanel.objectSelected.connect((Object)this, "gotReplacementStockItem");
        JPanel replacementPanel = new JPanel(new FlowLayout(0, 5, 0));
        this.replacementstockPanel.setPreferredSize(new Dimension(260, 20));
        replacementPanel.add((Component)this.replacementstockPanel, "Center");
        JButton searchButton = new JButton(IconLoader.get((String)"/ordermate/images/search16.png"));
        searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StockItemReplacementPanel.this.searchForStockItem();
            }
        });
        JButton addButton = new JButton(IconLoader.get((String)"/ordermate/images/new_icon16.png"));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StockItemReplacementPanel.this.addNewStockItem();
            }
        });
        replacementPanel.add(searchButton);
        replacementPanel.add(addButton);
        return replacementPanel;
    }

    private JPanel buildOptionsPanel() {
        JPanel optionsPanel = new JPanel();
        this.stockItemsCheckBox = new JCheckBox("Menu Items", true);
        this.optionsCheckBox = new JCheckBox("Options", true);
        this.plusesCheckBox = new JCheckBox("Pluses", true);
        this.preProdIngredientsCheckBox = new JCheckBox("Pre-Prod Ingredients", true);
        this.addActionListenerToCheckBox(this.stockItemsCheckBox);
        this.addActionListenerToCheckBox(this.optionsCheckBox);
        this.addActionListenerToCheckBox(this.plusesCheckBox);
        this.addActionListenerToCheckBox(this.preProdIngredientsCheckBox);
        optionsPanel.add(this.stockItemsCheckBox);
        optionsPanel.add(this.optionsCheckBox);
        optionsPanel.add(this.plusesCheckBox);
        optionsPanel.add(this.preProdIngredientsCheckBox);
        return optionsPanel;
    }

    private JPanel buildTableFooterOptions() {
        JPanel footerOptions = new JPanel(new FlowLayout(0));
        JButton selectAll = new JButton("Select All");
        selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StockItemReplacementPanel.this.setAllSelected(true);
            }
        });
        JButton selectNone = new JButton("Select None");
        selectNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StockItemReplacementPanel.this.setAllSelected(false);
            }
        });
        footerOptions.add(selectAll);
        footerOptions.add(selectNone);
        return footerOptions;
    }

    private void setAllSelected(boolean selected) {
        for (int i = 0; i < this.replaceStockItemTable.getModel().getRowCount(); ++i) {
            this.replaceStockItemTable.getModel().setValueAt(selected, i, 0);
        }
        this.replaceStockItemTable.repaint();
    }

    private void addActionListenerToCheckBox(JCheckBox checkBox) {
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StockItemReplacementPanel.this.updateReplaceStockItemModel();
            }
        });
    }

    private void updateReplaceStockItemModel() {
        this.replaceList = this.buildTheStockReplacementList();
        StockItemReplacementTableModel stockItemModel = new StockItemReplacementTableModel(this.replaceList);
        this.replaceStockItemTable.setModel(stockItemModel);
        TableColumn replacementQuantity = this.replaceStockItemTable.getColumnModel().getColumn(4);
        replacementQuantity.setCellEditor(new IngredientsCellEditor());
        this.replaceStockItemTable.getColumnModel().getColumn(0).setPreferredWidth(5);
        this.replaceStockItemTable.getColumnModel().getColumn(1).setPreferredWidth(10);
        this.replaceStockItemTable.repaint();
    }

    private List<StockItemReplacer> buildTheStockReplacementList() {
        this.replacementSearcher.setIncludeStockItems(this.stockItemsCheckBox.isSelected());
        this.replacementSearcher.setIncludeOptions(this.optionsCheckBox.isSelected());
        this.replacementSearcher.setIncludePluses(this.plusesCheckBox.isSelected());
        this.replacementSearcher.setIncludePreProdIngredients(this.preProdIngredientsCheckBox.isSelected());
        return this.replacementSearcher.doSearch(this.existingStockItem, this.getReplacmentStockItem());
    }

    private void searchForStockItem() {
        SingleSearchDialog<StockItem> dlg = new SingleSearchDialog<StockItem>(this.replacementStockItemSearchState, this.replacementStockItemSearchState.getTableColumnFormat(), "Stock Item", IconLoader.get((String)"/ordermate/images/search22.png"));
        this.replacementStockItemSearchState.getNameSearch().getGuiComponent().setFocusable(true);
        this.replacementStockItemSearchState.getNameSearch().getGuiComponent().requestFocus();
        StockItem item = (StockItem)dlg.doDialog(this.getParent());
        if (item != null) {
            this.replacementstockPanel.setSelectedObject(item);
        }
    }

    private void gotReplacementStockItem() {
        StockItem test = this.replacementstockPanel.getSelectedObject();
        this.updateReplaceStockItemModel();
    }

    private void addNewStockItem() {
        StockItem newStockItem = new StockItem();
        ObjectEditorPanel editorPanel = Templates.STOCK_ITEM.getNewEditPanel(newStockItem);
        boolean okPressed = Dialogs.getOkCancelDialogBuilder(editorPanel).setTitle("New Stock Item").setHtmlHeader("<html>Use this panel to setup your new stock item</html>").doShow();
        while (okPressed) {
            if (editorPanel.requestSaveAllowed()) {
                editorPanel.saveObject();
                newStockItem.save();
                this.replacementstockPanel.updateView();
                this.replacementstockPanel.setSelectedObject(newStockItem);
                break;
            }
            okPressed = Dialogs.getOkCancelDialogBuilder(editorPanel).setTitle("New Stock Item").setHtmlHeader("<html>Use this panel to setup your new stock item</html>").doShow();
        }
    }

    @Override
    public boolean isOKAllowed() {
        if (this.getReplacmentStockItem() == null) {
            Dialogs.showInfoDialog("Replace Stock Item", "You must select a replacement Stock Item.");
            return false;
        }
        if (!this.checkAtLeastOneItemToReplace()) {
            Dialogs.showInfoDialog("Replace Stock Item", "No items are selected to be replaced.");
            return false;
        }
        return Dialogs.showChoiceDialog("Replace Stock Item", "Are you sure you wish to replace the stock item?");
    }

    @Override
    public boolean isCancelAllowed() {
        return true;
    }

    private boolean checkAtLeastOneItemToReplace() {
        for (StockItemReplacer replacer : this.replaceList) {
            if (!replacer.isShouldDoReplace()) continue;
            return true;
        }
        return false;
    }

    public List<StockItemReplacer> getReplaceList() {
        return this.replaceList;
    }

    class IngredientsCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private DecimalFormat qtyFormatter = new DecimalFormat("0.###");
        private JTextField textField;
        private JPanel cellPanel = new JPanel(new FlowLayout(0, 0, 0));
        private JLabel description;
        private StockItemReplacer currentItem;

        public IngredientsCellEditor() {
            this.textField = new JTextField(4);
            this.description = new JLabel();
            this.cellPanel.getInsets().set(0, 0, 0, 0);
            this.textField.getInsets().set(0, 0, 0, 0);
            this.cellPanel.add(this.textField);
            this.cellPanel.add(this.description);
        }

        @Override
        public Object getCellEditorValue() {
            String value = this.textField.getText();
            if (value == null) {
                return null;
            }
            String toParse = value.trim();
            if (toParse.length() == 0) {
                return null;
            }
            try {
                this.currentItem.setNewQty(Double.valueOf(toParse));
                return this.currentItem.getNewQty();
            }
            catch (NumberFormatException ex) {
                OrderMateLog.LOG.warn("Invalid numerical quantity:", (Throwable)ex);
                this.cancelCellEditing();
                return null;
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentItem = (StockItemReplacer)StockItemReplacementPanel.this.replaceList.get(row);
            this.textField.setText(this.qtyFormatter.format(this.currentItem.getNewQty()));
            this.description.setText(" " + this.currentItem.getReplacementStockItem().getIngredientMeasureUnit().getSuffix() + " " + this.currentItem.getReplacementStockItem().getLabel());
            return this.cellPanel;
        }
    }
}

