/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.items.replace;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.List;
import officemate.screens.setup.stock.items.replace.InventoryUsageLinkReplacer;
import officemate.screens.setup.stock.items.replace.StockItemReplacer;
import officemate.screens.setup.stock.items.replace.StockPreProdIngredientReplacer;
import officemate.screens.setup.stock.items.replace.StockUsageAddLinkeReplacer;
import officemate.screens.setup.stock.items.replace.StockUsageOptionReplacer;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.database.stock.usagelink.StockItemIngredientLink;
import ordermate.database.stock.usagelink.StockUsageAddLink;
import ordermate.database.stock.usagelink.StockUsageOptionLink;

class StockItemReplacementSearcher {
    private boolean includeStockItems;
    private boolean includeOptions;
    private boolean includePluses;
    private boolean includePreProdIngredients;
    private StockItem existingStockItem;
    private StockItem replacementStockItem;

    StockItemReplacementSearcher() {
    }

    public List<StockItemReplacer> doSearch(StockItem existingItem, StockItem replacementItem) {
        this.existingStockItem = existingItem;
        this.replacementStockItem = replacementItem;
        ArrayList<StockItemReplacer> itemsList = new ArrayList<StockItemReplacer>();
        if (this.includeStockItems) {
            itemsList.addAll(this.getInventoryItems());
        }
        if (this.includeOptions) {
            itemsList.addAll(this.getOptionItems());
        }
        if (this.includePluses) {
            itemsList.addAll(this.getPlusesItems());
        }
        if (this.includePreProdIngredients) {
            itemsList.addAll(this.getPreProdIngredients());
        }
        return itemsList;
    }

    private List<StockItemReplacer> getInventoryItems() {
        ArrayList<StockItemReplacer> replaceList = new ArrayList<StockItemReplacer>();
        ObjectQuery query = Query.select(StockInventoryUsageLink.class).linkUsing(StockInventoryUsageLink.Properties.INVENTORY_ITEM_UNIT, InventoryItemUnit.Properties.ID).linkUsing(InventoryItemUnit.Properties.ITEM, InventoryItem.Properties.ID).not().deleted(InventoryItem.class).equals(StockInventoryUsageLink.Properties.STOCK_ITEM, (Object)this.existingStockItem);
        List usageList = PersistenceManager.getObjectList(StockInventoryUsageLink.class, (String)query.toString());
        for (StockInventoryUsageLink usage : usageList) {
            replaceList.add(new InventoryUsageLinkReplacer(usage, this.existingStockItem, this.replacementStockItem));
        }
        return replaceList;
    }

    private List<StockItemReplacer> getOptionItems() {
        ArrayList<StockItemReplacer> replaceList = new ArrayList<StockItemReplacer>();
        ObjectQuery query = Query.select(StockUsageOptionLink.class).equals(StockUsageOptionLink.Properties.STOCK_ITEM, (Object)this.existingStockItem).not().isNull(StockUsageOptionLink.Properties.INVENTORY_OPTION);
        List modList = PersistenceManager.getObjectList(StockUsageOptionLink.class, (String)query.toString());
        for (StockUsageOptionLink modLink : modList) {
            replaceList.add(new StockUsageOptionReplacer(modLink, this.existingStockItem, this.replacementStockItem));
        }
        return replaceList;
    }

    private List<StockItemReplacer> getPlusesItems() {
        ArrayList<StockItemReplacer> replaceList = new ArrayList<StockItemReplacer>();
        ObjectQuery query = Query.select(StockUsageAddLink.class).equals(StockUsageAddLink.Properties.STOCK_ITEM, (Object)this.existingStockItem).not().isNull(StockUsageAddLink.Properties.INVENTORY_ADD);
        List modList = PersistenceManager.getObjectList(StockUsageAddLink.class, (String)query.toString());
        for (StockUsageAddLink modLink : modList) {
            replaceList.add(new StockUsageAddLinkeReplacer(modLink, this.existingStockItem, this.replacementStockItem));
        }
        return replaceList;
    }

    public void setIncludeStockItems(boolean includeStockItems) {
        this.includeStockItems = includeStockItems;
    }

    public void setIncludeOptions(boolean includeOptions) {
        this.includeOptions = includeOptions;
    }

    public void setIncludePluses(boolean includePluses) {
        this.includePluses = includePluses;
    }

    public void setIncludePreProdIngredients(boolean includePreProdIngredients) {
        this.includePreProdIngredients = includePreProdIngredients;
    }

    private List<StockItemReplacer> getPreProdIngredients() {
        ArrayList<StockItemReplacer> replaceList = new ArrayList<StockItemReplacer>();
        ObjectQuery query = Query.select(StockItemIngredientLink.class).equals(StockItemIngredientLink.Properties.STOCK_ITEM, (Object)this.existingStockItem);
        List ingredientLinkList = PersistenceManager.getObjectList(StockItemIngredientLink.class, (String)query.toString());
        for (StockItemIngredientLink ingredientLink : ingredientLinkList) {
            replaceList.add(new StockPreProdIngredientReplacer(ingredientLink, this.existingStockItem, this.replacementStockItem));
        }
        return replaceList;
    }
}

