/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.items.replace;

import ordermate.database.stock.StockItem;
import ordermate.database.stock.usagelink.StockUsageLink;

abstract class StockItemReplacer<T extends StockUsageLink> {
    private boolean shouldDoReplace = true;
    private T item;
    private StockItem existingStockItem;
    private StockItem replacementStockItem;
    private double newQty;
    private boolean newFixedQty;
    private StockItemReplacerType type;

    public StockItemReplacer(T item, StockItem existingStockItem, StockItem replacementStockItem, StockItemReplacerType type) {
        this.item = item;
        this.existingStockItem = existingStockItem;
        this.replacementStockItem = replacementStockItem;
        this.type = type;
        this.newQty = item.getQuantity().getRawValue();
        this.newFixedQty = item.isFixedQuantity();
    }

    public T getItem() {
        return this.item;
    }

    public StockItem getExistingStockItem() {
        return this.existingStockItem;
    }

    public StockItem getReplacementStockItem() {
        return this.replacementStockItem;
    }

    public boolean isShouldDoReplace() {
        return this.shouldDoReplace;
    }

    public void setShouldDoReplace(boolean shouldDoReplace) {
        this.shouldDoReplace = shouldDoReplace;
    }

    public double getNewQty() {
        return this.newQty;
    }

    public void setNewQty(double newQty) {
        this.newQty = newQty;
    }

    public boolean isNewFixedQty() {
        return this.newFixedQty;
    }

    public void setNewFixedQty(boolean newFixedQty) {
        this.newFixedQty = newFixedQty;
    }

    public abstract String getDisplayLabel();

    public abstract void doReplace();

    public StockItemReplacerType getType() {
        return this.type;
    }

    protected static enum StockItemReplacerType {
        MENU_ITEM,
        INVENTORY_OPTION,
        INVENTORY_ADD,
        PRE_PROD_INGREDIENT;

        private static final String MENU_ITEM_STR = "Menu Item";
        private static final String INVENTORY_OPTION_STR = "Option";
        private static final String INVENTORY_ADD_STR = "Plus";
        private static final String PRE_PROD_INGREDIENT_STR = "Pre-Prod Ingredient";

        public String toString() {
            switch (this) {
                case MENU_ITEM: {
                    return MENU_ITEM_STR;
                }
                case INVENTORY_OPTION: {
                    return INVENTORY_OPTION_STR;
                }
                case INVENTORY_ADD: {
                    return INVENTORY_ADD_STR;
                }
                case PRE_PROD_INGREDIENT: {
                    return PRE_PROD_INGREDIENT_STR;
                }
            }
            return super.toString();
        }
    }
}

