/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.items.replace;

import au.com.ordermate.persistence.ServiceLocator;
import java.util.Arrays;
import java.util.Stack;
import officemate.screens.setup.stock.items.replace.StockItemReplacer;
import ordermate.OrderMate;
import ordermate.database.config.Quantity;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usage.PreProdManager;
import ordermate.database.stock.usagelink.StockItemIngredientLink;

public class StockPreProdIngredientReplacer
extends StockItemReplacer<StockItemIngredientLink> {
    public StockPreProdIngredientReplacer(StockItemIngredientLink item, StockItem existingStockItem, StockItem replacementStockItem) {
        super(item, existingStockItem, replacementStockItem, StockItemReplacer.StockItemReplacerType.PRE_PROD_INGREDIENT);
    }

    @Override
    public String getDisplayLabel() {
        return ((StockItemIngredientLink)this.getItem()).getParentStockItem().getLabel();
    }

    @Override
    public void doReplace() {
        StockItem parentStockItem = ((StockItemIngredientLink)this.getItem()).getParentStockItem();
        parentStockItem.removeStockLink(this.getItem());
        parentStockItem.setStockUsage(this.getReplacementStockItem(), new Quantity(this.getNewQty()), this.isNewFixedQty(), false);
        parentStockItem.save();
    }

    @Override
    public boolean isShouldDoReplace() {
        StockItem parentStockItem = ((StockItemIngredientLink)this.getItem()).getParentStockItem();
        StockItemIngredientLink ingredientLink = new StockItemIngredientLink(parentStockItem, this.getReplacementStockItem(), new Quantity(this.getNewQty()));
        PreProdManager manager = (PreProdManager)ServiceLocator.locate(PreProdManager.class);
        try {
            Stack stack = manager.getCycleChecker().checkCycles(parentStockItem, Arrays.asList(ingredientLink));
            boolean hasNoCyclicDependency = stack == null || stack.isEmpty();
            return hasNoCyclicDependency ? super.isShouldDoReplace() : hasNoCyclicDependency;
        }
        catch (Exception e) {
            OrderMate.LOG.error("Failed to execute a cycle check for replacing preprod ingredient of " + parentStockItem.getName());
            return false;
        }
    }
}

