/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.liquorfile;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Frame;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import officemate.components.AbstractObjectEditor;
import officemate.components.ObjectEditorState;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.screens.setup.stock.liquorfile.LiquorfileConfigurationEditor;
import ordermate.database.integration.LiquorfileConfiguration;
import ordermate.database.misc.TradingDay;
import ordermate.database.users.AllPermissions;
import ordermate.gui.dialogs.ProgressDialog;
import ordermate.integration.liquorfile.comparison.ScandataExportComparator;

public class LiquorfileSetupState
extends ObjectEditorState {
    public LiquorfileSetupState() {
        super("Setup", AllPermissions.GOD_ONLY, "Configure Liquorfile Properties");
        this.setSaveStrategy(SaveStrategyFactory.getDeferredSaveStrategy((Refreshable)this));
        this.setSmallIcon(IconLoader.get((String)"/ordermate/images/ordermate_icon.png"));
    }

    protected PersistentObject acquireObject() {
        return LiquorfileConfiguration.getInstance();
    }

    @Override
    public void gotObjectEdited() {
        super.gotObjectEdited();
    }

    public void gotTestExport() {
        if (this.showBeginExportMessage()) {
            final String inputFile = this.getInputTestingFile();
            if (inputFile == null) {
                return;
            }
            final TradingDay testDay = this.getTestingTradingDay();
            if (testDay == null) {
                return;
            }
            final String outputFile = this.getOutputFile();
            if (outputFile != null) {
                AbstractTask exportTask = new AbstractTask(){

                    public String getName() {
                        return "Generating Export and Comparing";
                    }

                    protected int getTotalSubTasks() {
                        return -1;
                    }

                    protected void performTask() throws Exception {
                        ScandataExportComparator.compareExports((String)outputFile, (String)inputFile, (TradingDay)testDay);
                        this.emitProgress();
                    }
                };
                ProgressDialog pd = new ProgressDialog((Frame)GuiApp.getAppComplex().getApplicationFrame().getFrame(), true, (Task)exportTask);
                if (pd.start()) {
                    StringBuilder SB = new StringBuilder("<html>The analysis was successful and has been exported to:<br>");
                    SB.append(outputFile);
                    SB.append("<br><br>Please examine the analysis file in detail.<html>");
                    JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), SB.toString(), "Analysis successful", 1);
                } else {
                    StringBuilder SB = new StringBuilder("<html>There was a problem while performing the analysis.<br><br>");
                    SB.append("Please ensure that<ul>");
                    SB.append("<li>the source and destination files are not open in another application.</li>");
                    SB.append("<li>the input file was generated by the Administration back end.</li>");
                    SB.append("<li>Scandata is able to manually perform an export on the chosen trading day.");
                    SB.append("</ul>Check these solutions and try again.<html>");
                    JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), SB.toString(), "Analysis Unsuccessful", 2);
                }
            }
        }
    }

    private boolean showBeginExportMessage() {
        StringBuilder SB = new StringBuilder("<html>Before you proceed with an export, ensure that:<ol>");
        SB.append("<li>You have set the scandata export directory correctly.</li>");
        SB.append("<li>You can manually export a trading day.</li>");
        SB.append("<li>You have exported a Trading Day's sales from the PHP backend to a file</li>");
        SB.append("</ol><br>Do you wish to proceed?</html>");
        return JOptionPane.showConfirmDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), SB.toString(), "Confirm Test Export", 0, 3) == 0;
    }

    private String getInputTestingFile() {
        File selFile;
        String filename = null;
        JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Please select the Administration output file.");
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileNameExtensionFilter("CSV or Text files", "csv", "txt"));
        if (chooser.showOpenDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame()) == 0 && (selFile = chooser.getSelectedFile()) != null) {
            filename = selFile.toString();
        }
        return filename;
    }

    private TradingDay getTestingTradingDay() {
        TradingDay toTest = null;
        List tradingDays = TradingDay.getAllTradingDays();
        if (tradingDays == null || tradingDays.size() == 0) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "There are no Trading Days to analyze");
        } else {
            Object[] days = new TradingDay[tradingDays.size()];
            days = tradingDays.toArray(days);
            Object selection = JOptionPane.showInputDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Please select the Trading Day to analyze", "Select Trading Day", 3, null, days, days[days.length - 1]);
            if (selection != null) {
                toTest = (TradingDay)selection;
            }
        }
        return toTest;
    }

    private String getOutputFile() {
        File selFile;
        String filename = null;
        JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Please select the file to which the analysis will be written.");
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileNameExtensionFilter("CSV or Text files", "csv", "txt"));
        if (chooser.showSaveDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame()) == 0 && (selFile = chooser.getSelectedFile()) != null) {
            filename = selFile.toString();
        }
        return filename;
    }

    protected AbstractObjectEditor createObjectEditor() {
        LiquorfileConfigurationEditor editor = new LiquorfileConfigurationEditor();
        editor.testExport.connect((Object)this, "gotTestExport");
        return editor;
    }
}

