/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.liquorfile;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.AbstractObjectEditor;
import officemate.components.table.PersistentObjectTable;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.queries.inventory.InventoryGroupQueries;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.BindingHelper;
import ordermate.reports.table.ColumnFormat;
import org.jdesktop.beansbinding.AutoBinding;

class PriceBookInventoryItemEditor
extends AbstractObjectEditor<InventoryItem> {
    private final EventList<InventoryGroup> groups = GlazedLists.eventList((Collection)InventoryGroupQueries.getAllGroups());
    private final EventList<PrinterGroup> printerGroups = GlazedLists.eventList((Collection)PrinterGroup.getPrinterGroups());
    private final EventList<InventoryItemUnit> invItemUnits = GlazedLists.eventList(new ArrayList());
    private List<InventoryItemUnit> invItemUnitsToRemove = new ArrayList<InventoryItemUnit>();
    private BindingHelper<InventoryItem> bindingHelper = new BindingHelper();
    private PersistentObjectTable unitTable;
    private JButton removeButton;
    private JPanel InvItemTable;

    PriceBookInventoryItemEditor() {
        this.bindingHelper.setStrategy(AutoBinding.UpdateStrategy.READ_WRITE);
        this.setBindings(this.bindingHelper);
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addRow("Menu Item Name", (Component)this.setupTextField(InventoryItem.Properties.LABEL, 20));
        builder.addRow("Menu Section", (Component)this.setupComboBox(InventoryItem.Properties.MENU_GROUP, this.groups));
        builder.addRow("Printer Group", (Component)this.setupComboBox(InventoryItem.Properties.PRINTER_GROUP, this.printerGroups));
        builder.addSeparator("Sizes");
        this.buildTableState(this.invItemUnits);
        builder.addRow("", (Component)this.InvItemTable);
        this.add(builder.getPanel());
    }

    private void buildTableState(EventList invItemUnits) {
        this.InvItemTable = new JPanel(new BorderLayout());
        ColumnFormat[] cols = new ColumnFormat[]{new EditablePropertyColumnFormat("Sizes", (PropertyAccessor)InventoryItemUnit.Properties.SIZE, null)};
        this.unitTable = new PersistentObjectTable(invItemUnits, new ColumnTableFormat(cols));
        this.unitTable.setPreferredSize(new Dimension(120, 120));
        RemoveInventoryItemUnitsAction removeIIUAction = new RemoveInventoryItemUnitsAction();
        this.removeButton = new JButton((Action)((Object)removeIIUAction));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.add(this.removeButton);
        this.InvItemTable.add((Component)buttonPanel, "East");
        this.InvItemTable.add((Component)this.unitTable, "Center");
    }

    @Override
    public InventoryItem getObject() {
        InventoryItem toReturn = (InventoryItem)super.getObject();
        for (InventoryItemUnit unit : this.invItemUnitsToRemove) {
            if (!toReturn.getUnits().contains(unit)) continue;
            toReturn.removeUnit(unit);
        }
        return toReturn;
    }

    @Override
    public void setObject(InventoryItem toEdit) {
        super.setObject(toEdit);
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.invItemUnits, toEdit.getUnits());
    }

    private class RemoveInventoryItemUnitsAction
    extends BasicAction {
        RemoveInventoryItemUnitsAction() {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/delete_icon22.png"), "Remove");
        }

        public void actionPerformed(ActionEvent e) {
            PriceBookInventoryItemEditor.this.invItemUnitsToRemove.addAll(PriceBookInventoryItemEditor.this.unitTable.getAllSelectedObjects());
            GlazedListUtils.removeInList((EventList)PriceBookInventoryItemEditor.this.invItemUnits, PriceBookInventoryItemEditor.this.unitTable.getAllSelectedObjects());
        }
    }
}

