/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.liquorfile;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.table.ShadeAlternateRowsTableCellRenderer;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.screens.setup.stock.liquorfile.StockInventoryUsageLinkPropertySearch;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.database.users.AllPermissions;
import ordermate.gui.dialogs.ProgressDialog;
import ordermate.integration.liquorfile.pricebook.PricebookManager;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.NumberEditorExt;

public class PricebookLinkingState
extends AbstractEditableTableState {
    private static final String TYPE_NAME = "Liquorfile Assignments";
    private static final String STATE_NAME = "Linking";
    private Action exportAction;
    private Action importAction;

    public PricebookLinkingState() {
        super(STATE_NAME, AllPermissions.PRICEBOOK_LINKING, "Set the linking IDs for Liquorfile managed items");
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.exportAction = new BasicAction("Export Links", IconLoader.get((String)"/ordermate/images/rightarrow.png"), "Exports the visible set to a CSV"){

            public void actionPerformed(ActionEvent e) {
                PricebookLinkingState.this.exportUsageLinks();
            }
        };
        this.importAction = new BasicAction("Import Liquorfile IDs", IconLoader.get((String)"/ordermate/images/button_import.png"), "Import and sets liquorfile ids from a file."){

            public void actionPerformed(ActionEvent e) {
                PricebookLinkingState.this.importLiquorfileIds();
            }
        };
        this.addAction(this.exportAction);
        this.addAction(this.importAction);
        InventoryItemUnit.getAllInventoryItemUnits();
        StockItemQueries.getStockItems();
    }

    protected ObjectEditor createObjectEditor() {
        return null;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    protected boolean canCreateOrDelete() {
        return false;
    }

    @Override
    protected TableStateCentralArea createCentralArea() {
        EditablePropertyColumnFormat liquorfileFormat = new EditablePropertyColumnFormat(StockInventoryUsageLink.Properties.LIQUORFILE_ID);
        liquorfileFormat.setFormatter(new DecimalFormat("#"));
        ShadeAlternateRowsTableCellRenderer notNullRenderer = new ShadeAlternateRowsTableCellRenderer();
        notNullRenderer.setHorizontalAlignment(4);
        liquorfileFormat.setCustomRenderer(notNullRenderer);
        liquorfileFormat.setCustomEditor((TableCellEditor)((Object)new LFIDEditor()));
        PersistentObjectTable centralArea = new PersistentObjectTable(this.getObjectList(), new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(StockInventoryUsageLink.Properties.INVENTORY_ITEM_UNIT), new PropertyColumnFormat((PropertiedObject.Property)StockInventoryUsageLink.Properties.STOCK_ITEM_NAME), new PropertyColumnFormat(StockInventoryUsageLink.Properties.QUANTITY), liquorfileFormat}));
        centralArea.getTable().addHighlighter((Highlighter)new LiquorfileMissingHighlighter());
        return centralArea;
    }

    @Override
    protected Class getDisplayingType() {
        return StockInventoryUsageLink.class;
    }

    @Override
    protected OfficeMateObjectSearch createSearchPanelFactory() {
        return new StockInventoryUsageLinkPropertySearch();
    }

    private void exportUsageLinks() {
        File selectedFile;
        File startFile = null;
        File[] roots = File.listRoots();
        if (roots != null && roots.length > 0) {
            startFile = roots[0];
        }
        JFileChooser chooser = startFile != null ? new JFileChooser(startFile) : new JFileChooser();
        chooser.setFileFilter(new FileNameExtensionFilter("CSV or TXT files", "csv", "txt"));
        do {
            selectedFile = null;
            if (chooser.showSaveDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame()) != 0) continue;
            selectedFile = chooser.getSelectedFile();
        } while (selectedFile != null && !this.confirmOverwrite(selectedFile));
        if (selectedFile == null) {
            return;
        }
        final File file = selectedFile;
        int result = JOptionPane.showConfirmDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Do you wish to include any existing Liquorfile IDs?", "Include Liquorfile IDs?", 1);
        if (result == 2) {
            return;
        }
        final boolean ignoreLFID = result == 1;
        final ArrayList toExport = new ArrayList(this.getObjectList());
        ProgressDialog progressD = new ProgressDialog((Frame)GuiApp.getAppComplex().getApplicationFrame().getFrame(), true, (Task)new AbstractTask(){

            public String getName() {
                return "Exporting Links...";
            }

            protected int getTotalSubTasks() {
                return -1;
            }

            protected void performTask() throws Exception {
                boolean allGood = PricebookManager.getInstance().exportLiquorfileIds(file.toString(), ignoreLFID, toExport);
                if (!allGood) {
                    throw new IOException("Export could not be written, IO error.");
                }
                this.emitProgress();
            }
        });
        if (progressD.start()) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "The file was successfully exported.", "Export Successful", 1);
        } else {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "The file was not exported.\nPlease check that the target file is not in use and try again.", "Export Unsuccessful", 2);
        }
    }

    private void importLiquorfileIds() {
        File startFile = null;
        File[] roots = File.listRoots();
        if (roots != null && roots.length > 0) {
            startFile = roots[0];
        }
        JFileChooser chooser = new JFileChooser(startFile);
        chooser.setFileFilter(new FileNameExtensionFilter("CSV or TXT files", "csv", "txt"));
        chooser.showOpenDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame());
        File file = chooser.getSelectedFile();
        if (file != null && file.isFile()) {
            UpdateTask updateTask = new UpdateTask(file);
            ProgressDialog progressDialog = new ProgressDialog((Frame)GuiApp.getAppComplex().getApplicationFrame().getFrame(), true, (Task)updateTask);
            if (progressDialog.start()) {
                int icon = PricebookManager.getInstance().getLastInvalidImports().size() > 0 ? 2 : 1;
                if (JOptionPane.showConfirmDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), this.createUpdateMessage(), "Importing Complete", 0, icon) == 0) {
                    this.writeUpdateToLog();
                }
            } else {
                JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "There was an error while reading the import file.\nCheck that the correct Pricebook Linking file is used.", "File Invalid", 0);
            }
            this.refresh();
        }
    }

    private String createUpdateMessage() {
        List valids = PricebookManager.getInstance().getLastValidImports();
        List invalids = PricebookManager.getInstance().getLastInvalidImports();
        StringBuilder SB = new StringBuilder("<html><h3>Import Results:</h3>");
        if (valids.size() == 1) {
            SB.append("1 Usage Link was");
        } else {
            SB.append(valids.size());
            SB.append(" Usage Links were");
        }
        SB.append(" updated successfully.");
        if (invalids.size() > 0) {
            SB.append("<br><br>");
            if (invalids.size() == 1) {
                SB.append("1 Usage Link was");
            } else {
                SB.append(invalids.size());
                SB.append(" Usage Links were");
            }
            SB.append(" not updated successfully.");
        }
        SB.append("<br><br><b>Would you like to record this to a log file?</b></html>");
        return SB.toString();
    }

    private void writeUpdateToLog() {
        File file;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileNameExtensionFilter("Text files", "txt", "log"));
        do {
            file = null;
            if (chooser.showSaveDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame()) != 0) continue;
            file = chooser.getSelectedFile();
        } while (file != null && !this.confirmOverwrite(file));
        PricebookManager.getInstance().writeUpdateToLogFile(file);
    }

    private InventoryProfile getCurrentProfile() {
        return ((StockInventoryUsageLinkPropertySearch)this.getSearchFactory()).getSelectedProfile();
    }

    private boolean confirmOverwrite(File file) {
        if (!file.exists()) {
            return true;
        }
        return JOptionPane.showConfirmDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), file.toString() + " \nwill be overwritten.\n\nDo you wish to proceed?", "Confirm Overwrite", 0, 2) == 0;
    }

    private class LFIDEditor
    extends NumberEditorExt {
        private int editingRow;

        private LFIDEditor() {
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.editingRow = row;
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        public boolean stopCellEditing() {
            Integer newValue = (Integer)this.getCellEditorValue();
            boolean goAhead = true;
            if (this.isNotLogicalDuplicate(newValue)) {
                List otherLinks = PricebookManager.getInstance().getAssignedLinks(newValue, PricebookLinkingState.this.getCurrentProfile());
                StringBuilder SB = new StringBuilder("<html><b>The Liquorfile ID: ");
                SB.append(newValue);
                SB.append(" has already been assigned to </b><ul>");
                Iterator it = otherLinks.iterator();
                int count = 0;
                while (it.hasNext()) {
                    SB.append("<li>");
                    SB.append(((StockInventoryUsageLink)it.next()).getInventoryItemUnit().getLabel());
                    SB.append("</li>");
                    if (++count <= 5) continue;
                    SB.append("<li>...</li>");
                    break;
                }
                SB.append("</ul><br>While it is permitted to assign a Liquorfile ID to ");
                SB.append("multiple Usages,<br>");
                SB.append("there is a chance that the two items are unrelated.<br><br>");
                SB.append("Do you wish to continue?</html>");
                boolean bl = goAhead = JOptionPane.showConfirmDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), SB.toString(), "Duplicate IDs", 2) == 0;
            }
            if (!goAhead) {
                this.cancelCellEditing();
            }
            return goAhead && super.stopCellEditing();
        }

        private boolean isNotLogicalDuplicate(Integer newValue) {
            boolean notLogicalDuplicate = false;
            JXTable table = PricebookLinkingState.this.getCentralArea().getTable();
            if (newValue != null) {
                StockInventoryUsageLink link = (StockInventoryUsageLink)PricebookLinkingState.this.getObjectList().get(table.convertRowIndexToModel(this.editingRow));
                if (!PricebookManager.getInstance().isDuplicateID(link, newValue)) {
                    Iterator it = PricebookManager.getInstance().getAssignedLinks(newValue, link.getInventoryItemUnit().getItem().getMenuGroup().getProfile()).iterator();
                    while (it.hasNext()) {
                        if (link.getQuantity().equals((Object)((StockInventoryUsageLink)it.next()).getQuantity())) continue;
                        notLogicalDuplicate = true;
                        break;
                    }
                }
            }
            return notLogicalDuplicate;
        }
    }

    private static class LiquorfileMissingHighlighter
    extends AbstractHighlighter {
        private Color LFID_MISSING = new Color(220, 80, 80);

        protected Component doHighlight(Component component, ComponentAdapter adapter) {
            if (adapter.column == 3 && adapter.getFilteredValueAt(adapter.row, adapter.column) == null) {
                component.setBackground(this.LFID_MISSING);
            }
            return component;
        }
    }

    static class UpdateTask
    extends AbstractTask {
        private File file;

        public UpdateTask(File fileToImport) {
            this.file = fileToImport;
        }

        public String getName() {
            return "Importing Usage Links...";
        }

        protected int getTotalSubTasks() {
            return -1;
        }

        protected void performTask() throws Exception {
            boolean fine = PricebookManager.getInstance().importLiquorfileIds(this.file);
            this.emitProgress();
            if (!fine) {
                throw new IOException("Error reading PricebookLinking file.");
            }
        }
    }
}

