/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.options;

import au.com.ordermate.application.ApplicationFrame;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.guicore.task.AbstractGuiTask;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.sql.SQL;
import au.com.ordermate.sql.queries.SelectQuery;
import au.com.ordermate.util.DateDMY;
import au.com.ordermate.util.GuiUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.print.Printing;
import officemate.adminkit.search.SearchDialog;
import officemate.adminkit.searchpanels.InventoryOptionSearchPanel;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.table.GroupedTable;
import officemate.adminkit.table.GroupedTableModel;
import officemate.adminkit.table.PriceGroupedTableModel;
import officemate.adminkit.templates.Templates;
import officemate.adminkit.tree.DefaultObjectTree;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.screens.setup.stock.ingredients.IngredientEditor;
import officemate.screens.setup.stock.ingredients.IngredientsPanel;
import officemate.screens.setup.stock.ingredients.UsageCostProfitPanel;
import officemate.screens.setup.stock.options.OptionsUsageGroupedTable;
import officemate.screens.setup.stock.options.OptionsUsageGroupedTableCellRenderer;
import officemate.screens.setup.stock.options.OptionsUsageTable;
import officemate.screens.setup.stock.options.OptionsUsageTableInterface;
import officemate.screens.setup.stock.options.OptionsUsageTableModel;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.stock.usagelink.StockUsageOptionLink;
import ordermate.database.users.AllPermissions;

public class OptionsUsageState
extends BasicOfficeMateState {
    private static final String STOCK_USAGE_PROP = "Stock Usage";
    static final int OPTION_GROUP_NAME_TABLE_INDEX = 0;
    static final String DB_MENU_OPTION_ID = "inventory_option.ID";
    static final String DB_MENU_OPTION_NAME = "inventory_option.Name";
    static final String DB_MENU_OPTION_GROUP_NAME = "inventory_option_group.Name";
    static final String DB_INGRED_MEASURE_UNIT = "stock_item.IngredientMeasureUnit";
    static final String DB_NUM_INGREDIENTS = "NumIngredients";
    static final String DB_INGREDIENT_QTY = "IngredientQty";
    static final String DB_INGREDIENT_COST = "IngredientCost";
    static final String DB_SALES = "inventory_option.Price";
    static final String DB_ACTUAL_COST = "ActualCost";
    private static final String DB_NUM_INGREDIENTS_FORMULA = "COUNT(DISTINCT stock_item.ID)";
    private static final String DB_INGREDIENT_COST_FORMULA = "SUM(stock_inventory_mod_link.Quantity * stock_item.CurrentCost / stock_item.Quantity)";
    private static final String DISPLAYLABEL_GROUP = "Group";
    private UsageCostProfitPanel stockCostPanel;
    private JPanel innerPanel;
    private JPanel northWestPanel;
    private JPanel northPanel;
    private JSplitPane splitter;
    private DefaultObjectTree treePanel = null;
    private OptionsUsageGroupedTable groupedTable;
    private JCheckBox groupedCheck;
    private boolean groupResults = true;
    private OptionsUsageTable table;
    private OptionsUsageTableModel tableModel;
    private SelectQuery baseQuery;
    private ObjectTemplate optionTemplate;
    private JPanel rightPanel;
    private JCheckBox hideProfitableCheck;
    private IngredientsPanel<InventoryOption, StockUsageOptionLink> ingredientsPanel;
    private IngredientEditor<InventoryOption, StockUsageOptionLink> ingredientsEditor;
    private boolean alreadySetup = false;
    private boolean allowUpdate = true;
    private final RefreshAction refreshAction = new RefreshAction((Refreshable)this);

    public OptionsUsageState() {
        super("Option Ingredients", AllPermissions.ACCESS_OPTION_INGREDIENTS_SCREEN, "Configure the ingredients consumed by menu options");
        this.optionTemplate = Templates.MENU_OPTION;
        this.innerPanel = new JPanel(new BorderLayout());
        this.innerPanel.setName("Option Ingredients");
        this.setScreenPanel(this.innerPanel);
    }

    @Override
    protected void onStart() {
        ApplicationFrame frame = GuiApp.getAppComplex().getApplicationFrame();
        frame.setStatusBarText("Loading menu ingredients setup screen...");
        if (!this.alreadySetup) {
            this.alreadySetup = Dialogs.showProgressDialog((AbstractTask)new OptionsUsageSetupTask());
            if (!this.alreadySetup) {
                Dialogs.showErrorDialog("Error Loading Screen", "Please contact OrderMate Support");
                return;
            }
        } else {
            this.refresh();
        }
        frame.resetStatusBarText();
    }

    @Override
    protected void onEnd() {
    }

    private void setupComboAndButtons() {
        JPanel buttonPanel = new JPanel(new GridLayout(1, 3));
        this.northWestPanel = new JPanel(new FlowLayout());
        this.northPanel = new JPanel(new BorderLayout());
        this.addAction((Action)this.refreshAction);
        this.addAction((Action)new BasicAction("Print", IconLoader.get((String)"/ordermate/images/print_icon22.png"), "Print"){

            public void actionPerformed(ActionEvent e) {
                OptionsUsageState.this.printReport();
            }
        });
        this.addAction((Action)new BasicAction("Search", IconLoader.get((String)"/ordermate/images/search22.png"), "Search"){

            public void actionPerformed(ActionEvent e) {
                OptionsUsageState.this.search();
            }
        });
        this.hideProfitableCheck = new JCheckBox("Hide profitable", false);
        this.hideProfitableCheck.setToolTipText("Hides correctly configured and profitable items");
        this.northWestPanel.add(this.hideProfitableCheck);
        this.hideProfitableCheck.addActionListener((ActionListener)this.refreshAction);
        this.northPanel.add((Component)this.northWestPanel, "West");
        this.northPanel.add((Component)buttonPanel, "East");
        this.innerPanel.add((Component)this.northPanel, "North");
    }

    private void setupGroupCheck() {
        this.groupedCheck = new JCheckBox("Group results", this.groupResults);
        this.northWestPanel.add((Component)this.groupedCheck, "West");
        this.groupedCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsUsageState.this.groupResults = OptionsUsageState.this.groupedCheck.isSelected();
                OptionsUsageState.this.refresh();
            }
        });
    }

    private void setupTree() {
        List groups = InventoryOptionGroup.getOptionGroups();
        this.treePanel = new DefaultObjectTree(groups, this.optionTemplate);
        this.treePanel.objectSelected.connect((Object)this, "gotTreeObjectSelected");
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(IconLoader.get((String)"/ordermate/images/group_purple.png"));
        renderer.setOpenIcon(IconLoader.get((String)"/ordermate/images/purple_folder.png"));
        renderer.setClosedIcon(IconLoader.get((String)"/ordermate/images/purple_folder.png"));
        this.treePanel.setCellRenderer(renderer);
        JScrollPane scrollPane = new JScrollPane(this.treePanel);
        scrollPane.setPreferredSize(new Dimension(160, 300));
        scrollPane.setMinimumSize(new Dimension(120, 300));
        this.splitter.setLeftComponent(scrollPane);
    }

    private void setupTable() {
        this.baseQuery = SQL.createQuery((String[])new String[]{"inventory_option JOIN inventory_option_group ON inventory_option.FK_inventory_option_group = inventory_option_group.ID LEFT JOIN stock_inventory_mod_link ON stock_inventory_mod_link.FK_inventory_option = inventory_option.ID LEFT JOIN stock_item ON stock_inventory_mod_link.FK_stock_item = stock_item.ID AND " + SQL.isActive((String)"stock_item")});
        this.baseQuery.addSelectValue(DB_MENU_OPTION_ID);
        this.baseQuery.addSelectValue(DB_MENU_OPTION_NAME);
        this.baseQuery.addSelectValue(DB_MENU_OPTION_GROUP_NAME);
        this.baseQuery.addSelectValue(DB_INGRED_MEASURE_UNIT);
        this.baseQuery.addSelectValue("COUNT(DISTINCT stock_item.ID) AS NumIngredients");
        this.baseQuery.addSelectValue("stock_inventory_mod_link.Quantity AS IngredientQty");
        this.baseQuery.addSelectValue("SUM(stock_inventory_mod_link.Quantity * stock_item.CurrentCost / stock_item.Quantity) AS IngredientCost");
        this.baseQuery.addSelectValue(DB_SALES);
        this.baseQuery.addSelectValue("SUM(stock_inventory_mod_link.Quantity * stock_item.CurrentCost / stock_item.Quantity) AS ActualCost");
        this.addWheresToQuery();
        String[] dbColumns = new String[]{DB_MENU_OPTION_GROUP_NAME, DB_MENU_OPTION_NAME, DB_INGREDIENT_QTY};
        String[] displayColumns = new String[]{DISPLAYLABEL_GROUP, "Name", "Usage"};
        this.tableModel = new OptionsUsageTableModel(this.baseQuery, GuiApp.getAppComplex().getApplicationContext().getDatabaseConnection(), DB_MENU_OPTION_ID, dbColumns, displayColumns);
        this.baseQuery.addOrderBy(DB_MENU_OPTION_NAME, true);
        this.baseQuery.addGroupBy(DB_MENU_OPTION_ID);
        this.table = new OptionsUsageTable(this.tableModel, GuiApp.getAppComplex().getApplicationContext());
        OfficeMateAdminGuiUtils.getInstance().standardTableSetup(this.table);
        this.table.itemsAdded.connect((Object)this, "gotTableItemsAdded");
        this.table.objectSelected.connect((Object)this, "gotTableObjectSelected");
        this.table.objectDeselected.connect((Object)this, "gotTableObjectDeselected");
        this.table.objectChosen.connect((Object)this, "gotTableObjectChosen");
        this.rightPanel = new JPanel(new BorderLayout());
        this.rightPanel.add((Component)this.table.getScroller(), "Center");
    }

    private JTable getActiveTable() {
        return this.groupResults ? this.groupedTable : this.table;
    }

    private GroupedTable getNewGroupedTable() {
        PriceGroupedTableModel model = new PriceGroupedTableModel((AbstractTableModel)this.table.getModel(), DISPLAYLABEL_GROUP, new String[0]);
        this.groupedTable = new OptionsUsageGroupedTable((GroupedTableModel)model, GuiApp.getAppComplex().getApplicationContext());
        OfficeMateAdminGuiUtils.getInstance().standardTableSetup((JTable)((Object)this.groupedTable));
        this.groupedTable.setCellRendererForAll(new OptionsUsageGroupedTableCellRenderer());
        this.groupedTable.putClientProperty("useDTCRColorMemoryHack", Boolean.FALSE);
        this.groupedTable.itemsAdded.connect((Object)this, "gotTableItemsAdded");
        this.groupedTable.objectChosen.connect((Object)this, "gotGroupedTableObjectChosen");
        this.groupedTable.objectSelected.connect((Object)this, "gotGroupedTableObjectSelected");
        return this.groupedTable;
    }

    private void addWheresToQuery() {
        this.baseQuery.clearWhere();
        this.baseQuery.clearHaving();
        this.baseQuery.addWhere(SQL.isActive((String)"inventory_option"));
        this.baseQuery.addWhere(SQL.isActive((String)"inventory_option_group"));
    }

    private void updateQuery() {
        this.updateQuery(this.getCurrentOptionGroup(), true);
    }

    private void updateQuery(InventoryOptionGroup group, boolean selectFirstRow) {
        this.addWheresToQuery();
        if (group != null) {
            this.baseQuery.addWhere("inventory_option_group.ID = " + group.getID());
        }
        if (this.hideProfitableCheck.isSelected()) {
            this.baseQuery.addHaving("(NumIngredients = 0 OR ActualCost > inventory_option.Price)");
        }
        if (this.groupResults) {
            this.baseQuery.clearOrderBy();
            this.baseQuery.addOrderBy(DB_MENU_OPTION_GROUP_NAME);
            this.baseQuery.addOrderBy(DB_MENU_OPTION_NAME);
        }
        this.table.updateModel(selectFirstRow);
        this.rightPanel.remove(this.table.getScroller());
        if (this.groupedTable != null) {
            this.rightPanel.remove(this.groupedTable.getScroller());
        }
        if (this.groupResults) {
            this.rightPanel.add((Component)this.getNewGroupedTable().getScroller(), "Center");
        } else {
            this.rightPanel.add((Component)this.table.getScroller(), "Center");
        }
        this.rightPanel.revalidate();
        this.rightPanel.repaint();
    }

    private void setupSideBar() {
        JPanel topRightPanel = new JPanel(new BorderLayout());
        this.stockCostPanel = new UsageCostProfitPanel();
        this.ingredientsEditor = IngredientEditor.create(SaveStrategyFactory.getInstantSaveStrategy(), null, StockUsageOptionLink.class);
        this.ingredientsPanel = new IngredientsPanel<InventoryOption, StockUsageOptionLink>(null, this.stockCostPanel, this.ingredientsEditor, 350);
        this.ingredientsPanel.getGuiComponent().setBorder(BorderFactory.createTitledBorder("Ingredients"));
        this.ingredientsPanel.getIngredientEditor().objectEdited.connect((Object)this, "gotIngredientsModified");
        topRightPanel.add((Component)this.ingredientsPanel.getGuiComponent(), "Center");
        this.rightPanel.add((Component)topRightPanel, "South");
        JPanel stockCostWrapper = new JPanel(new BorderLayout());
        stockCostWrapper.add((Component)this.stockCostPanel, "North");
        topRightPanel.add((Component)stockCostWrapper, "West");
        this.splitter.setRightComponent(this.rightPanel);
        this.splitter.setDividerLocation(160);
    }

    @Override
    public void refresh() {
        this.refresh(true);
    }

    public void refresh(boolean selectFirstRow) {
        ApplicationFrame frame = GuiApp.getAppComplex().getApplicationFrame();
        this.allowUpdate = false;
        frame.setStatusBarText("Refreshing Menu Ingredients screen...");
        if (this.treePanel != null) {
            Object treeObj = this.treePanel.getSelectedObject();
            this.treePanel.setRootObjects(InventoryOptionGroup.getOptionGroups());
            this.treePanel.setSelectedObject(treeObj);
            Long selectedID = OfficeMateAdminGuiUtils.getInstance().getSelectedID(this.table, this.groupResults ? this.groupedTable : null);
            int selectedTableRow = OfficeMateAdminGuiUtils.getInstance().getSelectedTableRow(this.table, this.groupResults ? this.groupedTable : null);
            this.updateQuery(this.getCurrentOptionGroup(), selectFirstRow);
            OfficeMateAdminGuiUtils.getInstance().selectIfPossible(this.table, this.groupResults ? this.groupedTable : null, selectedID, selectedTableRow);
            frame.resetStatusBarText();
        }
        this.allowUpdate = true;
    }

    public void search() {
        SearchDialog searchDialog = new SearchDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), new InventoryOptionSearchPanel(), "Find Option...");
        searchDialog.setVisible(true);
        InventoryOption itemFound = (InventoryOption)searchDialog.getFoundObject();
        if (itemFound != null && !searchDialog.wasCancelled()) {
            this.allowUpdate = false;
            this.hideProfitableCheck.setSelected(false);
            this.treePanel.setSelectedObject(null);
            this.allowUpdate = true;
            this.updateQuery();
            this.scrollToAndSelectObject(itemFound);
        }
    }

    private void scrollToAndSelectObject(InventoryOption option) {
        int tableRow = this.tableModel.getRow(option.intID());
        JScrollPane scrollerToUse = this.table.getScroller();
        OptionsUsageTableInterface tableToUse = this.table;
        if (this.groupResults) {
            tableRow = this.groupedTable.getGroupedTableModel().getGroupedRow(tableRow);
            scrollerToUse = this.groupedTable.getScroller();
            tableToUse = this.groupedTable;
        }
        tableToUse.setRowSelectionInterval(tableRow, tableRow);
        GuiUtils.scrollToTableRow((JScrollPane)scrollerToUse, (JTable)((Object)tableToUse), (int)tableRow);
    }

    private void editSideBar() {
        if (this.ingredientsEditor.getObjectTable().getSelectedObject() == null) {
            this.ingredientsEditor.newElement();
        } else {
            this.ingredientsEditor.editSelectedElement();
        }
        this.getActiveTable().requestFocus();
    }

    private void printReport() {
        InventoryOptionGroup group = this.getCurrentOptionGroup();
        String groupString = group != null ? " Group: " + group.getLabel() : "";
        String title = "Menu Ingredients Summary (" + new DateDMY(System.currentTimeMillis()) + ")";
        Printing.printJTableReport(this.getActiveTable(), title, groupString, 8);
    }

    private InventoryOptionGroup getCurrentOptionGroup() {
        Object o = this.treePanel.getSelectedObject();
        if (o instanceof InventoryOptionGroup) {
            return (InventoryOptionGroup)o;
        }
        return null;
    }

    private InventoryOption getCurrentOption() {
        if (this.table != null) {
            if (this.groupResults && this.groupedTable != null) {
                int selRow = this.groupedTable.getSelectedRow();
                int originalRow = this.groupedTable.getGroupedTableModel().getOriginalRow(selRow);
                Long objID = this.table.getQueryTableModel().getID(originalRow);
                return OptionsUsageTable.getObjectForID(objID);
            }
            return this.table.getCurrentOption();
        }
        return null;
    }

    void gotTableItemsAdded() {
        this.refresh(false);
    }

    private void updateSidebarEnabledState() {
        if (this.ingredientsPanel != null) {
            InventoryOption option = this.getCurrentOption();
            if (option == null || !StockItemQueries.stockItemsExist()) {
                this.stockCostPanel.updateForStockLinkableObject(null);
                this.ingredientsEditor.setObject(null);
                this.ingredientsPanel.getGuiComponent().setEnabled(false);
                this.stockCostPanel.setEnabled(false);
            } else {
                this.ingredientsPanel.getGuiComponent().setEnabled(true);
                this.ingredientsPanel.setObject(option);
                boolean unconfigured = option.getStockUsage().isEmpty() && option.getCustomStockCost() == null;
                ApplicationFrame frame = GuiApp.getAppComplex().getApplicationFrame();
                if (unconfigured) {
                    frame.setStatusBarText("UNCONFIGURED OPTION", Color.RED);
                } else if (!option.isProfitable()) {
                    frame.setStatusBarText("UNPROFITABLE OPTION", Color.RED);
                } else {
                    frame.resetStatusBarText();
                }
            }
        }
    }

    void gotTreeObjectSelected(Object obj) {
        if (this.allowUpdate) {
            InventoryOptionGroup group = null;
            if (obj instanceof InventoryOptionGroup) {
                group = (InventoryOptionGroup)obj;
            }
            this.updateQuery(group, true);
        }
    }

    private void gotTableObjectChosen() {
        if (this.ingredientsPanel.getGuiComponent().isEnabled()) {
            this.editSideBar();
        }
    }

    private void gotTableObjectSelected(Long objectID) {
        int id = -1;
        if (objectID != null) {
            id = objectID.intValue();
        }
        InventoryOption option = null;
        if (id != -1) {
            option = InventoryOption.getOptionByID((long)id);
            if (this.ingredientsPanel != null) {
                this.ingredientsPanel.setObject(option);
            }
        }
        this.updateSidebarEnabledState();
    }

    public void gotGroupedTableObjectChosen() {
        this.gotTableObjectChosen();
    }

    public void gotGroupedTableObjectSelected(Integer selIndex) {
        int index = selIndex;
        int oldIndex = this.groupedTable.getGroupedTableModel().getOriginalRow(index);
        if (oldIndex != -1) {
            Long objID = this.tableModel.getID(oldIndex);
            this.gotTableObjectSelected(objID);
        } else {
            this.gotTableObjectSelected(null);
        }
    }

    void gotTableObjectDeselected() {
    }

    private void gotIngredientsModified() {
        this.refresh(false);
        this.rightPanel.revalidate();
        this.rightPanel.repaint();
    }

    private class OptionsUsageSetupTask
    extends AbstractGuiTask {
        private OptionsUsageSetupTask() {
        }

        public String getName() {
            return "Loading menu ingredients setup screen...";
        }

        public void doGuiTask() throws Exception {
            OptionsUsageState.this.splitter = new JSplitPane(1);
            OptionsUsageState.this.innerPanel.setVisible(false);
            OptionsUsageState.this.setupTable();
            this.emitProgress();
            OptionsUsageState.this.setupSideBar();
            this.emitProgress();
            OptionsUsageState.this.setupComboAndButtons();
            this.emitProgress();
            OptionsUsageState.this.setupGroupCheck();
            this.emitProgress();
            OptionsUsageState.this.setupTree();
            this.emitProgress();
            OptionsUsageState.this.innerPanel.add((Component)OptionsUsageState.this.splitter, "Center");
            OptionsUsageState.this.innerPanel.setVisible(true);
            OptionsUsageState.this.refresh();
            this.emitProgress();
        }

        public int getTotalSubTasks() {
            return 6;
        }
    }
}

