/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.options;

import au.com.ordermate.application.ApplicationContext;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.util.StringUtils;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.table.QueryTable;
import officemate.screens.ObjectManagerI;
import officemate.screens.setup.stock.options.OptionsUsageTableInterface;
import officemate.screens.setup.stock.options.OptionsUsageTableModel;
import officemate.screens.setup.stock.options.StockLinkableQueryTableCellRenderer;
import ordermate.database.config.MeasureUnit;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.config.Quantity;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockSupplier;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import stockmate.database.interfaces.stock.MeasureUnitI;

public class OptionsUsageTable
extends QueryTable
implements OptionsUsageTableInterface {
    public final Signal itemsAdded = Signals.createSignal();
    private ApplicationContext context;

    public OptionsUsageTable(OptionsUsageTableModel model, ApplicationContext appContext) {
        super(model);
        this.context = appContext;
        OptionsUsageTable.addPopupMenuToTable(this, this.context);
        StockLinkableQueryTableCellRenderer renderer = new StockLinkableQueryTableCellRenderer();
        this.setCellRendererForAll(renderer);
        this.setDefaultRenderer(String.class, renderer);
    }

    public static void addPopupMenuToTable(OptionsUsageTableInterface tableInterface, ApplicationContext appContext) {
        JTable table = tableInterface.getJTable();
        JPopupMenu autoCreateStockMenu = new JPopupMenu();
        JMenuItem autoCreateItem = new JMenuItem("Auto-link stock");
        JMenuItem autoCreateAllItem = new JMenuItem("Auto-link all visible");
        InnerMenuListener menuListener = new InnerMenuListener(tableInterface, autoCreateItem, autoCreateAllItem, appContext);
        autoCreateItem.addActionListener(menuListener);
        autoCreateAllItem.addActionListener(menuListener);
        autoCreateStockMenu.add(autoCreateItem);
        autoCreateStockMenu.add(autoCreateAllItem);
        table.addMouseListener(new TableRightClickListener(table, autoCreateStockMenu));
    }

    @Override
    public void updateModel() {
        this.updateModel(true);
    }

    public void updateModel(boolean selectFirstRow) {
        super.updateModel();
        if (selectFirstRow) {
            int rowToSet = 0;
            if (this.getRowCount() > rowToSet) {
                int currentRow = this.getSelectedRow();
                if (currentRow != rowToSet) {
                    this.setRowSelectionInterval(rowToSet, rowToSet);
                } else {
                    this.objectSelected.emit((Object)new Long(this.getSelectedObjectID()));
                }
            } else {
                this.objectSelected.emit(null);
            }
        }
    }

    public OptionsUsageTableModel getOptionsUsageModel() {
        return (OptionsUsageTableModel)this.getModel();
    }

    @Override
    public InventoryOption getCurrentOption() {
        return OptionsUsageTable.getObjectForID(this.getSelectedObjectID());
    }

    @Override
    public List<InventoryOption> getCurrentlyVisibleOptions() {
        OptionsUsageTableModel tableModel = this.getOptionsUsageModel();
        int numRows = tableModel.getRowCount();
        ArrayList<InventoryOption> retval = new ArrayList<InventoryOption>(numRows);
        for (int i = 0; i < numRows; ++i) {
            Long id = tableModel.getID(i);
            retval.add(OptionsUsageTable.getObjectForID(id));
        }
        return retval;
    }

    @Override
    public String getCurrentOptionGroupName() {
        OptionsUsageTableModel tableModel = this.getOptionsUsageModel();
        String groupName = (String)tableModel.getValueAt(this.getSelectedRow(), 0);
        return groupName;
    }

    @Override
    public List<String> getCurrentlyVisibleOptionGroupNames() {
        OptionsUsageTableModel tableModel = this.getOptionsUsageModel();
        int numRows = tableModel.getRowCount();
        ArrayList<String> retval = new ArrayList<String>(numRows);
        for (int i = 0; i < numRows; ++i) {
            String groupName = (String)tableModel.getValueAt(i, 0);
            retval.add(groupName);
        }
        return retval;
    }

    public static InventoryOption getObjectForID(Long selID) {
        InventoryOption option = null;
        if (selID != null && selID >= 0L) {
            option = InventoryOption.getOptionByID((long)selID);
        }
        return option;
    }

    public InventoryOption getObjectForRow(int row) {
        return OptionsUsageTable.getObjectForID(this.getOptionsUsageModel().getID(row));
    }

    private static StockGroup getStockGroupForMenuOptionGroupName(String optionGroup, ApplicationContext context) {
        StockGroup group = null;
        String groupName = optionGroup;
        group = StockGroup.getStockGroupForName((String)(groupName = StringUtils.cleanStringForSQL((String)groupName)));
        if (group == null) {
            group = new StockGroup();
            group.setLabel(groupName);
            group.save();
        }
        return group;
    }

    public static StockItem linkStockItemForOption(InventoryOption option, ObjectManager manager, StockSupplier defaultSupplier, String currentOptionGroup, StockGroup defaultStockGroup, ApplicationContext appContext) {
        String name = StringUtils.cleanStringForSQL((String)option.getLabel());
        StockItem stockItem = StockItem.getStockItemForName((String)name);
        if (stockItem == null) {
            StockGroup group = OptionsUsageTable.getStockGroupForMenuOptionGroupName(currentOptionGroup, appContext);
            if (group == null) {
                group = defaultStockGroup;
            }
            stockItem = new StockItem();
            stockItem.setName(name);
            MeasureUnit units = MeasureUnitHelper.getMeasureUnit((String)"units");
            stockItem.setPurchaseQty(units, 1.0);
            stockItem.setIngredientMeasureUnit((MeasureUnitI)units);
            stockItem.setStockGroup(group);
            stockItem.addSupplier(defaultSupplier);
            stockItem.save();
            manager.saveObject(stockItem, manager.getTemplate(StockItem.class));
        }
        Quantity qty = new Quantity(stockItem.getIngredientMeasureUnit(), 1.0, false);
        option.setStockUsage(stockItem, qty);
        option.saveChild();
        return stockItem;
    }

    public boolean isRowCostConfigured(int row) {
        return this.getOptionsUsageModel().isRowCostConfigured(row);
    }

    public boolean isRowProfitable(int row) {
        return this.getOptionsUsageModel().isRowProfitable(row);
    }

    @Override
    public JTable getJTable() {
        return this;
    }

    @Override
    public void onItemsAdded() {
        this.itemsAdded.emit();
    }

    private static class TableRightClickListener
    extends MouseAdapter {
        private JTable table;
        private JPopupMenu menu;

        TableRightClickListener(JTable theTable, JPopupMenu theMenu) {
            this.table = theTable;
            this.menu = theMenu;
        }

        private void onRightClick(MouseEvent e) {
            int row = this.table.rowAtPoint(new Point(e.getX(), e.getY()));
            if (row >= 0 && row < this.table.getRowCount()) {
                this.table.setRowSelectionInterval(row, row);
            }
            if (e.isPopupTrigger()) {
                this.menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.onRightClick(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.onRightClick(e);
        }
    }

    private static class InnerMenuListener
    implements ActionListener {
        private JMenuItem autoCreateItem;
        private JMenuItem autoCreateAllItem;
        private OptionsUsageTableInterface table;
        private ObjectManager manager;
        private ApplicationContext appContext;

        public InnerMenuListener(OptionsUsageTableInterface theTable, JMenuItem autoCreateMenuItem, JMenuItem autoCreateAllMenuItem, ApplicationContext theAppContext) {
            this.appContext = theAppContext;
            this.autoCreateItem = autoCreateMenuItem;
            this.autoCreateAllItem = autoCreateAllMenuItem;
            this.table = theTable;
            this.manager = ((ObjectManagerI)this.appContext).getObjectManager();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StockSupplier defaultSupplier = (StockSupplier)StockSupplier.getSuppliers().get(0);
            StockGroup defaultStockGroup = (StockGroup)StockGroup.getTopLevelStockGroups().get(0);
            if (e.getSource() == this.autoCreateItem) {
                InventoryOption currentOption = this.table.getCurrentOption();
                String currentOptionGroup = this.table.getCurrentOptionGroupName();
                if (currentOption.getStockUsage().isEmpty()) {
                    OptionsUsageTable.linkStockItemForOption(currentOption, this.manager, defaultSupplier, currentOptionGroup, defaultStockGroup, this.appContext);
                    this.table.onItemsAdded();
                }
            } else if (e.getSource() == this.autoCreateAllItem) {
                Dialogs.showProgressDialog(new AutoCreateItemsTask());
            }
        }

        private class AutoCreateItemsTask
        extends AbstractTask {
            List optionList;
            List optionGroupNameList;
            StockSupplier defaultSupplier;
            StockGroup defaultStockGroup;

            private AutoCreateItemsTask() {
                this.optionList = InnerMenuListener.this.table.getCurrentlyVisibleOptions();
                this.optionGroupNameList = InnerMenuListener.this.table.getCurrentlyVisibleOptionGroupNames();
                this.defaultSupplier = (StockSupplier)StockSupplier.getSuppliers().get(0);
                this.defaultStockGroup = (StockGroup)StockGroup.getTopLevelStockGroups().get(0);
            }

            public String getName() {
                return "Auto-creating stock items...";
            }

            public void performTask() throws Exception {
                for (int i = 0; i < this.optionList.size(); ++i) {
                    InventoryOption option = (InventoryOption)this.optionList.get(i);
                    if (!option.getStockUsage().isEmpty()) continue;
                    String optionGroup = (String)this.optionGroupNameList.get(i);
                    OptionsUsageTable.linkStockItemForOption(option, InnerMenuListener.this.manager, this.defaultSupplier, optionGroup, this.defaultStockGroup, InnerMenuListener.this.appContext);
                    this.emitProgress();
                }
                InnerMenuListener.this.table.onItemsAdded();
            }

            public int getTotalSubTasks() {
                return this.optionList.size();
            }
        }
    }
}

