/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.options;

import au.com.ordermate.sql.queries.SelectQuery;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import officemate.adminkit.table.QueryTableModel;
import ordermate.database.DBConnectionInterface;
import ordermate.database.config.MeasureUnit;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.config.Quantity;
import stockmate.database.interfaces.stock.MeasureUnitI;

public class OptionsUsageTableModel
extends QueryTableModel {
    private List profitable = new Vector();
    private List costConfigured = new Vector();

    public OptionsUsageTableModel(SelectQuery selQuery, DBConnectionInterface dc, String idField, String[] colNames, String[] colDisplayNames) {
        super(selQuery, dc, idField, colNames, colDisplayNames);
    }

    @Override
    public void update() {
        this.profitable.clear();
        this.costConfigured.clear();
        super.update();
    }

    @Override
    protected Object getTableValue(int row, int col, String dbColName, int dbColIndex, ResultSet rs) throws SQLException {
        if (col == 0) {
            double numIngredients = rs.getInt("NumIngredients");
            double cost = rs.getDouble("ActualCost");
            double sales = rs.getDouble("inventory_option.Price");
            boolean isConfigured = numIngredients > 0.0;
            boolean isProfitable = cost <= sales;
            this.profitable.add(isProfitable);
            this.costConfigured.add(isConfigured);
        }
        if (dbColName.equals("IngredientQty")) {
            String retval = "";
            int numIngredients = rs.getInt("NumIngredients");
            if (numIngredients == 0) {
                retval = "(empty)";
            } else if (numIngredients == 1) {
                String measure = rs.getString("stock_item.IngredientMeasureUnit");
                MeasureUnit unit = MeasureUnitHelper.getMeasureUnit((String)measure);
                double ingredQty = rs.getDouble("IngredientQty");
                retval = new Quantity((MeasureUnitI)unit, ingredQty, true).toString();
            } else {
                retval = "(" + numIngredients + " items)";
            }
            return retval;
        }
        return super.getTableValue(row, col, dbColName, dbColIndex, rs);
    }

    public boolean isRowCostConfigured(int row) {
        Boolean b = (Boolean)this.costConfigured.get(row);
        return b;
    }

    public boolean isRowProfitable(int row) {
        Boolean b = (Boolean)this.profitable.get(row);
        return b;
    }
}

