/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.suppliers;

import au.com.ordermate.application.ApplicationFrame;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.sql.SQL;
import au.com.ordermate.sql.queries.SelectQuery;
import au.com.ordermate.util.Assert;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import officemate.adminkit.ObjectEditorPanel;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.ObjectEditorDialog;
import officemate.adminkit.search.SearchDialog;
import officemate.adminkit.searchpanels.StockSupplierSearchPanel;
import officemate.adminkit.state.ActionFactory;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.table.QueryTable;
import officemate.adminkit.table.QueryTableModel;
import officemate.adminkit.templates.Templates;
import officemate.screens.ObjectManagerI;
import ordermate.database.misc.StockControlEventLog;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.stock.StockSupplier;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;

public class SetupSuppliersState
extends BasicOfficeMateState {
    private static final String DB_STOCK_SUPPLIER_ID = "stock_supplier.ID";
    private static final String DB_STOCK_SUPPLIER_NAME = "stock_supplier.Name";
    private JPanel innerPanel = new JPanel(new GridLayout(1, 1));
    private JPanel tablePanel;
    private SelectQuery baseQuery;
    private QueryTable table;
    private QueryTableModel tableModel;

    public SetupSuppliersState() {
        super("Suppliers", AllPermissions.ACCESS_SUPPLIERS_SCREEN, "View, create and modify suppliers");
        this.setScreenPanel(this.innerPanel);
        this.addAction((Action)ActionFactory.createPermissibleNewAction(this, AllPermissions.ADD_SUPPLIERS));
        this.addAction((Action)ActionFactory.createPermissibleEditAction(this, AllPermissions.EDIT_SUPPLIERS));
        this.addAction((Action)ActionFactory.createPermissibleDeleteAction(this, AllPermissions.DELETE_SUPPLIERS));
    }

    @Override
    protected void onStart() {
        ApplicationFrame frame = GuiApp.getAppComplex().getApplicationFrame();
        frame.setStatusBarText("Loading supplier setup screen...");
        if (this.isFirstRun()) {
            this.setupTable();
            this.refresh();
            if (this.table.getModel().getRowCount() > 0) {
                this.table.getSelectionModel().setSelectionInterval(0, 0);
            }
        } else {
            this.refresh();
        }
        frame.resetStatusBarText();
    }

    @Override
    protected void onEnd() {
    }

    @Override
    public void doRefreshAction() {
        this.refresh();
    }

    @Override
    public void refresh() {
        this.table.updateModel();
        this.table.revalidate();
        this.table.repaint();
    }

    @Override
    public boolean supportsRefresh() {
        return true;
    }

    @Override
    public boolean supportsSearch() {
        return true;
    }

    @Override
    public void doNewAction() {
        this.addObject();
    }

    private void setupTable() {
        this.baseQuery = SQL.createQuery((String[])new String[]{"stock_supplier"});
        this.baseQuery.addSelectValue(DB_STOCK_SUPPLIER_ID);
        this.baseQuery.addSelectValue(DB_STOCK_SUPPLIER_NAME);
        this.addWheresToQuery();
        String[] dbColumns = new String[]{DB_STOCK_SUPPLIER_NAME};
        String[] displayColumns = new String[]{"Name"};
        this.tableModel = new QueryTableModel(this.baseQuery, GuiApp.getAppComplex().getApplicationContext().getDatabaseConnection(), DB_STOCK_SUPPLIER_ID, dbColumns, displayColumns);
        this.baseQuery.addOrderBy(DB_STOCK_SUPPLIER_NAME, true);
        this.table = new QueryTable(this.tableModel);
        OfficeMateAdminGuiUtils.getInstance().standardTableSetup(this.table);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SetupSuppliersState.this.gotTableObjectSelected();
                }
            }
        });
        this.table.addMouseListener(new InnerInputListener());
        this.table.addKeyListener(new InnerInputListener());
        this.tablePanel = new JPanel(new BorderLayout());
        JPanel addRemoveWrapper = new JPanel(new BorderLayout());
        this.tablePanel.add((Component)this.table.getScroller(), "Center");
        JPanel centrePanel = new JPanel(new BorderLayout());
        centrePanel.add((Component)addRemoveWrapper, "East");
        centrePanel.add((Component)this.tablePanel, "Center");
        this.innerPanel.add(centrePanel);
    }

    private void addWheresToQuery() {
        this.baseQuery.clearWhere();
        this.baseQuery.addWhere(SQL.isActive((String)"stock_supplier"));
    }

    public void gotTableObjectSelected() {
        boolean isObjectSelected = this.table.getSelectedRow() != -1;
        this.toggleDefaultAction(this.getEditAction(), isObjectSelected);
        this.toggleDefaultAction(this.getDeleteAction(), isObjectSelected);
    }

    private void addObject() {
        Object createdObj = null;
        ApplicationFrame frame = GuiApp.getAppComplex().getApplicationFrame();
        frame.setStatusBarText("Creating " + Templates.STOCK_SUPPLIER + "...");
        ObjectEditorPanel editorView = Templates.STOCK_SUPPLIER.getNewEditPanel(null);
        if (ObjectEditorDialog.doDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), editorView) == 0) {
            editorView.saveObject();
            createdObj = editorView.getEditedObject();
            Assert.isTrue((createdObj != null ? 1 : 0) != 0, (String)"Failed to create a StockSupplier");
            ((ObjectManagerI)GuiApp.getAppComplex().getApplicationContext()).getObjectManager().saveObject(createdObj, Templates.STOCK_SUPPLIER);
            SystemCurrentInfo.setUpdate((String)("Changes saved [" + createdObj + "]"));
            StockControlEventLog.logCreateStockSupplier((User)this.getUser(), (StockSupplier)((StockSupplier)createdObj));
            this.refresh();
        } else {
            editorView.cancelObject();
        }
        frame.resetStatusBarText();
    }

    @Override
    public void doEditAction() {
        ApplicationFrame frame = GuiApp.getAppComplex().getApplicationFrame();
        StockSupplier editedObj = this.getCurrentStockSupplier();
        frame.setStatusBarText("Editing " + Templates.STOCK_SUPPLIER + ":  " + Templates.STOCK_SUPPLIER.getObjectText(editedObj));
        ObjectEditorPanel editorView = Templates.STOCK_SUPPLIER.getNewEditPanel(editedObj);
        if (ObjectEditorDialog.doDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), editorView) == 0) {
            editorView.saveObject();
            ((ObjectManagerI)GuiApp.getAppComplex().getApplicationContext()).getObjectManager().saveObject(editedObj, Templates.STOCK_SUPPLIER);
        } else {
            editorView.cancelObject();
        }
        this.refresh();
        frame.resetStatusBarText();
    }

    @Override
    public void doDeleteAction() {
        ApplicationFrame frame = GuiApp.getAppComplex().getApplicationFrame();
        int result = JOptionPane.showConfirmDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Are you sure you wish to delete the selected supplier? \nThis operation cannot be undone.", "Delete supplier?", 0, 2);
        if (result == 0) {
            StockSupplier supplier = this.getCurrentStockSupplier();
            int selRow = this.table.getSelectedRow();
            frame.setStatusBarText("Removing " + Templates.STOCK_SUPPLIER + ":  " + Templates.STOCK_SUPPLIER.getObjectText(supplier));
            int rowCount = this.table.getModel().getRowCount();
            this.table.requestFocus();
            if (selRow < rowCount) {
                this.table.setRowSelectionInterval(selRow, selRow);
            } else if (rowCount > 0) {
                this.table.setRowSelectionInterval(rowCount - 1, rowCount - 1);
            }
            StockControlEventLog.logDeleteStockSupplier((User)this.getUser(), (StockSupplier)supplier);
            ((ObjectManagerI)GuiApp.getAppComplex().getApplicationContext()).getObjectManager().deleteObject(supplier, Templates.STOCK_SUPPLIER);
            frame.resetStatusBarText();
            this.refresh();
        }
    }

    @Override
    public void doSearchAction() {
        StockSupplierSearchPanel searchPanel = new StockSupplierSearchPanel();
        Long id = SearchDialog.search(GuiApp.getAppComplex().getApplicationFrame().getFrame(), searchPanel, "Find Supplier...");
        if (id != null) {
            this.table.setSelectedObjectID(id);
            int rowHeight = this.table.getRowHeight();
            int panelHeight = this.table.getScroller().getHeight() - this.table.getTableHeader().getHeight();
            int maxHeight = this.table.getRowCount() * rowHeight;
            if (maxHeight > panelHeight) {
                int maxScrollableHeight;
                int yPos = this.table.getSelectedRow() * rowHeight;
                if (yPos > (maxScrollableHeight = maxHeight - panelHeight)) {
                    yPos = maxScrollableHeight;
                }
                this.table.getScroller().getViewport().setViewPosition(new Point(0, yPos));
            }
            this.table.repaint();
            this.doEditAction();
        }
    }

    public StockSupplier getCurrentStockSupplier() {
        Long id = this.tableModel.getID(this.table.getSelectedRow());
        if (id != null && id > 0L) {
            return (StockSupplier)PersistenceManager.getByID((long)id, StockSupplier.class);
        }
        return null;
    }

    class InnerInputListener
    implements MouseListener,
    KeyListener {
        InnerInputListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                SetupSuppliersState.this.doEditAction();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                SetupSuppliersState.this.doEditAction();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

