/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.units;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.application.ApplicationContext;
import au.com.ordermate.persistence.Executable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import officemate.adminkit.MenuGroupTreePanel;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.dialogs.EditFieldDialog;
import officemate.adminkit.fieldpanels.ObjectRefFieldPanel;
import officemate.adminkit.templates.Templates;
import officemate.adminkit.tree.DefaultObjectTree;
import officemate.adminkit.types.ObjectRefFieldType;
import officemate.screens.ObjectManagerI;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.stock.DecrementStockArea;
import ordermate.database.stock.StockArea;

public class UnitsUsageMenuGroupTreePanel
extends MenuGroupTreePanel {
    private JPopupMenu groupMenu;
    private JMenu decrementFromMenu;
    private JMenuItem categoryItem;

    public UnitsUsageMenuGroupTreePanel(InventoryProfile profile, ApplicationContext appContext) {
        super(((ObjectManagerI)appContext).getObjectManager(), profile);
        this.init();
    }

    private void init() {
        this.decrementFromMenu = new JMenu("Decrement from");
        this.decrementFromMenu.setBorderPainted(true);
        this.groupMenu = new JPopupMenu("Group Options");
        this.groupMenu.setName("groupOptions");
        this.groupMenu.setBorderPainted(true);
        this.categoryItem = new JMenuItem("Set category...");
        this.categoryItem.addActionListener(new SetCategoryActionListener());
        this.getTree().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                UnitsUsageMenuGroupTreePanel.this.showPopupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                UnitsUsageMenuGroupTreePanel.this.showPopupMenu(e);
            }
        });
    }

    public InventoryGroup getCurrentMenuGroup() {
        Object obj = this.getSelectedObject();
        return obj instanceof InventoryGroup ? (InventoryGroup)obj : null;
    }

    private void showPopupMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            DefaultObjectTree defaultTree = this.getTree();
            defaultTree.setSelectionPath(defaultTree.getPathForLocation(e.getX(), e.getY()));
            this.decrementFromMenu.removeAll();
            Object selObject = defaultTree.getSelectedObject();
            if (!(selObject instanceof InventoryGroup)) {
                return;
            }
            InventoryGroup group = (InventoryGroup)selObject;
            List allTerminals = Terminal.getAllTerminalsExceptServer();
            JMenu menuItem = new JMenu("(All)");
            this.setupStockAreaPopupMenu(menuItem, null, group);
            this.decrementFromMenu.add(menuItem);
            for (Terminal terminal : allTerminals) {
                menuItem = new JMenu(terminal.getName());
                this.setupStockAreaPopupMenu(menuItem, terminal, group);
                this.decrementFromMenu.add(menuItem);
            }
            this.groupMenu.add(this.decrementFromMenu);
            this.groupMenu.add(this.categoryItem);
            this.groupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void setupStockAreaPopupMenu(JMenu menu, Terminal terminal, InventoryGroup menuGroup) {
        PopupMenuListener listener = new PopupMenuListener(terminal, menuGroup);
        menu.addMenuListener(listener);
    }

    private static class PopupMenuListener
    implements MenuListener {
        private Terminal terminal;
        private InventoryGroup menuGroup;

        public PopupMenuListener(Terminal theTerminal, InventoryGroup group) {
            this.terminal = theTerminal;
            this.menuGroup = group;
        }

        @Override
        public void menuSelected(MenuEvent e) {
            JMenu menu = (JMenu)e.getSource();
            if (menu.getItemCount() == 0) {
                List stockAreas = StockArea.getStockAreas();
                List<StockArea> currentDecAreas = null;
                if (this.terminal != null) {
                    List decAreas = this.menuGroup.getDecrementStockAreas();
                    for (DecrementStockArea nextDecArea : decAreas) {
                        if (!this.terminal.equals((Object)nextDecArea.getTerminal())) continue;
                        currentDecAreas = Collections.singletonList(nextDecArea.getStockArea());
                    }
                } else {
                    HashSet<StockArea> uniqueStockAreas = new HashSet<StockArea>();
                    for (DecrementStockArea eachDecStockArea : this.menuGroup.getDecrementStockAreas()) {
                        uniqueStockAreas.add(eachDecStockArea.getStockArea());
                    }
                    if (uniqueStockAreas.size() == 1 && Terminal.getAllTerminalsExceptServer().size() == this.menuGroup.getDecrementStockAreas().size()) {
                        currentDecAreas = new ArrayList<StockArea>();
                        currentDecAreas.add((StockArea)uniqueStockAreas.iterator().next());
                    }
                }
                ButtonGroup group = new ButtonGroup();
                for (int i = 0; i < stockAreas.size(); ++i) {
                    StockArea area = (StockArea)stockAreas.get(i);
                    JCheckBoxMenuItem check = new JCheckBoxMenuItem(area.getLabel());
                    group.add(check);
                    menu.add(check);
                    boolean areaTicked = false;
                    if (currentDecAreas != null) {
                        areaTicked = currentDecAreas.contains(area);
                        check.setSelected(areaTicked);
                    }
                    PopupMenuActionListener listener = new PopupMenuActionListener(this.terminal, area, this.menuGroup, areaTicked);
                    check.addActionListener(listener);
                }
            }
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }
    }

    public static class Saver
    extends Executable<Long> {
        private final InventoryGroup saveable;

        public Saver(InventoryGroup newSaveable) {
            this.saveable = newSaveable;
        }

        public Long execute() {
            OrderMateLog.LOG.info("Started Saving :" + this.saveable + " with class " + this.saveable.getObjectType() + " in seperate thread.");
            this.saveable.save();
            OrderMateLog.LOG.info("Completed saving of :" + this.saveable + " in seperate thread.");
            return this.saveable.getID();
        }

        public void save() {
            new Thread((Runnable)((Object)this)).start();
        }
    }

    private static class PopupMenuActionListener
    implements ActionListener {
        private Terminal terminal;
        private StockArea area;
        private InventoryGroup group;
        private boolean isTicked;

        public PopupMenuActionListener(Terminal theTerminal, StockArea stockArea, InventoryGroup menuGroup, boolean isCheckTicked) {
            this.terminal = theTerminal;
            this.isTicked = isCheckTicked;
            this.area = stockArea;
            this.group = menuGroup;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.terminal != null) {
                if (!this.isTicked) {
                    this.group.setDecrementStockAreaForAllItems(this.terminal, this.area);
                } else {
                    this.group.setDecrementStockAreaForAllItems(this.terminal, null);
                }
            } else {
                this.group.setDecrementStockAreaForAllItems(this.area);
            }
            new Saver(this.group).save();
        }
    }

    private class SetCategoryActionListener
    implements ActionListener {
        private SetCategoryActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InventoryGroup group = UnitsUsageMenuGroupTreePanel.this.getCurrentMenuGroup();
            List categories = group.getCategoriesForAllItems();
            InventoryCategory cat = null;
            if (!categories.isEmpty()) {
                cat = (InventoryCategory)categories.get(0);
            }
            ObjectTemplate categoryTemp = Templates.MENU_CATEGORY;
            ObjectRefFieldPanel panel = new ObjectRefFieldPanel(UnitsUsageMenuGroupTreePanel.this.getManager());
            ObjectRefFieldType fieldType = new ObjectRefFieldType(InventoryCategory.class, true, true, true, null);
            panel.setFieldType(fieldType);
            panel.setValue(cat);
            EditFieldDialog dialog = new EditFieldDialog(panel);
            dialog.setVisible(true);
            if (dialog.wasOKed()) {
                Object obj = panel.getValue();
                InventoryCategory selectedCat = null;
                if (obj instanceof InventoryCategory) {
                    selectedCat = (InventoryCategory)obj;
                }
                group.setCategoryForAllItems(selectedCat);
                UnitsUsageMenuGroupTreePanel.this.getManager().saveObject(selectedCat, categoryTemp);
            }
        }
    }
}

