/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.stock.units;

import au.com.ordermate.application.ApplicationFrame;
import au.com.ordermate.application.ApplicationSecurity;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.guicore.task.AbstractGuiTask;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.util.DateDMY;
import au.com.ordermate.util.GuiUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreeNode;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.print.Printing;
import officemate.adminkit.search.SearchDialog;
import officemate.adminkit.searchpanels.InventoryItemSearchPanel;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.table.GroupedTableModel;
import officemate.adminkit.table.PriceGroupedTableModel;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.screens.setup.stock.ingredients.IngredientEditor;
import officemate.screens.setup.stock.ingredients.IngredientsPanel;
import officemate.screens.setup.stock.units.StockLinkableQueryTableCellRenderer;
import officemate.screens.setup.stock.units.UnitsUsageGroupedTable;
import officemate.screens.setup.stock.units.UnitsUsageGroupedTableCellRenderer;
import officemate.screens.setup.stock.units.UnitsUsageMenuGroupTreePanel;
import officemate.screens.setup.stock.units.UnitsUsageStockCostPanel;
import officemate.screens.setup.stock.units.UnitsUsageTable;
import officemate.screens.setup.stock.units.UnitsUsageTableInterface;
import officemate.screens.setup.stock.units.UnitsUsageTableModel;
import ordermate.OrderMate;
import ordermate.database.config.Quantity;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.misc.StockControlEventLog;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.reports.stock.ingredients.ItemStockIngredientsReportProvider;
import ordermate.database.reports.stock.ingredients.ItemStockIngredientsReportSearcher;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.reports.dynamicjasper.reportbuilder.ReportProvider;

public class UnitsUsageState
extends BasicOfficeMateState {
    private static final String DISPLAYLABEL_GROUP = "Group";
    private UnitsUsageStockCostPanel stockCostPanel;
    private IngredientsPanel<InventoryItemUnit, StockInventoryUsageLink> ingredientsPanel;
    private IngredientEditor<InventoryItemUnit, StockInventoryUsageLink> ingredientsEditor;
    private JPanel innerPanel;
    private JPanel northControlsPanel;
    private JPanel profilesComboAndCheckboxGroupingPanel;
    private JPanel menuProfilesComboPanel;
    private JPanel checkboxPanel;
    private JSplitPane splitter;
    private UnitsUsageMenuGroupTreePanel treePanel = null;
    private UnitsUsageGroupedTable groupedTable;
    private JCheckBox groupedCheck;
    private boolean groupResults = true;
    private UnitsUsageTable table;
    private UnitsUsageTableModel tableModel;
    private JComboBox profilesCombo;
    private JPanel rightPanel;
    private JCheckBox hideProfitableCheck;
    private boolean allowUpdate = true;
    private boolean lastStartOk;
    private final RefreshAction refreshAction = new RefreshAction((Refreshable)this);
    private ApplicationSecurity security = GuiApp.getAppComplex().getApplicationSecurity();

    public UnitsUsageState() {
        super("Item Ingredients", AllPermissions.ACCESS_ITEM_INGREDIENTS_SCREEN, "Configure the ingredients consumed by menu items");
        this.innerPanel = new JPanel(new BorderLayout());
        this.innerPanel.setName("Item Ingredients");
        this.setScreenPanel(this.innerPanel);
    }

    @Override
    protected void onEnd() {
        super.onEnd();
        this.ingredientsEditor.getIngredientAdded().disconnectAll();
        this.ingredientsEditor.getIngredientEdited().disconnectAll();
        this.ingredientsEditor.getIngredientRemoved().disconnectAll();
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Should be on EDT");
        }
        ApplicationFrame frame = GuiApp.getAppComplex().getApplicationFrame();
        frame.setStatusBarText("Loading menu ingredients setup screen...");
        if (InventoryProfile.getAllProfiles().size() == 0) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "To view the Item Ingredients, please ensure that you have set up at least one Menu Profile.", "Can't view Item Ingredients", 2);
            if (!this.isFirstRun()) {
                this.refresh();
            }
        } else if (!this.lastStartOk) {
            this.lastStartOk = Dialogs.showProgressDialog((AbstractTask)new UnitsUsageSetupTask());
            if (!this.lastStartOk) {
                Dialogs.showErrorDialog("Error Loading Screen", "Please contact OrderMate Support");
                return;
            }
        } else {
            this.refresh();
        }
        frame.resetStatusBarText();
    }

    protected void gotIngredientAdded(StockItem added, Quantity quantity) {
        InventoryItemUnit unit = (InventoryItemUnit)this.ingredientsEditor.getObject();
        StockControlEventLog.logAddMenuItemIngredient((User)this.security.getUser(), (InventoryItemUnit)unit, (StockItem)added, (Quantity)quantity);
    }

    protected void gotIngredientEdited(StockItem edited, Quantity quantity) {
        InventoryItemUnit unit = (InventoryItemUnit)this.ingredientsEditor.getObject();
        StockControlEventLog.logEditMenuItemIngredient((User)this.security.getUser(), (InventoryItemUnit)unit, (StockItem)edited, (Quantity)quantity);
    }

    public void gotIngredientRemoved(StockItem removed, Quantity quantity) {
        InventoryItemUnit unit = (InventoryItemUnit)this.ingredientsEditor.getObject();
        StockControlEventLog.logRemoveMenuItemIngredient((User)this.security.getUser(), (InventoryItemUnit)unit, (StockItem)removed, (Quantity)quantity);
    }

    private void setupComboAndButtons() {
        this.profilesCombo = new JComboBox(InventoryProfile.getAllProfiles());
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.profilesCombo);
        this.profilesCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UnitsUsageState.this.allowUpdate) {
                    UnitsUsageState.this.refresh();
                }
            }
        });
        JPanel buttonPanel = new JPanel(new GridLayout(1, 3));
        this.menuProfilesComboPanel = new JPanel();
        this.menuProfilesComboPanel.setLayout(new BoxLayout(this.menuProfilesComboPanel, 0));
        this.checkboxPanel = new JPanel();
        this.checkboxPanel.setLayout(new BoxLayout(this.checkboxPanel, 0));
        this.profilesComboAndCheckboxGroupingPanel = new JPanel(new BorderLayout());
        this.northControlsPanel = new JPanel(new BorderLayout());
        this.addAction((Action)((Object)new LinkOneAction()));
        this.addAction((Action)((Object)new LinkManyAction()));
        this.addAction((Action)this.refreshAction);
        this.addAction((Action)((Object)new PrintAction()));
        this.addAction((Action)((Object)new PrintAllAction()));
        this.addAction((Action)((Object)new SearchAction()));
        this.hideProfitableCheck = new JCheckBox("Hide profitable", false);
        this.hideProfitableCheck.setToolTipText("Hides correctly configured and profitable items");
        this.hideProfitableCheck.addActionListener((ActionListener)this.refreshAction);
        this.checkboxPanel.add(this.hideProfitableCheck);
        this.menuProfilesComboPanel.add(new JLabel(" Menu Profiles: "));
        this.menuProfilesComboPanel.add(this.profilesCombo);
        this.profilesComboAndCheckboxGroupingPanel.add((Component)this.menuProfilesComboPanel, "Center");
        this.profilesComboAndCheckboxGroupingPanel.add((Component)this.checkboxPanel, "South");
        this.northControlsPanel.add((Component)this.profilesComboAndCheckboxGroupingPanel, "West");
        this.northControlsPanel.add((Component)buttonPanel, "East");
        this.innerPanel.add((Component)this.northControlsPanel, "North");
    }

    private JTable getActiveTable() {
        return this.groupResults ? this.groupedTable : this.table;
    }

    private UnitsUsageTableInterface getActiveInterface() {
        return this.groupResults ? this.groupedTable : this.table;
    }

    private void setupGroupCheck() {
        this.groupedCheck = new JCheckBox("Group results", this.groupResults);
        this.checkboxPanel.add((Component)this.groupedCheck, "West");
        this.groupedCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnitsUsageState.this.groupResults = UnitsUsageState.this.groupedCheck.isSelected();
                UnitsUsageState.this.setTableInPanel();
                UnitsUsageState.this.refresh();
            }
        });
    }

    private void linkOne() {
        InventoryItemUnit currentUnit = this.getActiveInterface().getCurrentUnit();
        if (currentUnit == null) {
            OrderMate.LOG.warn("[UnitsUsageState] No unit was selected when \"Auto-Link\" was pressed!");
            return;
        }
        if (!currentUnit.isStockUsed()) {
            currentUnit.linkStockItemForUnit();
            currentUnit.saveChild();
            this.getActiveInterface().onItemsAdded();
        }
    }

    public void printAllIngredients() {
        ItemStockIngredientsReportSearcher reportSearcher = new ItemStockIngredientsReportSearcher();
        InventoryGroup group = this.getCurrentMenuGroup();
        InventoryProfile profile = this.getCurrentProfile();
        OrderMate.LOG.debug("Generating ItemStockIngredientsReport with group: " + group + " and profile: " + profile);
        reportSearcher.getInventoryGroupFilter().setSearchValue((TreeNode)group);
        reportSearcher.getInventoryProfileFilter().setSearchValue((Object)profile);
        ItemStockIngredientsReportProvider builder = new ItemStockIngredientsReportProvider(reportSearcher);
        builder.setUser(this.getUser());
        Dialogs.showJasperPrintDialog((ReportProvider)builder);
    }

    private void linkMany() {
        List objects = this.getActiveInterface().getCurrentlyVisibleUnits();
        Dialogs.showProgressDialog(new AutoLinkTask(objects));
    }

    private void printReport() {
        InventoryProfile profile = this.getCurrentProfile();
        InventoryGroup group = this.getCurrentMenuGroup();
        String groupString = group != null ? " Group: " + group.getLabel() : "";
        String profileString = profile != null ? " Profile: " + profile.getLabel() : "";
        String title = "Menu Ingredients Summary (" + new DateDMY(System.currentTimeMillis()) + ")";
        Printing.printJTableReport(this.getActiveTable(), title, groupString + profileString, 8);
    }

    private void setupTree() {
        this.treePanel = new UnitsUsageMenuGroupTreePanel(this.getCurrentProfile(), GuiApp.getAppComplex().getApplicationContext());
        this.treePanel.setName("ingredientGroupTree");
        this.treePanel.setPreferredSize(new Dimension(160, 300));
        this.treePanel.setMinimumSize(new Dimension(120, 300));
        this.treePanel.objectSelected.connect((Object)this, "gotTreeObjectSelected");
        this.splitter.setLeftComponent(this.treePanel);
    }

    private InventoryProfile getCurrentProfile() {
        if (this.profilesCombo == null) {
            return null;
        }
        Object obj = this.profilesCombo.getSelectedItem();
        if (obj instanceof InventoryProfile) {
            return (InventoryProfile)obj;
        }
        return null;
    }

    private void setupTable() {
        this.tableModel = new UnitsUsageTableModel(this.getCurrentMenuGroup(), this.getCurrentProfile());
        this.table = new UnitsUsageTable(this.tableModel, true);
        OfficeMateAdminGuiUtils.getInstance().standardTableSetup(this.table);
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        this.table.setDefaultRenderer(Object.class, new StockLinkableQueryTableCellRenderer());
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    UnitsUsageState.this.gotTableRowSelection(UnitsUsageState.this.table.getSelectedRow());
                }
            }
        });
        this.table.itemsAdded.connect((Object)this, "gotTableItemsAdded");
        this.table.objectChosen.connect((Object)this, "gotTableObjectChosen");
        this.rightPanel = new JPanel(new BorderLayout());
        this.rightPanel.add((Component)this.table.getScroller(), "Center");
        PriceGroupedTableModel model = new PriceGroupedTableModel((AbstractTableModel)this.table.getModel(), DISPLAYLABEL_GROUP, new String[0]);
        this.groupedTable = new UnitsUsageGroupedTable((GroupedTableModel)model, true);
        this.groupedTable.putClientProperty("useDTCRColorMemoryHack", Boolean.FALSE);
        OfficeMateAdminGuiUtils.getInstance().standardTableSetup((JTable)((Object)this.groupedTable));
        this.groupedTable.setCellRendererForAll(new UnitsUsageGroupedTableCellRenderer());
        this.groupedTable.itemsAdded.connect((Object)this, "gotTableItemsAdded");
        this.groupedTable.objectChosen.connect((Object)this, "gotGroupedTableObjectChosen");
        this.groupedTable.objectSelected.connect((Object)this, "gotGroupedTableObjectSelected");
        this.setTableInPanel();
    }

    private void updateQuery(InventoryProfile profile, InventoryGroup group, boolean selectFirstRow) {
        this.tableModel.update(group, profile, this.hideProfitableCheck.isSelected());
        PriceGroupedTableModel model = new PriceGroupedTableModel((AbstractTableModel)this.table.getModel(), DISPLAYLABEL_GROUP, new String[0]);
        this.groupedTable.setModel(model);
        if (this.groupResults) {
            if (selectFirstRow && this.tableModel.getRowCount() > 1) {
                this.groupedTable.setRowSelectionInterval(1, 1);
            }
        } else if (selectFirstRow && this.tableModel.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        this.updateIngredientsPanelEnabledState();
        this.rightPanel.revalidate();
        this.rightPanel.repaint();
    }

    private void setupItemDetailsPanel() {
        JPanel itemDetailsPanel = new JPanel(new BorderLayout());
        this.stockCostPanel = new UnitsUsageStockCostPanel();
        this.ingredientsEditor = IngredientEditor.create(SaveStrategyFactory.getInstantSaveStrategy(), null, StockInventoryUsageLink.class);
        this.ingredientsPanel = new IngredientsPanel<InventoryItemUnit, StockInventoryUsageLink>(null, this.stockCostPanel, this.ingredientsEditor, 350);
        this.ingredientsPanel.getGuiComponent().setBorder(BorderFactory.createTitledBorder("Ingredients"));
        this.ingredientsPanel.getIngredientEditor().objectEdited.connect((Object)this, "gotIngredientsModified");
        itemDetailsPanel.add((Component)this.ingredientsPanel.getGuiComponent(), "Center");
        this.rightPanel.add((Component)itemDetailsPanel, "South");
        this.stockCostPanel.newCustomCost.connect((Object)this, "gotCustomCost");
        this.stockCostPanel.priceChanged.connect((Object)this, "gotPriceChange");
        JPanel stockCostWrapper = new JPanel(new BorderLayout());
        stockCostWrapper.add((Component)this.stockCostPanel, "North");
        itemDetailsPanel.add((Component)stockCostWrapper, "West");
        this.splitter.setRightComponent(this.rightPanel);
        this.splitter.setDividerLocation(160);
        this.ingredientsEditor.getIngredientAdded().connect((Object)this, "gotIngredientAdded");
        this.ingredientsEditor.getIngredientEdited().connect((Object)this, "gotIngredientEdited");
        this.ingredientsEditor.getIngredientRemoved().connect((Object)this, "gotIngredientRemoved");
    }

    @Override
    public void refresh() {
        this.refresh(true);
    }

    public void refresh(boolean selectFirstRow) {
        if (this.treePanel != null) {
            this.allowUpdate = false;
            ApplicationFrame frame = GuiApp.getAppComplex().getApplicationFrame();
            frame.setStatusBarText("Refreshing Menu Ingredients screen...");
            Object treeObj = this.treePanel.getTree().getSelectedObject();
            Object comboObj = this.profilesCombo.getSelectedItem();
            this.profilesCombo.setModel(new DefaultComboBoxModel(InventoryProfile.getAllProfiles()));
            this.profilesCombo.setSelectedItem(comboObj);
            this.treePanel.setMenuProfile(this.getCurrentProfile());
            this.treePanel.getTree().setSelectedObject(treeObj);
            InventoryItemUnit currentUnit = this.getCurrentUnit();
            this.updateQuery(this.getCurrentProfile(), this.getCurrentMenuGroup(), selectFirstRow);
            if (!selectFirstRow && currentUnit != null) {
                this.scrollToAndSelectObject(currentUnit);
            }
            frame.resetStatusBarText();
            this.allowUpdate = true;
        }
    }

    public void search() {
        InventoryItemSearchPanel searchPanel = new InventoryItemSearchPanel(this.getCurrentProfile());
        SearchDialog searchDialog = new SearchDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), searchPanel, "Find Menu Item...");
        searchDialog.setVisible(true);
        InventoryItemUnit itemFound = (InventoryItemUnit)searchDialog.getFoundObject();
        if (itemFound != null && !searchDialog.wasCancelled()) {
            this.allowUpdate = false;
            this.hideProfitableCheck.setSelected(false);
            this.treePanel.getTree().setSelectedObject(null);
            this.allowUpdate = true;
            this.updateQuery(this.getCurrentProfile(), this.getCurrentMenuGroup(), false);
            this.scrollToAndSelectObject(itemFound);
        }
    }

    private void scrollToAndSelectObject(InventoryItemUnit unit) {
        int tableRow = this.tableModel.getRowFromObject(unit);
        JScrollPane scrollerToUse = this.table.getScroller();
        UnitsUsageTableInterface tableToUse = this.table;
        if (this.groupResults) {
            tableRow = this.groupedTable.getGroupedTableModel().getGroupedRow(tableRow);
            scrollerToUse = this.groupedTable.getScroller();
            tableToUse = this.groupedTable;
        }
        tableToUse.setRowSelectionInterval(tableRow, tableRow);
        GuiUtils.scrollToTableRow((JScrollPane)scrollerToUse, (JTable)((Object)tableToUse), (int)tableRow);
    }

    private void editIngredientsPanel() {
        if (this.ingredientsEditor.getObjectTable().getSelectedObject() == null) {
            this.ingredientsEditor.newElement();
        } else {
            this.ingredientsEditor.editSelectedElement();
        }
        this.getActiveTable().requestFocus();
    }

    private InventoryGroup getCurrentMenuGroup() {
        if (this.treePanel != null) {
            return this.treePanel.getCurrentMenuGroup();
        }
        return null;
    }

    private InventoryItemUnit getCurrentUnit() {
        if (this.table != null) {
            UnitsUsageTableInterface correctTable = this.groupResults && this.groupedTable != null ? this.groupedTable : this.table;
            return correctTable.getCurrentUnit();
        }
        return null;
    }

    void gotTableItemsAdded() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                UnitsUsageState.this.refresh(false);
            }
        });
    }

    void gotCustomCost() {
        InventoryItemUnit currentUnit = this.getCurrentUnit();
        this.updateQuery(this.getCurrentProfile(), this.getCurrentMenuGroup(), false);
        this.table.repaint();
        if (currentUnit != null) {
            this.scrollToAndSelectObject(currentUnit);
        }
    }

    private void updateIngredientsPanelEnabledState() {
        if (this.ingredientsPanel != null) {
            InventoryItemUnit unit = this.getCurrentUnit();
            if (unit == null || !StockItemQueries.stockItemsExist()) {
                this.stockCostPanel.updateForStockLinkableObject((InventoryItemUnit)null);
                this.ingredientsEditor.setObject(null);
                this.ingredientsPanel.getGuiComponent().setEnabled(false);
                this.stockCostPanel.setEnabled(false);
            } else {
                this.ingredientsPanel.getGuiComponent().setEnabled(true);
                boolean unconfigured = !unit.isStockUsed() && unit.getCustomStockCost() == null;
                ApplicationFrame frame = GuiApp.getAppComplex().getApplicationFrame();
                if (unconfigured) {
                    frame.setStatusBarText("UNCONFIGURED ITEM", Color.RED);
                } else if (!unit.isProfitable()) {
                    frame.setStatusBarText("UNPROFITABLE ITEM", Color.RED);
                } else {
                    frame.resetStatusBarText();
                }
            }
        }
    }

    void gotTreeObjectSelected(Object obj) {
        if (this.allowUpdate) {
            InventoryGroup group = null;
            if (obj instanceof InventoryGroup) {
                group = (InventoryGroup)obj;
            }
            this.updateQuery(this.getCurrentProfile(), group, true);
        }
    }

    public void gotGroupedTableObjectChosen() {
        if (this.getCurrentUnit() != null) {
            this.gotTableObjectChosen();
        }
    }

    public void gotGroupedTableObjectSelected(Integer selIndex) {
        int index = selIndex;
        int oldIndex = this.groupedTable.getGroupedTableModel().getOriginalRow(index);
        if (oldIndex != -1) {
            this.gotTableRowSelection(oldIndex);
        } else {
            this.gotTableRowSelection(-1);
        }
    }

    void gotTableObjectChosen() {
        if (this.ingredientsPanel.getGuiComponent().isEnabled()) {
            this.editIngredientsPanel();
        }
    }

    public void gotTableRowSelection(int rowIndex) {
        if (rowIndex < 0) {
            this.updateIngredientsPanelEnabledState();
            return;
        }
        InventoryItemUnit unit = this.tableModel.getItemIngredientUnitForRow(rowIndex);
        if (this.ingredientsPanel != null) {
            this.ingredientsPanel.setObject(unit);
        }
        this.updateIngredientsPanelEnabledState();
    }

    public void gotPriceChange() {
        this.refresh(false);
    }

    private void setTableInPanel() {
        this.rightPanel.remove(this.table.getScroller());
        this.rightPanel.remove(this.groupedTable.getScroller());
        if (this.groupResults) {
            this.rightPanel.add((Component)this.groupedTable.getScroller(), "Center");
        } else {
            this.rightPanel.add((Component)this.table.getScroller(), "Center");
        }
        this.getActiveTable().revalidate();
        this.getActiveTable().repaint();
    }

    private void gotIngredientsModified() {
        this.refresh(false);
        this.rightPanel.revalidate();
        this.rightPanel.repaint();
    }

    private class AutoLinkTask
    extends AbstractTask {
        List objects;

        public AutoLinkTask(List objectList) {
            this.objects = objectList;
        }

        public String getName() {
            return "Auto-linking stock items...";
        }

        public void performTask() throws Exception {
            int linkCount = 0;
            for (int i = 0; i < this.objects.size(); ++i) {
                InventoryItemUnit unit = (InventoryItemUnit)this.objects.get(i);
                if (unit.isStockUsed()) continue;
                ++linkCount;
                unit.linkStockItemForUnit();
                unit.saveChild();
                this.emitProgress();
            }
            UnitsUsageState.this.getActiveInterface().onItemsAdded();
            final int finalLinkCount = linkCount;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Dialogs.showInfoDialog("Auto-linking complete!", "Successfully auto-linked " + finalLinkCount + " items!");
                }
            });
        }

        public int getTotalSubTasks() {
            return this.objects.size();
        }
    }

    private class SearchAction
    extends BasicAction {
        public SearchAction() {
            super("Search", (Icon)IconLoader.get((String)"/ordermate/images/search22.png"), "Search...");
        }

        public void actionPerformed(ActionEvent e) {
            UnitsUsageState.this.search();
        }
    }

    private class PrintAllAction
    extends BasicAction {
        public PrintAllAction() {
            super("Ingredients Report", (Icon)IconLoader.get((String)"/officemate/images/quickprint.png"), "Print Item Ingredients Report...");
        }

        public void actionPerformed(ActionEvent e) {
            UnitsUsageState.this.printAllIngredients();
        }
    }

    private class PrintAction
    extends BasicAction {
        public PrintAction() {
            super("Print", (Icon)IconLoader.get((String)"/ordermate/images/print_icon22.png"), "Print currently displayed table");
        }

        public void actionPerformed(ActionEvent e) {
            UnitsUsageState.this.printReport();
        }
    }

    private class LinkManyAction
    extends BasicAction {
        public LinkManyAction() {
            super("Auto-Link All", (Icon)IconLoader.get((String)"/ordermate/images/linkMany.png"), "Auto-Link all visible");
        }

        public void actionPerformed(ActionEvent e) {
            UnitsUsageState.this.linkMany();
        }
    }

    private class LinkOneAction
    extends BasicAction {
        public LinkOneAction() {
            super("Auto-Link Selected", (Icon)IconLoader.get((String)"/ordermate/images/linkOne.png"), "Auto-Link stock");
        }

        public void actionPerformed(ActionEvent e) {
            UnitsUsageState.this.linkOne();
        }
    }

    private class UnitsUsageSetupTask
    extends AbstractGuiTask {
        private static final int NUM_OF_SUBTASKS = 6;

        private UnitsUsageSetupTask() {
        }

        public String getName() {
            return "Loading menu ingredients screen...";
        }

        public void doGuiTask() throws Exception {
            UnitsUsageState.this.splitter = new JSplitPane(1);
            UnitsUsageState.this.innerPanel.setVisible(false);
            UnitsUsageState.this.setupComboAndButtons();
            this.emitProgress();
            UnitsUsageState.this.setupTree();
            this.emitProgress();
            UnitsUsageState.this.setupTable();
            this.emitProgress();
            UnitsUsageState.this.setupItemDetailsPanel();
            this.emitProgress();
            UnitsUsageState.this.setupGroupCheck();
            this.emitProgress();
            UnitsUsageState.this.innerPanel.add((Component)UnitsUsageState.this.splitter, "Center");
            UnitsUsageState.this.innerPanel.setVisible(true);
            UnitsUsageState.this.refresh();
            this.emitProgress();
        }

        public int getTotalSubTasks() {
            return 6;
        }
    }
}

