/*
 * Decompiled with CFR 0.152.
 */
package waitermate;

import au.com.ordermate.OMLogUtil;
import au.com.ordermate.OrderMateLog;
import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.guicore.progress.VersionSplashWindow;
import au.com.ordermate.guicore.task.CompositeTask;
import au.com.ordermate.guicore.task.ProgressLogger;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.persistence.PersistenceClientSetupTask;
import au.com.ordermate.simplermi.SimpleRMI;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.security.Security;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.gui.OrderMateThemeI;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.misc.logging.sentry.SentryConstants;
import ordermate.serverconnection.PropertiesServerCheckTask;
import ordermate.signals.StandardSignal;
import ordermate.startup.ActionManagerTask;
import ordermate.startup.CallerIDSetupTask;
import ordermate.startup.CameraSetupTask;
import ordermate.startup.CashdrawerSetupTask;
import ordermate.startup.ConfigurationTask;
import ordermate.startup.CouponRemoteStartupTask;
import ordermate.startup.DeadlockLog;
import ordermate.startup.DeviceFailureStartupTask;
import ordermate.startup.DeviceNotFoundException;
import ordermate.startup.DynamicPortRangeRMIStartupTask;
import ordermate.startup.EDTDebugThreadCheckTask;
import ordermate.startup.InitExecuteTaskLocalService;
import ordermate.startup.InitRebootTerminalServiceTask;
import ordermate.startup.JavaVersionCheckSetupTask;
import ordermate.startup.LogStartupTask;
import ordermate.startup.MemoryLog;
import ordermate.startup.OrderMateSetupException;
import ordermate.startup.PermissionsStartupTask;
import ordermate.startup.PoleDisplaySetupTask;
import ordermate.startup.PriceInternationalizationTask;
import ordermate.startup.PrinterSetupTask;
import ordermate.startup.RequiredFolderCreationTask;
import ordermate.startup.ServerConnectionSetupTask;
import ordermate.startup.SetupLoyaltyTask;
import ordermate.startup.StartupErrorManager;
import ordermate.startup.TerminalNotFoundException;
import ordermate.startup.TimeClientSetupTask;
import ordermate.startup.UniqueTask;
import ordermate.startup.VoucherRMIStartupTask;
import ordermate.startup.runtime.JavaRuntimeCheckTask;
import ordermate.startup.sentry.InitErrorTrackingTask;
import org.apache.logging.log4j.core.Logger;
import sun.awt.AppContext;
import waitermate.LoginManager;
import waitermate.WaiterMateUpdater;
import waitermate.adminkit.WaiterMateAdminGuiUtils;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.notify.WhatsNewTask;
import waitermate.guikit.NotificationManager;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.WaitermateConnectionPanel;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.startup.LaFSetupTask;
import waitermate.hardware.posiflex.PosiflexRFIDReader;
import waitermate.startup.CheckEftposForInterruptionTask;
import waitermate.startup.ConstructGuiTask;
import waitermate.startup.CustomerDisplayStartupTask;
import waitermate.startup.FingerprintReaderSetupTask;
import waitermate.startup.OnlineOrderingSetupTask;
import waitermate.startup.OverrideRepaintManagerTask;
import waitermate.startup.PosiflexReaderSetupTask;
import waitermate.startup.ProximityReaderSetupTask;
import waitermate.startup.SetupInputAdapterTask;
import waitermate.startup.SetupMenuLogTask;
import waitermate.startup.SetupWaiterMateTerminalTask;
import waitermate.startup.UpsellStartupTask;
import waitermate.startup.WaiterMateManagerStartupTask;
import waitermate.startup.WaitermateHeartbeatTask;

public class WaiterMate {
    public static final String PRODUCT_NAME = "WaiterMate";
    public static Logger LOG;
    public static final ConstructGuiTask guiSetupTask;
    private static final int SHUTDOWN_TIME = 10000;

    private WaiterMate() {
        throw new IllegalAccessError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        System.setProperty("Driver", "com.sun.comm.Win32Driver");
        Security.setProperty("networkaddress.cache.ttl", "60");
        System.setProperty("awt.useSystemAAFontSettings", "on");
        System.setProperty("swing.aatext", "true");
        System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
        String user = System.getProperty("user.name");
        String identifier = "WaiterMate-" + user;
        OrderMate.LOG = LOG = OMLogUtil.createRootLoggerWithParentDirectory((String)PRODUCT_NAME, (String)identifier);
        OrderMateLog.LOG = LOG;
        LOG.info("Starting WaiterMate " + OrderMate.VERSION);
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionGroup());
        OrderMateThemeI.Helper.setTheme((OrderMateThemeI)new OrderMateTheme());
        StandardSignal.setAppContext((AppContext)AppContext.getAppContext());
        WaiterMateManagerStartupTask manager = new WaiterMateManagerStartupTask(PRODUCT_NAME);
        ConfigurationTask config = new ConfigurationTask("WaitermateConfig.ini");
        CompositeTask startup = new CompositeTask("Starting WaiterMate");
        startup.addTask((Task)config);
        startup.addTask((Task)WaiterMateAdminGuiUtils.createConfigTask());
        startup.addTask((Task)new OverrideRepaintManagerTask());
        startup.addTask((Task)new EDTDebugThreadCheckTask());
        startup.addTask((Task)new SetupInputAdapterTask());
        startup.addTask((Task)new JavaVersionCheckSetupTask());
        startup.addTask((Task)manager);
        startup.addTask((Task)new PropertiesServerCheckTask());
        startup.addTask((Task)new ServerConnectionSetupTask(WaitermateConnectionPanel.class, PRODUCT_NAME, WaiterMateUpdater.getInstance().getUpdateTask()));
        startup.addTask((Task)new SetupWaiterMateTerminalTask());
        UniqueTask uniqueTask = new UniqueTask(identifier, user, OrderMate.WAITERMATE_RMI_PORTS);
        startup.addTask((Task)new DynamicPortRangeRMIStartupTask(11101, 10, PRODUCT_NAME, OrderMate.WAITERMATE_RMI_PORTS).setUniqueTask(uniqueTask));
        startup.addTask((Task)new PersistenceClientSetupTask(0, PRODUCT_NAME));
        startup.addTask((Task)new LaFSetupTask());
        startup.addTask((Task)new InitErrorTrackingTask(SentryConstants.Key.WaiterMate.getKey()));
        startup.addTask((Task)new PermissionsStartupTask());
        startup.addTask((Task)new UpsellStartupTask());
        startup.addTask((Task)guiSetupTask);
        startup.addTask((Task)new CashdrawerSetupTask());
        startup.addTask((Task)new PrinterSetupTask(StartupErrorManager.getInstance()));
        startup.addTask((Task)new PoleDisplaySetupTask());
        startup.addTask((Task)new CameraSetupTask());
        startup.addTask((Task)new CallerIDSetupTask());
        startup.addTask((Task)new ProximityReaderSetupTask());
        startup.addTask((Task)new PosiflexReaderSetupTask());
        startup.addTask((Task)new OnlineOrderingSetupTask());
        startup.addTask((Task)new LogStartupTask());
        startup.addTask((Task)new MemoryLog(identifier));
        startup.addTask((Task)new DeadlockLog(identifier));
        startup.addTask((Task)new TimeClientSetupTask());
        startup.addTask((Task)new SetupMenuLogTask());
        startup.addTask((Task)new FingerprintReaderSetupTask());
        WaitermateGuiHandler gui = new WaitermateGuiHandler();
        startup.addTask((Task)new SetupLoyaltyTask((GuiHandler)gui));
        startup.addTask((Task)new ActionManagerTask(false, (GuiHandler)gui));
        startup.addTask((Task)new CouponRemoteStartupTask((GuiHandler)gui));
        startup.addTask((Task)new VoucherRMIStartupTask((GuiHandler)gui));
        startup.addTask((Task)new WaitermateHeartbeatTask());
        startup.addTask((Task)new CustomerDisplayStartupTask());
        startup.addTask((Task)new CheckEftposForInterruptionTask());
        startup.addTask((Task)new DeviceFailureStartupTask());
        startup.addTask((Task)new InitExecuteTaskLocalService());
        startup.addTask((Task)new InitRebootTerminalServiceTask());
        startup.addTask((Task)new RequiredFolderCreationTask());
        startup.addTask((Task)new JavaRuntimeCheckTask(PRODUCT_NAME));
        startup.addTask((Task)new PriceInternationalizationTask());
        startup.addTask((Task)new WhatsNewTask());
        final VersionSplashWindow theSplashFrame = new VersionSplashWindow(startup.getTotalSubTasks(), OrderMate.VERSION, PRODUCT_NAME);
        startup.progress.connect((Object)theSplashFrame, "setProgress");
        startup.taskStarted.connect((Object)new ProgressLogger(), "logProgress");
        startup.taskStarted.connect((Object)theSplashFrame, "setMessage");
        startup.statusMessage.connect((Object)theSplashFrame, "setMessage");
        theSplashFrame.startSplashScreen();
        StartupErrorManager.getInstance().setErrorSignal(NotificationManager.getInstance().checkAndHandleStartupErrors);
        while (!startup.hasRun()) {
            String prompt;
            try {
                try {
                    startup.runLocal();
                }
                catch (InvocationTargetException ie) {
                    if (ie.getCause() != null && ie.getCause() instanceof Exception) {
                        OrderMate.LOG.info("Unwrapping invocation target exception and throwing", (Throwable)ie);
                        throw (Exception)ie.getCause();
                    }
                    throw ie;
                }
            }
            catch (TerminalNotFoundException e) {
                WaiterMate.handleTerminalNotFound(e);
            }
            catch (DeviceNotFoundException e) {
                prompt = e.getHTMLMessage();
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            StartupErrorManager.getInstance().addDeviceNotFoundException(e);
                            if (!Dialogs.displayChoiceDialogWithTimer((String)prompt, (String)Internationalization.getLiteralFor((String)"STARTUP_ERROR"), (String)Internationalization.getLiteralFor((String)"CONTINUE"), (String)Internationalization.getLiteralFor((String)"EXIT"), (int)10000, (boolean)true)) {
                                System.exit(-1);
                            }
                        }
                    });
                }
                catch (Exception err) {
                    LOG.error("Error dialog interrupted", (Throwable)err);
                }
                startup.removeTask(e.getFailedTask());
            }
            catch (OrderMateSetupException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                prompt = e.getHTMLMessage();
                if (e.isFatal()) {
                    SimpleRMI.shutdown((boolean)false);
                    WaiterMate.displayFatalDialog(prompt, Internationalization.getLiteralFor((String)"STARTUP_ERROR"));
                    LOG.info("Fatal, shutting down");
                    System.exit(-1);
                    continue;
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            if (!Dialogs.displayChoiceDialog((String)prompt, (String)Internationalization.getLiteralFor((String)"STARTUP_ERROR"), (String)Internationalization.getLiteralFor((String)"CONTINUE"), (String)Internationalization.getLiteralFor((String)"EXIT"), (boolean)true)) {
                                LOG.info("Shutting down Waitermate");
                                System.exit(-1);
                            }
                        }
                    });
                }
                catch (Exception err) {
                    LOG.error("Error dialog interrupted", (Throwable)err);
                }
                startup.removeTask(e.getFailedTask());
            }
            catch (Exception e) {
                LOG.error("Error occurred during startup, exiting WaiterMate in 10 seconds", (Throwable)e);
                SimpleRMI.shutdown((boolean)false);
                String contextMsg = null;
                if (e.getMessage() != null) {
                    contextMsg = e.getMessage();
                } else {
                    String className = e.getStackTrace()[0].getClassName();
                    contextMsg = className = className.substring(className.lastIndexOf(46) + 1);
                }
                String message = "<html>" + Internationalization.getLiteralFor((String)"ERROR_OCCURED_DURING_STARTUP") + "<h2>" + contextMsg + "</h2></html>";
                WaiterMate.displayFatalDialog(message, Internationalization.getLiteralFor((String)"STARTUP_ERROR"));
                LOG.info("Shutting down Waitermate");
                System.exit(-1);
            }
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ScreenResource.getTarget().setVisible(true);
                    guiSetupTask.getLoginState().display();
                    theSplashFrame.dispose();
                }
            });
        }
        catch (Exception ex) {
            try {
                OrderMate.LOG.error("Could not display ordermate frame, exiting", (Throwable)ex);
                Dialogs.displayOkDialog((String)("<HTML>" + Internationalization.getLiteralFor((String)"UNABLE_TO_SHOW_WAITERMATE_SCREEN_DUE") + "<BR/>" + ex.getMessage()), (String)Internationalization.getLiteralFor((String)"COULD_NOT_START"));
            }
            finally {
                LoginManager.exit(-1);
            }
        }
        LOG.info("Startup complete");
        WaiterMate.initializeShutDownEvents();
        WaiterMateUpdater.getInstance().getUpdateTask().run();
    }

    private static void displayFatalDialog(final String message, final String title) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Dialogs.displayChoiceDialogWithTimer((String)message, (String)title, (String)"OK", null, (int)10000, (boolean)true);
                }
            });
        }
        catch (Exception err) {
            LOG.error("Error dialog interrupted", (Throwable)err);
        }
    }

    private static void displayOk(final String message, final String label) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Dialogs.displayOkDialog((String)message, (String)label);
                }
            });
        }
        catch (Exception err) {
            LOG.error("Error dialog interrupted", (Throwable)err);
        }
    }

    private static void handleTerminalNotFound(TerminalNotFoundException ex) {
        LOG.error(ex.getMessage(), (Throwable)ex);
        String prompt = ex.getHTMLMessage();
        WaiterMate.displayOk(ex.getIssue(), ex.getHeading());
        System.exit(-1);
    }

    private static void initializeShutDownEvents() {
        ScreenResource.getTarget().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent winEvt) {
                if (Terminal.getLocalHost().isPosiflexReaderEnabled()) {
                    PosiflexRFIDReader.getInstance().stopReading();
                }
                LoginManager.exit(0);
            }
        });
    }

    public static void reconstructGui() {
        try {
            LoginManager.getInstance().logout();
            LOG.info("Reconstructing waitermate gui");
            new ConfigurationTask("WaitermateConfig.ini").runLocal();
            new LaFSetupTask().runLocal();
            ConstructGuiTask.reconstructGui();
        }
        catch (Exception ex) {
            LOG.fatal("Could not reconstruct the gui, system will exit so it can be restarted.", (Throwable)ex);
            System.exit(-1);
        }
    }

    public static void minimise() {
        Frame[] frames;
        for (Frame frame : frames = Frame.getFrames()) {
            frame.setState(1);
        }
    }

    public static void logout() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    LoginManager.getInstance().logout();
                    ScreenResource.getTarget().setVisible(true);
                    guiSetupTask.getLoginState().display();
                }
            });
            LOG.info("Successfully logged out.");
        }
        catch (Exception ex) {
            LOG.fatal("Could not display login screen!", (Throwable)ex);
            System.exit(-1);
        }
    }

    static {
        guiSetupTask = new ConstructGuiTask();
    }

    public static class ExceptionGroup
    extends ThreadGroup {
        public ExceptionGroup() {
            super("Uncaught main");
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            LOG.error("Uncaught exception in : " + t.getName(), e);
            new Timer("EDT Restart").schedule(new TimerTask(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                LOG.info("EDT Restart event");
                                if (ScreenResource.getTarget() != null) {
                                    ScreenResource.getTarget().invalidate();
                                }
                            }
                            catch (Throwable ex) {
                                OrderMate.LOG.error("Error attempting to restart EDT", ex);
                            }
                        }
                    });
                }
            }, 5000L);
        }
    }
}

