/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.util.Assert;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import ordermate.OrderMate;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.gui.GuiConfig;
import ordermate.database.gui.GuiConfigSet;
import ordermate.database.gui.TerminalTypes;
import ordermate.database.hardware.Terminal;
import ordermate.gui.modify.AWTInterceptor;
import ordermate.gui.modify.ComponentListener;
import ordermate.gui.modify.security.PosUserSecurityManager;
import ordermate.gui.modify.style.StyleListener;
import ordermate.guicore.GuiConfigRule;
import ordermate.guicore.StyleRule;
import waitermate.guikit.NotificationManager;
import waitermate.guikit.UIActionLogger;

public class WaiterMateFrame
extends JFrame {
    private static final int DEBUG_SCREEN_WIDTH = 1024;
    private static final int DEBUG_SCREEN_HEIGHT = 768;
    public static final Dimension LAYOUT_DIMENSIONS = new Dimension(5, 5);
    private int screenWidth;
    private int screenHeight;
    private boolean screenDecorated = false;
    private static StyleListener styleListener;

    public WaiterMateFrame() {
        super("WaiterMate " + OrderMate.VERSION);
        this.setDefaultCloseOperation(3);
        boolean debugMode = false;
        debugMode = Config.getBooleanValue((String)"debug");
        if (debugMode) {
            this.screenHeight = 768;
            this.screenWidth = 1024;
            this.screenDecorated = true;
            Assert.setThrowsExceptions((boolean)true);
        } else {
            this.screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
            this.screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
            Assert.setThrowsExceptions((boolean)false);
        }
        this.setSize(this.screenWidth, this.screenHeight);
        this.setUndecorated(!this.screenDecorated);
        this.initListeners();
        ArrayList<Image> icons = new ArrayList<Image>();
        icons.add(IconLoader.get((String)"/ordermate/images/waitermate_icon_16.png").getImage());
        icons.add(IconLoader.get((String)"/ordermate/images/waitermate_icon_24.png").getImage());
        icons.add(IconLoader.get((String)"/ordermate/images/waitermate_icon_32.png").getImage());
        icons.add(IconLoader.get((String)"/ordermate/images/waitermate_icon_48.png").getImage());
        icons.add(IconLoader.get((String)"/ordermate/images/waitermate_icon_256.png").getImage());
        this.setIconImages(icons);
    }

    private void initListeners() {
        PosUserSecurityManager security = new PosUserSecurityManager();
        AWTInterceptor.addListener((ComponentListener)security);
        NotificationManager.getInstance().newUserSignal.connect((Object)security, "gotNewUser");
        NotificationManager.getInstance().noUser.connect((Object)security, "gotNoUser");
        ExperimentalFeature buttonSniffer = ExperimentalFeature.find((String)"WM UI Log");
        if (buttonSniffer != null && buttonSniffer.getBooleanValue(Boolean.FALSE).booleanValue()) {
            AWTInterceptor.addListener((ComponentListener)UIActionLogger.init());
        }
        styleListener = new StyleListener();
        AWTInterceptor.addListener((ComponentListener)styleListener);
        WaiterMateFrame.updateStyles();
    }

    public static synchronized void updateStyles() {
        styleListener.clearRules();
        List rules = Collections.emptyList();
        GuiConfigSet set = Terminal.getLocalHost().getScreenLayoutSet();
        if (set == null) {
            set = GuiConfigSet.getDefaultSet((TerminalTypes)TerminalTypes.WaiterMate);
            Terminal.getLocalHost().setScreenLayoutSet(set);
            Terminal.getLocalHost().save();
        } else {
            set = (GuiConfigSet)PersistenceManager.reacquire((PersistentObjectI)set);
            Terminal.getLocalHost().setScreenLayoutSet(set);
        }
        rules = set.getGuiConfigs();
        Iterator it = rules.iterator();
        while (it.hasNext()) {
            GuiConfigRule rule = new GuiConfigRule((GuiConfig)it.next());
            styleListener.addRule((StyleRule)rule);
        }
    }
}

