/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui;

import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import ordermate.OrderMate;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.users.User;
import ordermate.startup.StartupErrorManager;
import waitermate.failover.WaitermateFailover;
import waitermate.gui.NotificationIconPanel;
import waitermate.gui.WaiterMateCustomerCardLabelGenerator;
import waitermate.guikit.NotificationManager;
import waitermate.guikit.ScreenResourceMenu;
import waitermate.guikit.dialogs.AccountComments;

public class WaiterMateScreenResourceMenu
extends ScreenResourceMenu {
    private JLabel customerLabel;
    private JLabel userLabel;
    private JLabel timeLabel;
    private JLabel errorIndicatorLabel;
    private JLabel failoverLabel;
    private NotificationIconPanel notificationPanel;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private JPanel centerPanel;
    Timer paintSwingTimer;
    private final DateFormat dateFormatter = new SimpleDateFormat("EEE, MMM, d  h:mm:ss aaa");
    private AccountComments comments = new AccountComments(null);

    public WaiterMateScreenResourceMenu() {
        this.createAndAddPanels();
        this.createMainComponents();
        NotificationManager.getInstance().notifyAccountChanged.connect((Object)this, "gotAccountChanged");
        NotificationManager.getInstance().newUserSignal.connect((Object)this, "gotNewUser");
        NotificationManager.getInstance().noUser.connect((Object)this, "gotNoUser");
        NotificationManager.getInstance().userClockedOnOffSignal.connect((Object)this, "gotUserClockedOnOff");
        NotificationManager.getInstance().stockReqisitionSignal.connect((Object)this, "setStockRequisition");
        NotificationManager.getInstance().notifyFailover.connect((Object)this, "gotFailoverMode");
        NotificationManager.getInstance().checkAndHandleStartupErrors.connect((Object)this, "gotCheckAndHandleStartupErrors");
    }

    private void createMainComponents() {
        this.notificationPanel = new NotificationIconPanel();
        this.userLabel = new JLabel();
        this.customerLabel = new JLabel();
        this.customerLabel.setName("customerLabel");
        this.createTimeLabel();
        this.centerPanel.add(this.customerLabel);
        this.failoverLabel = new JLabel(IconLoader.get((String)"/ordermate/images/failover.png"));
        this.failoverLabel.setVisible(WaitermateFailover.isActive());
        this.rightPanel.add(this.failoverLabel);
        this.rightPanel.add(this.notificationPanel);
        this.rightPanel.add(this.userLabel);
        this.leftPanel.add(this.timeLabel);
        this.errorIndicatorLabel = new JLabel(IconLoader.get((String)"/ordermate/images/failover.png"));
        this.errorIndicatorLabel.setVisible(false);
        this.leftPanel.add(this.errorIndicatorLabel);
    }

    private void createAndAddPanels() {
        this.setLayout(new BorderLayout());
        this.leftPanel = new JPanel();
        this.leftPanel.setPreferredSize(new Dimension(200, 0));
        this.leftPanel.setLayout(new FlowLayout(0));
        this.centerPanel = new JPanel();
        this.rightPanel = new JPanel();
        this.rightPanel.setPreferredSize(new Dimension(200, 0));
        this.rightPanel.setLayout(new FlowLayout(2));
        this.add(this.leftPanel, "West");
        this.add(this.centerPanel, "Center");
        this.add(this.rightPanel, "East");
    }

    public void gotAccountChanged(Account account, User user) {
        if (account == null) {
            this.customerLabel.setText("");
            return;
        }
        Customer customer = null;
        if (account.hasCustomer()) {
            customer = account.getCustomer();
        }
        String card = account.getCardId();
        if (customer == null && card == null) {
            this.customerLabel.setText("");
            return;
        }
        this.customerLabel.setText(WaiterMateCustomerCardLabelGenerator.generateLabel(account));
        this.comments.autoDisplayAccountComments(account, user);
    }

    private void checkStartupErrors() {
        this.errorIndicatorLabel.setVisible(StartupErrorManager.getInstance().hadErrorsDuringStartup());
    }

    public void gotNewUser(User newUser) {
        this.userLabel.setText(newUser.getLabel() + "  ");
        this.gotUserClockedOnOff(newUser);
    }

    public void gotNoUser() {
        this.userLabel.setText("");
        this.setUserClockedOnOff(false);
    }

    private void createTimeLabel() {
        this.timeLabel = new JLabel(this.getFormattedTime());
        this.paintSwingTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaiterMateScreenResourceMenu.this.timeLabel.setText(WaiterMateScreenResourceMenu.this.getFormattedTime());
            }
        });
        this.paintSwingTimer.setInitialDelay(0);
    }

    private String getFormattedTime() {
        Date today = new Date();
        return this.dateFormatter.format(today);
    }

    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag) {
            this.paintSwingTimer.start();
        } else {
            this.paintSwingTimer.stop();
        }
    }

    public void gotUserClockedOnOff(User user) {
        this.setUserClockedOnOff(user.isClockedOn());
    }

    private void setUserClockedOnOff(boolean clockedOn) {
        this.notificationPanel.getIconLabel("/ordermate/images/clock16.png").setVisible(clockedOn);
    }

    private void setStockRequisition(Boolean showIcon) {
        if (showIcon != null) {
            this.notificationPanel.getIconLabel("/waitermate/images/Stock_16.png").setVisible(showIcon);
        }
    }

    public void gotFailoverMode(Boolean isRunningAsFailover, String serverName) {
        if (Boolean.TRUE.equals(isRunningAsFailover)) {
            OrderMate.LOG.info("We are now in redundancy mode:" + serverName);
        } else {
            OrderMate.LOG.info("We are no longer in redundancy mode: " + serverName);
        }
        if (isRunningAsFailover.booleanValue()) {
            WaitermateFailover.startFailover(serverName);
        } else {
            WaitermateFailover.stopFailover(serverName);
        }
        this.failoverLabel.setVisible(isRunningAsFailover);
    }

    public void gotCheckAndHandleStartupErrors() {
        this.checkStartupErrors();
    }
}

