/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import java.awt.FlowLayout;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ordermate.database.hardware.Terminal;
import ordermate.gui.dialogs.ForcedChoiceOptionDialog;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.ProgressDialog;
import waitermate.guikit.dialogs.WaiterMateForcedChoiceOptionDialog;

public class WaitermateGuiHandler
implements GuiHandler {
    public void displayOkDialog(final String title, final String message) {
        this.doOnEDTAndWait(new Runnable(){

            @Override
            public void run() {
                Dialogs.displayOkDialog((String)title, (String)message);
            }
        }, "WM");
    }

    public void displayOkDialog(final JComponent comp, final String title) {
        this.doOnEDTAndWait(new Runnable(){

            @Override
            public void run() {
                Dialogs.displayOkDialog((JComponent)comp, (String)title);
            }
        }, "WM");
    }

    protected void doOnEDTAndWait(Runnable toRun, String guiHandlerprefix) {
        if (SwingUtilities.isEventDispatchThread()) {
            toRun.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(toRun);
            }
            catch (InvocationTargetException ex) {
                OrderMateLog.LOG.warn(guiHandlerprefix + "GuiHandler Exception while displaying dialog.", (Throwable)ex);
            }
            catch (InterruptedException ex) {
                OrderMateLog.LOG.warn(guiHandlerprefix + "GuiHandler Exception while displaying dialog.", (Throwable)ex);
            }
        }
    }

    public boolean displayForcedChoiceDialog(final String title, final String message, final String positiveOption, final String negativeOption) {
        final AtomicBoolean result = new AtomicBoolean(false);
        this.doOnEDTAndWait(new Runnable(){

            @Override
            public void run() {
                result.set(Dialogs.displayChoiceDialog((String)message, (String)title, (String)positiveOption, (String)negativeOption, (boolean)true));
            }
        }, "WM");
        return result.get();
    }

    public void closeBlockingDialog(final JPanel mainComponent) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScreenResource.stopWindow((JComponent)mainComponent);
                }
            });
        } else {
            ScreenResource.stopWindow((JComponent)mainComponent);
        }
    }

    public void displayBlockingDialog(final JPanel mainComponent) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScreenResource.startModalWindow((JPanel)mainComponent);
                }
            });
        } else {
            ScreenResource.startModalWindow((JPanel)mainComponent);
        }
    }

    public void refreshBlockingDialog(JPanel mainComponent) {
    }

    public String getStringInput(String message, String initialString) {
        return Dialogs.getString((String)message, (String)initialString);
    }

    public boolean isDarkLaf() {
        String lafName = Terminal.getLocalHost().getLookAndFeelClassName();
        if (lafName == null) {
            return false;
        }
        return lafName.contains("Raven") || lafName.contains("Graphite");
    }

    public Object displayChoiceDialog(String title, String message, List<?> options, Object defaultOption) {
        Object choice = Dialogs.displaySelectionDialog((String)message, options);
        if (choice == null) {
            choice = defaultOption;
        }
        return choice;
    }

    public void displayErrorDialog(String title, String message, String errorDetails) {
        JPanel container = new JPanel(new FlowLayout());
        JLabel label = Dialogs.createMessageLabel((String)message);
        container.add(label);
        if (errorDetails != null) {
            JLabel error = Dialogs.createMessageLabel((String)errorDetails);
            container.add(error);
        }
        Dialogs.displayOkDialog((JComponent)container, (String)title);
    }

    public ForcedChoiceOptionDialog createForcedChoiceDialog(String message, String title, String posText, String negText, List<String> options, boolean requiresConfirmation) {
        return new WaiterMateForcedChoiceOptionDialog(message, title, posText, negText, options, requiresConfirmation);
    }

    public void doProgressTask(AbstractTask task) {
        ProgressDialog.doProgressDialog((Task)task);
    }
}

