/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.additems.search;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuItem;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.StoreGroup;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.integration.webservice.RestHelper;
import ordermate.jaxb.exporter.handlers.online.sales.HOMenuResolverExecutable;
import waitermate.LoginManager;
import waitermate.WaiterMateUpdater;

class DownloadFromHO {
    private final GuiHandler handler;

    public DownloadFromHO(GuiHandler guiHandler) {
        this.handler = guiHandler;
    }

    public InventoryItem start(String searchValue) {
        if (searchValue == null || searchValue.length() < 1) {
            this.handler.displayOkDialog("Search is too short. Please be more specific.", "Criteria Too Short");
            return null;
        }
        List<PosMenuItem> found = this.retrievePossibilities(searchValue);
        if (found.isEmpty()) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>(found.size());
        for (PosMenuItem nextItem : found) {
            names.add(nextItem.getLabel());
        }
        String choice = (String)this.handler.displayChoiceDialog("Please Select An Item", "The following items have been found at Head Office.", names, null);
        if (choice != null) {
            return this.downloadChoice(found.get(names.indexOf(choice)));
        }
        return null;
    }

    private List<PosMenuItem> retrievePossibilities(String criteria) {
        RestHelper helper = new RestHelper();
        WebResource resource = helper.getResource(HOConfig.getInstance().getServerLocation() + "integration/menu/searchitem");
        resource = helper.addBasicAuth(resource, StoreGroup.getInstance().getStoreId().toString(), StoreGroup.getInstance().getStoreName());
        resource = helper.addParameter(resource, "labellike", criteria);
        String response = (String)resource.get(String.class);
        List<PosMenuItem> results = this.wrangleResponse(response);
        return results;
    }

    private List<PosMenuItem> wrangleResponse(String response) {
        ArrayList<PosMenuItem> result = new ArrayList<PosMenuItem>();
        if (response == null) {
            this.handler.displayOkDialog("Cannot contact Head Office", "Head Office could not be contacted. Please check your network.");
        } else if (response.isEmpty()) {
            this.handler.displayOkDialog("No Items", "No items were found at Head Office that matched the criteria");
        } else {
            List entries = StringUtils.splitToList((String)response, (String)"\r\n");
            for (String nextEntry : entries) {
                int index = nextEntry.lastIndexOf("=");
                PosMenuItem item = new PosMenuItem();
                item.setLabel(nextEntry.substring(0, index));
                item.setID(Long.valueOf(nextEntry.substring(index + 1, nextEntry.length())));
                result.add(item);
            }
        }
        return result;
    }

    private InventoryItem downloadChoice(PosMenuItem choice) {
        HOMenuResolverExecutable executable = new HOMenuResolverExecutable(choice.getID());
        InventoryItem result = (InventoryItem)PersistenceManager.getServerConnection().runSync((Executable)executable);
        if (result != null) {
            return result;
        }
        String reason = LoginManager.getInstance().getUser() + ": Downloaded item.";
        SystemCurrentInfo.setMenuUpdate((String)reason);
        WaiterMateUpdater.getInstance().getUpdateTask().run();
        result = (InventoryItem)PersistenceManager.getObject(InventoryItem.class, (String)Query.select(InventoryItem.class).equals(InventoryItem.Properties.MASTER_ID, (Object)choice.getID()).toString());
        if (result == null) {
            this.handler.displayOkDialog("Item Not Downloaded", "There was a problem downloading the item. Please try again.");
        }
        return result;
    }
}

