/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.additems.search;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.HOConfig;
import ordermate.database.sales.AccountType;
import ordermate.database.searchers.inventoryitem.InventoryItemSearcher;
import ordermate.gui.button.CustomToggleButton;
import ordermate.gui.scroll.CustomButtonRenderer;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DataScrollPaneModel;
import ordermate.internationalization.Internationalization;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.additems.search.DownloadFromHO;
import waitermate.gui.additems.search.InventoryItemRenderer;
import waitermate.gui.search.WMSearchPanel;
import waitermate.guikit.dialogs.Dialogs;

public class InventoryItemSearchPanel
extends WMSearchPanel<InventoryItem>
implements ActionListener {
    private JButton categoryButton;
    private DataScrollPaneModel categoryModel;
    private CustomScrollPane categoryPanel;
    private JButton fromHOButton;

    public InventoryItemSearchPanel() {
        this(new InventoryItemSearcher(), true);
    }

    public InventoryItemSearchPanel(InventoryItemSearcher theSearcher, boolean addNav) {
        super(theSearcher, addNav);
    }

    @Override
    protected void setupNavBar() {
        super.setupNavBar();
        this.categoryButton = this.navBar.constructButton((Icon)IconLoader.get((String)"/waitermate/images/StockCount.png"), Internationalization.getLiteralFor((String)"CATEGORY"), "category");
        this.categoryButton.addActionListener(this);
        this.navBar.addLeft((Component)this.categoryButton);
        if (HOConfig.getInstance().isConfigured()) {
            this.fromHOButton = this.navBar.constructButton((Icon)IconLoader.get((String)"/waitermate/images/browser.png"), Internationalization.getLiteralFor((String)"DOWNLOAD"), "downloadFromHO");
            this.fromHOButton.addActionListener(this);
            this.navBar.addLeft((Component)this.fromHOButton);
        }
    }

    public void startSearch(TriggerActivationContext triggerContext, InventoryGroup preferredGroup, boolean reset) {
        if (triggerContext.getAccount() == null) {
            throw new IllegalArgumentException("Must have current account");
        }
        List groups = InventoryProfile.getProfile((AccountType)triggerContext.getAccountType(), (Terminal)triggerContext.getTerminal()).getActiveProfileGroups(triggerContext, true);
        ArrayList<InventoryItem> allItems = new ArrayList<InventoryItem>();
        for (InventoryGroup group : groups) {
            allItems.addAll(group.getItems());
        }
        this.startSearch(allItems, preferredGroup, reset);
    }

    public void startSearch(List<InventoryItem> items, InventoryGroup prefGroup, boolean reset) {
        ((InventoryItemSearcher)this.searcher).setPreferredInventoryGroup(prefGroup);
        super.startSearch(items, reset);
    }

    @Override
    public void gotClear() {
        super.gotClear();
        if (this.categoryModel != null) {
            ((InventoryItemSearcher)this.searcher).setSearchCategories(null);
            this.categoryModel.selectAllButtons(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String value;
        DownloadFromHO download;
        InventoryItem item;
        Object source = e.getSource();
        if (source == this.categoryButton) {
            if (this.categoryPanel == null) {
                this.categoryModel = new DataScrollPaneModel(1, 6);
                this.categoryModel.setItems(InventoryCategory.getAllCategories(), true, false);
                this.categoryPanel = new CustomScrollPane((CustomScrollPaneModel)this.categoryModel);
            }
            Dialogs.displayOkDialog((JComponent)this.categoryPanel, (String)Internationalization.getLiteralFor((String)"SELECT_CATEGORIES"));
            ArrayList<InventoryCategory> categories = new ArrayList<InventoryCategory>();
            Iterator it = this.categoryModel.getSelectedButtons().iterator();
            while (it.hasNext()) {
                categories.add((InventoryCategory)((CustomToggleButton)it.next()).getData());
            }
            if (categories.size() == 0) {
                categories = null;
            }
            ((InventoryItemSearcher)this.searcher).setSearchCategories(categories);
        } else if (source == this.fromHOButton && (item = (download = new DownloadFromHO(new WaitermateGuiHandler())).start(value = this.keyboard.getValue())) != null) {
            this.objectSelected.emit((Object)item);
        }
    }

    @Override
    protected CustomButtonRenderer createRenderer() {
        return new InventoryItemRenderer();
    }

    @Override
    protected String getPrompt() {
        return Internationalization.getLiteralFor((String)"ITEM_NAME");
    }
}

