/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.customerdisplay;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import ordermate.OrderMate;
import ordermate.database.misc.customerdisplay.AbstractCustomerDisplay;
import ordermate.database.sales.Account;
import waitermate.gui.customerdisplay.AbstractCustomerDisplayPanel;
import waitermate.gui.customerdisplay.CustomerDisplayDebugHelper;
import waitermate.gui.customerdisplay.CustomerDisplayPanelFactory;
import waitermate.gui.screens.payment.eftpos.BlockingPanel;
import waitermate.guikit.dialogs.Dialogs;

public class CustomerDisplayFrame
extends JFrame
implements WindowListener {
    private AbstractCustomerDisplayPanel mainPanel;
    private final AbstractCustomerDisplay display;
    private Account currentAccount;
    private BlockingPanel messagePanel;
    private JDialog dialog;

    CustomerDisplayFrame(AbstractCustomerDisplay yourDisplay) {
        this.display = yourDisplay;
        this.setUndecorated(true);
        this.setupComponents();
        this.setupGeometry();
        CustomerDisplayDebugHelper.writeDimentionsToLogs(this.display, this);
        this.mainPanel.onStart();
        this.addWindowListener(this);
    }

    private void setupComponents() {
        String background = this.display.getResourceSet().getResource("Main Background").getResourcePath();
        Image image = null;
        if (background != null) {
            try {
                image = IconLoader.getImage((String)background);
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Cannot find the image for the background.", (Throwable)ex);
            }
        }
        CustomerDisplayPanelFactory factory = new CustomerDisplayPanelFactory();
        this.mainPanel = factory.createPanel(image, this.display);
        this.getContentPane().add(this.mainPanel);
    }

    private void setupGeometry() {
        int preferredDevice = this.display.getDefaultDevice();
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        GraphicsDevice myDevice = devices[0];
        if (devices.length > 1) {
            int device = Math.min(devices.length, preferredDevice);
            myDevice = devices[device];
        }
        GraphicsConfiguration config = myDevice.getDefaultConfiguration();
        Rectangle bounds = config.getBounds();
        if (Config.isDebuging()) {
            this.setBounds(new Rectangle(bounds.x, bounds.y, 1024, 768));
        } else {
            this.setBounds(new Rectangle(bounds));
        }
        this.setVisible(true);
    }

    void setAccount(Account account) {
        this.currentAccount = account;
        this.mainPanel.accountChanged(account);
    }

    void displayDialog(String aMessage) {
        this.messagePanel = new BlockingPanel(Dialogs.createMessageLabel((String)aMessage));
        this.displayDialog(this.messagePanel);
    }

    void displayDialog(JComponent component) {
        this.stopDialog();
        this.dialog = new JDialog();
        this.dialog.setModal(false);
        this.dialog.setUndecorated(true);
        this.dialog.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new LineBorder(Color.DARK_GRAY, 3));
        panel.add((Component)component, "Center");
        this.dialog.getContentPane().add((Component)panel, "Center");
        this.dialog.setVisible(true);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this);
    }

    void stopDialog() {
        try {
            if (this.dialog != null) {
                this.dialog.setVisible(false);
                this.dialog.dispose();
                this.dialog = null;
            }
        }
        catch (Exception e) {
            OrderMate.LOG.error("Exception caught during dialog teardown, has it already been torn down?", (Throwable)e);
        }
        this.messagePanel = null;
    }

    Account getAccount() {
        return this.currentAccount;
    }

    void setMessage(String message) {
        this.mainPanel.setMessage(message, 0L);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
        this.boing();
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public void boing() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CustomerDisplayFrame.this.setExtendedState(0);
            }
        });
    }
}

