/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.customerdisplay;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import ordermate.database.misc.customerdisplay.AbstractCustomerDisplay;
import ordermate.database.misc.customerdisplay.CustomerDisplayMessage;
import ordermate.database.sales.Account;
import waitermate.guikit.dialogs.OnePressPopupWindow;

class CustomerMessageGetter {
    private List<CustomerDisplayMessage> messages;
    private Account account;

    CustomerMessageGetter(AbstractCustomerDisplay display, Account theAccount) {
        this.messages = display.getCustomMessages();
        this.account = theAccount;
    }

    String getMessage() {
        List<JButton> buttons = this.makeButtons();
        OnePressPopupWindow window = new OnePressPopupWindow("Please select a message to display:", buttons, 1, 5, true);
        window.setPreferredSize(new Dimension(700, 400));
        JButton selection = window.start();
        if (selection != null) {
            return selection.getText();
        }
        return null;
    }

    private List<JButton> makeButtons() {
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        for (CustomerDisplayMessage message : this.messages) {
            JButton button = new JButton(message.getContextualMessage(this.account.getUser(), this.account.getCustomer()));
            buttons.add(button);
        }
        return buttons;
    }
}

