/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.customerdisplay;

import java.awt.Dimension;
import java.awt.Image;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import ordermate.OrderMate;
import ordermate.database.misc.customerdisplay.OrderCustomerDisplay;
import ordermate.database.sales.Account;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.transitions.ScreenTransition;
import org.jdesktop.animation.transitions.TransitionTarget;
import waitermate.LoginManager;
import waitermate.gui.customerdisplay.AbstractCustomerDisplayPanel;
import waitermate.gui.customerdisplay.CustomerDisplayFunctionPanel;
import waitermate.gui.customerdisplay.ordering.OrderingPanel;

class OrderCustomerDisplayPanel
extends AbstractCustomerDisplayPanel<OrderCustomerDisplay>
implements TransitionTarget {
    private static final long PAUSE_DELAY = 5000L;
    private static final int ANIM_DELAY = 1000;
    private OrderingPanel orderingPanel;
    private Account currentAccount = null;
    private Account nextAccount = null;
    private ScreenTransition transition;
    private Timer pauseTimer;
    private TimerTask pauseTask;

    OrderCustomerDisplayPanel(Image bg, OrderCustomerDisplay yourDisplay) {
        super(bg, yourDisplay);
        Animator animator = new Animator(1000);
        this.transition = new ScreenTransition((JComponent)this, (TransitionTarget)this, animator);
        this.pauseTimer = new Timer();
        this.showNextAccount();
    }

    @Override
    public void accountChanged(Account account) {
        this.nextAccount = account;
        if (this.nextAccount == null) {
            this.transitionToNoAccount();
        } else {
            this.showNextAccount();
        }
    }

    private void cancelTransitionTimer() {
        if (this.pauseTask != null) {
            this.pauseTask.cancel();
        }
    }

    private void transitionToNoAccount() {
        if (this.currentAccount != null) {
            this.setMessage(((OrderCustomerDisplay)this.display).getFarewellMessage().getContextualMessage(this.currentAccount.getUser(), this.currentAccount.getCustomer()), 0L);
        }
        this.currentAccount = null;
        this.cancelTransitionTimer();
        this.pauseTask = new TimerTask(){

            @Override
            public void run() {
                OrderCustomerDisplayPanel.this.showNextAccount();
            }
        };
        this.pauseTimer.schedule(this.pauseTask, 5000L);
    }

    private void showNextAccount() {
        this.cancelTransitionTimer();
        this.getAdvertisingManager().accountChanged(this.currentAccount);
        this.setupNextScreen();
        try {
            this.transition.start();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Something went ping while starting a screen transition", (Throwable)ex);
        }
    }

    public void setupNextScreen() {
        if (this.currentAccount != this.nextAccount || this.currentAccount == null && this.nextAccount == null) {
            this.currentAccount = this.nextAccount;
            this.orderingPanel.setPreferredSize(new Dimension(((OrderCustomerDisplay)this.display).getOrderWidth(), 100));
            this.orderingPanel.setVisible(this.currentAccount != null);
            super.getBanner().setVisible(this.currentAccount != null || ((OrderCustomerDisplay)this.display).isBannerVisible());
            super.getMessage().setVisible(this.currentAccount != null || ((OrderCustomerDisplay)this.display).isMessageVisible());
            if (this.currentAccount != null) {
                this.setMessage(((OrderCustomerDisplay)this.display).getWelcomeMessage().getContextualMessage(this.currentAccount.getUser() == null ? LoginManager.getInstance().getUser() : this.currentAccount.getUser(), this.currentAccount.getCustomer()), 1000L);
            } else {
                this.setMessage(((OrderCustomerDisplay)this.display).getStandbyMessage().getMessage(), 1000L);
            }
        }
        this.orderingPanel.setAccount(this.currentAccount);
        this.getAdvertisingManager().getBannerPanel();
        this.getAdvertisingManager().accountChanged(this.currentAccount);
        super.getBanner().repaint();
    }

    @Override
    protected CustomerDisplayFunctionPanel<OrderCustomerDisplay> createFunctionPanel() {
        this.orderingPanel = new OrderingPanel();
        return this.orderingPanel;
    }
}

