/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.customerdisplay;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.customerdisplay.AbstractCustomerDisplay;
import ordermate.database.misc.customerdisplay.OrderCustomerDisplay;
import ordermate.database.misc.customerdisplay.QAndACustomerDisplay;
import ordermate.database.sales.Account;
import waitermate.gui.customerdisplay.CustomerDisplayFrame;
import waitermate.gui.customerdisplay.CustomerMessageGetter;

public class WaiterMateCustomerDisplay {
    private static WaiterMateCustomerDisplay instance;
    private CustomerDisplayFrame frame;
    private List<AbstractCustomerDisplay> displays = new ArrayList<AbstractCustomerDisplay>();

    public static WaiterMateCustomerDisplay getInstance() {
        return instance;
    }

    public static void dropInstance() {
        if (instance != null) {
            instance.stopDialog();
            instance.getFrame().setVisible(false);
            instance.getFrame().dispose();
            instance = null;
        }
    }

    private WaiterMateCustomerDisplay() {
        this.initialise();
    }

    public static void setup() {
        if (instance != null) {
            throw new IllegalStateException("Cannot make two instances of the WaiterMateCustomerDisplay!");
        }
        instance = new WaiterMateCustomerDisplay();
    }

    void initialise() {
        this.startDisplay(OrderCustomerDisplay.class);
        this.startDisplay(QAndACustomerDisplay.class);
    }

    private void startDisplay(Class<? extends AbstractCustomerDisplay> clazz) {
        AbstractCustomerDisplay display = (AbstractCustomerDisplay)PersistenceManager.getObject(clazz, (String)Query.select(clazz).equals(AbstractCustomerDisplay.Properties.TERMINAL, (Object)Terminal.getLocalHost()).toString(), null);
        if (display != null && SystemState.ACTIVE_STATE.equals((Object)display.getSystemState())) {
            OrderMate.LOG.info("Starting ordering customer display.");
            this.frame = new CustomerDisplayFrame(display);
            this.displays.add(display);
        }
    }

    public static boolean isActive() {
        return instance != null && !WaiterMateCustomerDisplay.instance.displays.isEmpty() && SystemState.ACTIVE_STATE.equals((Object)WaiterMateCustomerDisplay.instance.displays.get(0).getSystemState());
    }

    public void accountChanged(Account theAccount) {
        if (this.frame != null) {
            this.frame.stopDialog();
            this.frame.setAccount(theAccount);
        }
    }

    public void displayDialog(String theMessage) {
        if (this.frame != null) {
            this.frame.displayDialog(theMessage);
        }
    }

    public void displayDialog(JComponent comp) {
        if (this.frame != null) {
            this.frame.displayDialog(comp);
        }
    }

    public void stopDialog() {
        if (this.frame != null) {
            this.frame.stopDialog();
        }
    }

    public void sendMessage() {
        String message;
        if (this.frame != null && (message = this.acquireMessage()) != null) {
            this.frame.setMessage(message);
        }
    }

    private String acquireMessage() {
        CustomerMessageGetter getter = new CustomerMessageGetter(this.displays.get(0), this.frame.getAccount());
        return getter.getMessage();
    }

    public CustomerDisplayFrame getFrame() {
        return this.frame;
    }
}

