/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.customerdisplay.advertising;

import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.util.image.ImageHelper;
import java.awt.Dimension;
import java.awt.Image;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import ordermate.OrderMate;
import ordermate.database.misc.resource.ConfigResource;
import ordermate.database.misc.resource.ConfigResourceSet;
import ordermate.database.sales.Account;
import waitermate.gui.customerdisplay.advertising.AdvertPanel;
import waitermate.gui.customerdisplay.advertising.AdvertisementBag;
import waitermate.upsell.Upsell;

public abstract class AdvertisementManager {
    private static final long DEFAULT_DELAY = 30000L;
    protected AdvertisementBag adBag = new AdvertisementBag();
    protected AdvertisementBag bannerBag = new AdvertisementBag();
    protected AdvertisementBag orderBag = new AdvertisementBag();
    private AdvertPanel advertPanel;
    private AdvertPanel bannerPanel;
    private Account account;
    protected Timer adTimer = new Timer();
    protected UpdateAdTask bannerTask;
    protected UpdateAdTask advertTask;
    protected UpdateAdTask orderTask;
    protected boolean needsReload = true;
    protected boolean started = false;

    public AdvertisementManager() {
        this.advertPanel = this.createAdvertisementPanel();
        this.bannerPanel = this.createBannerPanel();
    }

    public void start() {
        this.killAdvertTasks();
        if (this.needsReload) {
            this.reload();
        }
        this.started = true;
        this.change();
    }

    public void stop() {
        this.killAdvertTasks();
        this.started = false;
    }

    protected long getDelay() {
        return 30000L;
    }

    protected void change() {
        this.changeAdvertisement(AdvertType.Advertisement);
        this.changeAdvertisement(AdvertType.Banner);
    }

    protected void reload() {
        this.needsReload = false;
        this.adBag.initialiseBag(this.getSet(AdvertType.Advertisement));
        this.bannerBag.initialiseBag(this.getSet(AdvertType.Banner));
        this.orderBag.initialiseBag(this.getSet(AdvertType.Order));
    }

    protected abstract ConfigResourceSet getSet(AdvertType var1);

    public void accountChanged(Account newAccount) {
        if (newAccount != this.account) {
            this.account = newAccount;
            if (this.account == null) {
                this.changeAdvertisement(AdvertType.Advertisement);
            } else {
                this.changeAdvertisement(AdvertType.Order);
            }
            this.advertPanel.validate();
            this.advertPanel.repaint();
        }
    }

    public JComponent getAdvertPanel() {
        return this.advertPanel;
    }

    public JComponent getBannerPanel() {
        return this.bannerPanel;
    }

    protected AdvertPanel createAdvertisementPanel() {
        AdvertPanel comp = new AdvertPanel(null, 100, 0.1f, 0.9f);
        comp.setDefaultImage(IconLoader.getImage((String)"/waitermate/images/welcome.png"));
        return comp;
    }

    protected AdvertPanel createBannerPanel() {
        ImageHelper helper = new ImageHelper();
        Image image = helper.fitImageTo(IconLoader.getImage((String)"/waitermate/images/om_watermark_red.png"), 100, 100);
        AdvertPanel comp = new AdvertPanel(image, 100, 1.0f, 0.5f);
        comp.setDefaultImage(null);
        comp.setPreferredSize(new Dimension(100, 100));
        return comp;
    }

    protected void changeAdvertisement(AdvertType type) {
        this.advertPanel.validate();
        if (AdvertType.Advertisement.equals((Object)type)) {
            this.changeAdvertMain(this.adBag.getAnotherResource());
        } else if (AdvertType.Order.equals((Object)type)) {
            this.changeAdvertForOrder(this.orderBag.getAnotherResource());
        } else if (AdvertType.Banner.equals((Object)type)) {
            this.changeAdvertForBanner(this.bannerBag.getAnotherResource());
        }
    }

    private void changeAdvertMain(ConfigResource resource) {
        this.killAdvertTasks();
        this.advertPanel.setConfigResource(resource);
        this.advertTask = new UpdateAdTask(AdvertType.Advertisement);
        this.rescheduleTask(resource, this.advertTask, this.getDelay());
    }

    private void changeAdvertForOrder(ConfigResource resource) {
        this.killAdvertTasks();
        this.advertPanel.setConfigResource(resource);
        this.orderTask = new UpdateAdTask(AdvertType.Order);
        this.rescheduleTask(resource, this.orderTask, this.getDelay());
    }

    private void changeAdvertForBanner(ConfigResource resource) {
        this.bannerPanel.setConfigResource(resource);
        this.bannerTask = new UpdateAdTask(AdvertType.Banner);
        this.rescheduleTask(resource, this.bannerTask, this.getDelay());
    }

    protected void rescheduleTask(ConfigResource resource, UpdateAdTask task, long time) {
        if (resource != null && resource.getMilliSeconds() != null && !Long.valueOf(0L).equals(resource.getMilliSeconds())) {
            time = resource.getMilliSeconds();
        }
        try {
            this.adTimer.schedule((TimerTask)task, time);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot schedule update task. Killing timer and starting again.");
            if (this.adTimer != null) {
                this.adTimer.cancel();
            }
            this.adTimer = new Timer();
            this.start();
        }
    }

    public void killAdvertTasks() {
        if (this.orderTask != null) {
            this.orderTask.cancel();
        }
        if (this.advertTask != null) {
            this.advertTask.cancel();
        }
    }

    public void gotUpsell(Upsell upsell, ConfigResource resource) {
        if (this.account != null && upsell != null && resource != null) {
            this.changeAdvertForOrder(resource);
        }
    }

    public class UpdateAdTask
    extends TimerTask {
        private AdvertType type;

        public UpdateAdTask(AdvertType yourType) {
            this.type = yourType;
        }

        @Override
        public void run() {
            if (AdvertisementManager.this.started) {
                AdvertisementManager.this.changeAdvertisement(this.type);
            }
        }
    }

    public static enum AdvertType {
        Advertisement,
        Banner,
        Order;

    }
}

