/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.customerdisplay.feedback;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.util.image.ImageHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import ordermate.OrderMate;
import ordermate.database.feedback.FeedbackAck;
import ordermate.database.feedback.FeedbackAnswer;
import ordermate.database.feedback.FeedbackQuestion;
import ordermate.database.feedback.FeedbackResponse;
import ordermate.database.gui.FontAttributes;
import ordermate.database.misc.customerdisplay.QAndACustomerDisplay;
import ordermate.gui.themes.OrderMateTheme;
import waitermate.gui.customerdisplay.CustomerDisplayDebugHelper;
import waitermate.gui.customerdisplay.CustomerDisplayFunctionPanel;

public class QAndAFunctionPanel
extends CustomerDisplayFunctionPanel<QAndACustomerDisplay>
implements ActionListener {
    private static final long ACK_DELAY = 5000L;
    private static final long QUESTION_DELAY = 15000L;
    private static final int BUTTON_MAX = 180;
    private static final int BUTTON_GAP = 50;
    private static final float IMAGE_SCALE = 0.75f;
    private static final int CENTER_PANEL_PADDING = 0;
    private int buttonDimention;
    private ImageTextPane questionPanel;
    private ImageTextPane ackPanel;
    private JPanel centrePanel;
    private JPanel topPanel;
    private JPanel buttonPanel;
    private List<JButton> buttons = new ArrayList<JButton>();
    private FeedbackQuestion mainQuestion;
    private FeedbackQuestion currentQuestion;
    private Timer timer = new Timer();
    private TimerTask ackTimer;
    private TimerTask qTimer;
    private QAndACustomerDisplay display;

    @Override
    protected void setupComponents() {
        this.questionPanel = new ImageTextPane();
        this.ackPanel = new ImageTextPane();
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 1));
        this.topPanel.setOpaque(false);
        this.topPanel.add(this.questionPanel);
        this.centrePanel = new JPanel(new FlowLayout(1));
        this.centrePanel.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.buttonPanel = new JPanel(new FlowLayout(1, 50, 50));
        this.centrePanel.setOpaque(false);
        this.buttonPanel.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.centrePanel, "Center");
        this.setOpaque(false);
    }

    @Override
    public void applyCustomerDisplay(QAndACustomerDisplay theDisplay) {
        this.display = theDisplay;
        this.mainQuestion = this.display.getMainQuestion();
        this.setupTextAreaFont(this.questionPanel.getJTextPane(), this.display.getQuestionAttributes());
        this.setupTextAreaFont(this.ackPanel.getJTextPane(), this.display.getAckAttributes());
        this.topPanel.setPreferredSize(new Dimension(100, theDisplay.getQuestionPanelHeight()));
        CustomerDisplayDebugHelper.renderBorders(this.questionPanel, Color.MAGENTA);
        CustomerDisplayDebugHelper.renderBorders(this.ackPanel, Color.MAGENTA);
        CustomerDisplayDebugHelper.renderBorders(this.questionPanel.getJTextPane(), Color.CYAN);
        CustomerDisplayDebugHelper.renderBorders(this.ackPanel.getJTextPane(), Color.CYAN);
        CustomerDisplayDebugHelper.renderBorders(this.buttonPanel, Color.BLUE);
        CustomerDisplayDebugHelper.renderBorders(this.centrePanel, Color.ORANGE);
        CustomerDisplayDebugHelper.renderBorders(this.topPanel, Color.ORANGE);
    }

    private void setupTextAreaFont(JTextPane comp, FontAttributes att) {
        comp.setFont(att.generateFont());
        comp.setForeground(att.getColour());
        StyledDocument doc = comp.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 1);
        doc.setParagraphAttributes(0, doc.getLength(), center, false);
        comp.setEditable(false);
        comp.setOpaque(false);
        comp.setBorder(new LineBorder(new Color(0.0f, 0.0f, 0.0f, 0.0f)));
    }

    private void setupButtonFont(Component comp, FontAttributes att) {
        comp.setFont(att.generateFont());
        comp.setForeground(att.getColour());
    }

    void doQuestion(FeedbackQuestion question) {
        if (this.qTimer != null) {
            this.qTimer.cancel();
        }
        if (!this.mainQuestion.equals((Object)question)) {
            this.qTimer = this.makeTimerTask(this.mainQuestion);
            this.timer.schedule(this.qTimer, 15000L);
        }
        this.centrePanel.removeAll();
        this.currentQuestion = question;
        if (question == null) {
            this.questionPanel.getJTextPane().setText("This is an invalid question. Please reconfigure.");
            return;
        }
        this.questionPanel.getJTextPane().setText(question.getQuestionText());
        ImageIcon icon = this.getIcon(this.currentQuestion.getIcon());
        if (icon != null) {
            this.questionPanel.getJLabel().setIcon(icon);
        }
        this.setupButtons();
        this.centrePanel.add(this.buttonPanel);
        this.validate();
        this.repaint();
    }

    private void setupButtons() {
        for (JButton button : this.buttons) {
            button.removeActionListener(this);
        }
        this.buttons.clear();
        this.buttonPanel.removeAll();
        int buttonCount = this.currentQuestion.getAnswers().size();
        this.buttonDimention = this.getWidth() > buttonCount * 180 + (buttonCount - 1) * 50 ? 180 : (this.getWidth() - (buttonCount - 1) * 50) / buttonCount;
        for (FeedbackAnswer answer : this.currentQuestion.getAnswers()) {
            JButton button = this.setupButton(answer);
            this.buttonPanel.add(button);
            this.buttons.add(button);
        }
    }

    private JButton setupButton(FeedbackAnswer answer) {
        JButton button = new JButton(answer.getAnswerText());
        ImageIcon icon = this.getIcon(answer.getIcon());
        button.setPreferredSize(new Dimension(this.buttonDimention, this.buttonDimention));
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        button.setForeground(UIManager.getColor("TextArea.foreground"));
        if (icon != null) {
            ImageHelper imgHelp = new ImageHelper();
            Image imageIcon = imgHelp.fitImageTo(icon.getImage(), (int)((float)this.buttonDimention * 0.75f), (int)((float)this.buttonDimention * 0.75f));
            icon.setImage(imageIcon);
            button.setIcon(icon);
        }
        button.addActionListener(this);
        button.setBorderPainted(true);
        OrderMateTheme.setupTouchScreenButton((AbstractButton)button);
        this.setupButtonFont(button, this.display.getAnswerAttributes());
        return button;
    }

    private ImageIcon getIcon(String iconString) {
        if (iconString != null && !iconString.isEmpty()) {
            try {
                return IconLoader.get((String)iconString);
            }
            catch (IconLoader.IconNotFoundException ex) {
                OrderMate.LOG.warn("Cannot load icon feedback:" + iconString);
            }
        }
        return null;
    }

    private void doResponse(int index) {
        FeedbackAnswer answer = (FeedbackAnswer)this.currentQuestion.getAnswers().get(index);
        FeedbackResponse response = new FeedbackResponse(this.currentQuestion, answer, null);
        response.save();
        this.doAcknowledge(answer);
    }

    private void doAcknowledge(FeedbackAnswer answer) {
        FeedbackAck ack = answer.getFeedbackAck();
        if (ack == null) {
            ack = this.currentQuestion.getDefaultAck();
        }
        if (ack != null) {
            this.ackPanel.getJTextPane().setText(ack.getAckText());
            ImageIcon icon = this.getIcon(ack.getIcon());
            if (icon != null) {
                this.ackPanel.getJLabel().setIcon(icon);
            }
        } else {
            this.ackPanel.getJTextPane().setText("Thank you for your feedback.");
        }
        this.centrePanel.removeAll();
        this.centrePanel.add(this.ackPanel);
        this.centrePanel.validate();
        this.centrePanel.repaint();
        this.pauseAndReturn(answer.getNextQuestion());
    }

    void pauseAndReturn(FeedbackQuestion question) {
        if (this.ackTimer != null) {
            this.ackTimer.cancel();
        }
        this.ackTimer = this.makeTimerTask(question);
        this.timer.schedule(this.ackTimer, 5000L);
    }

    private TimerTask makeTimerTask(final FeedbackQuestion question) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (question == null) {
                            QAndAFunctionPanel.this.doQuestion(QAndAFunctionPanel.this.mainQuestion);
                        } else {
                            QAndAFunctionPanel.this.doQuestion(question);
                        }
                    }
                });
            }
        };
        return task;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (source != this.buttons.get(i)) continue;
            this.doResponse(i);
        }
    }

    static class ImageTextPane
    extends JPanel {
        private JTextPane theTextPane = new JTextPane();
        private JLabel theImageLabel = new JLabel();

        ImageTextPane() {
            this.theImageLabel.setPreferredSize(new Dimension(120, 120));
            this.theImageLabel.setAlignmentX(0.5f);
            this.theTextPane.setAlignmentX(0.5f);
            this.theImageLabel.setAlignmentY(0.5f);
            this.theTextPane.setAlignmentY(0.5f);
            this.theTextPane.setOpaque(false);
            this.theTextPane.setBorder(new LineBorder(new Color(0.0f, 0.0f, 0.0f, 0.0f)));
            this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(40, 20)));
            this.add((Component)this.theImageLabel, new Rectangle(1, 2, 6, 17));
            this.add((Component)this.theTextPane, new Rectangle(6, 4, 28, 12));
            this.setOpaque(false);
        }

        public JTextPane getJTextPane() {
            return this.theTextPane;
        }

        public JLabel getJLabel() {
            return this.theImageLabel;
        }
    }
}

