/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.customerdisplay.ordering;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import ordermate.database.misc.customerdisplay.OrderCustomerDisplay;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.SellableWrapperFactory;
import waitermate.gui.customerdisplay.advertising.ImagedPanel;
import waitermate.gui.customerdisplay.ordering.line.SalesLineItemRenderer;

class OrderingBodyPanel
extends ImagedPanel {
    private static final int TOP_PAD = 20;
    private static final int BOTTOM_PAD = 20;
    private static final int LEFT_PAD = 20;
    private static final int RIGHT_PAD = 20;
    private Map<Sellable, SalesLineItemRenderer> renderers = new HashMap<Sellable, SalesLineItemRenderer>();
    private Account account;
    private JPanel holder;
    private JPanel fakePanel;
    private OrderCustomerDisplay display;
    private SellableWrapperFactory sellableFactory;

    OrderingBodyPanel() {
        super((Image)null);
        this.setLayout(new BorderLayout());
        this.setBackground(null);
        this.setOpaque(false);
        this.holder = new JPanel();
        this.holder.setOpaque(false);
        this.holder.setLayout(new BoxLayout(this.holder, 1));
        this.fakePanel = new JPanel(new BorderLayout());
        this.fakePanel.add((Component)this.holder, "North");
        this.fakePanel.setOpaque(false);
        this.sellableFactory = new SellableWrapperFactory();
        this.add(this.fakePanel);
        this.setBorder(new EmptyBorder(new Insets(20, 20, 20, 20)));
    }

    void applyCustomerDisplay(OrderCustomerDisplay yourDisplay) {
        this.display = yourDisplay;
        this.setPreferredSize(new Dimension(yourDisplay.getOrderWidth(), 100));
    }

    public void setAccount(Account value) {
        if (this.account != value) {
            this.renderers.clear();
        }
        this.account = value;
        this.holder.removeAll();
        this.renderers.clear();
        if (this.account != null) {
            for (Sellable item : this.sellableFactory.getSellables((ItemGroup)this.account)) {
                SalesLineItemRenderer rend = null;
                if (!this.renderers.containsKey(item)) {
                    rend = new SalesLineItemRenderer(item);
                    rend.setObject(item);
                    this.renderers.put(item, rend);
                    rend.applyCustomerDisplay(this.display);
                } else {
                    rend = this.renderers.get(item);
                }
                rend.updateRenderer();
                this.holder.add(rend.getRenderingComponent());
            }
        }
    }
}

