/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.customerdisplay.ordering;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.VoucherTransactionHelper;
import ordermate.database.gui.FontAttributes;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.customerdisplay.OrderCustomerDisplay;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemHelper;
import waitermate.gui.customerdisplay.advertising.ImagedPanel;

class OrderingFooterPanel
extends ImagedPanel {
    private static final String BLANK = " ";
    private static final int TOP_PAD = 25;
    private static final int BOTTOM_PAD = 25;
    private static final int LEFT_PAD = 3;
    private static final int RIGHT_PAD = 3;
    private static final int PERFERREED_HEIGHT = 150;
    private JLabel discountNameLabel;
    private JLabel surchargeNameLabel;
    private JLabel tenderedNameLabel;
    private JLabel changeNameLabel;
    private JLabel paymentsNameLabel;
    private JLabel totalNameLabel;
    private JLabel dueNameLabel;
    private JLabel voucherBalanceNameLabel;
    private JLabel subtotalNameLabel;
    private JLabel totalTaxNameLabel;
    private JLabel discountLabel;
    private JLabel surchargeLabel;
    private JLabel tenderedLabel;
    private JLabel changeLabel;
    private JLabel paymentsLabel;
    private JLabel totalLabel;
    private JLabel dueLabel;
    private JLabel voucherBalanceLabel;
    private JLabel subtotalLabel;
    private JLabel totalTaxLabel;
    private static final String SUBTOTAL_LABEL = "Subtotal:";
    private static final String TOTAL_TAX_LABEL = "Tax:";
    private Set<JLabel> labels = new HashSet<JLabel>();

    public OrderingFooterPanel() {
        super((Image)null);
        this.setLayout((LayoutManager)new GraphPaperLayout(17, 8));
        this.setupComponents();
        this.setPreferredSize(this.getPreferredSize());
    }

    private void setupComponents() {
        this.setBackground(null);
        this.setOpaque(false);
        int FAR_LEFT = 1;
        int LEFT = 2;
        int RIGHT = 9;
        int FAR_RIGHT = 10;
        int baseIndex = 0;
        this.subtotalNameLabel = this.addLabel(SUBTOTAL_LABEL, RIGHT, baseIndex, false);
        this.subtotalLabel = this.addLabel(BLANK, FAR_RIGHT, baseIndex, true);
        this.totalTaxNameLabel = this.addLabel(TOTAL_TAX_LABEL, RIGHT, ++baseIndex, false);
        this.totalTaxLabel = this.addLabel(BLANK, FAR_RIGHT, baseIndex, true);
        this.discountNameLabel = this.addLabel("Discount:", RIGHT, ++baseIndex, false);
        this.discountLabel = this.addLabel(BLANK, FAR_RIGHT, baseIndex, true);
        this.surchargeNameLabel = this.addLabel("Surcharge:", RIGHT, ++baseIndex, false);
        this.surchargeLabel = this.addLabel(BLANK, FAR_RIGHT, baseIndex, true);
        this.totalNameLabel = this.addLabel("Total:", RIGHT, ++baseIndex, false);
        this.totalLabel = this.addLabel(BLANK, FAR_RIGHT, baseIndex, true);
        this.paymentsNameLabel = this.addLabel("Payments:", FAR_LEFT, ++baseIndex, false);
        this.paymentsLabel = this.addLabel(BLANK, LEFT, baseIndex, true);
        this.dueNameLabel = this.addLabel("Due:", RIGHT, baseIndex, false);
        this.dueLabel = this.addLabel(BLANK, FAR_RIGHT, baseIndex, true);
        this.tenderedNameLabel = this.addLabel("Tendered:", FAR_LEFT, ++baseIndex, false);
        this.tenderedLabel = this.addLabel(BLANK, LEFT, baseIndex, true);
        this.changeNameLabel = this.addLabel("Change:", RIGHT, baseIndex, false);
        this.changeLabel = this.addLabel(BLANK, FAR_RIGHT, baseIndex, true);
        this.voucherBalanceNameLabel = this.addLabel("Voucher Balance:", FAR_LEFT, ++baseIndex, false);
        this.voucherBalanceLabel = this.addLabel(BLANK, FAR_RIGHT, baseIndex, true);
        this.setBorder(new EmptyBorder(new Insets(25, 3, 25, 3)));
    }

    private JLabel addLabel(String text, int xLoc, int yLoc, boolean isPrice) {
        JLabel label = new JLabel(text);
        if (isPrice) {
            label.setHorizontalAlignment(4);
        }
        this.add((Component)label, new Rectangle(xLoc, yLoc, 6, 1));
        this.labels.add(label);
        return label;
    }

    public void applyCustomerDisplay(OrderCustomerDisplay display) {
        FontAttributes attributes = display.getFooterAttributes();
        Font font = attributes.generateFont();
        Color colour = attributes.getColour();
        for (JLabel label : this.labels) {
            label.setForeground(colour);
            label.setFont(font);
        }
        int height = (int)(font.getSize2D() * 7.0f + font.getSize2D() * 1.2f + 25.0f + 25.0f);
        font = font.deriveFont(font.getSize2D() * 1.2f);
        this.changeNameLabel.setFont(font);
        this.changeLabel.setFont(font);
        this.tenderedNameLabel.setFont(font);
        this.tenderedLabel.setFont(font);
        this.setPreferredSize(new Dimension(17, height));
    }

    public void setAccount(Account account) {
        if (account == null) {
            this.surchargeLabel.setText(BLANK);
            this.discountLabel.setText(BLANK);
            this.paymentsLabel.setText(BLANK);
            this.dueLabel.setText(BLANK);
            this.totalLabel.setText(BLANK);
            this.tenderedNameLabel.setText(BLANK);
            this.changeNameLabel.setText(BLANK);
            this.voucherBalanceNameLabel.setText(BLANK);
            this.voucherBalanceLabel.setText(BLANK);
            this.hideExTaxFields();
        } else {
            List discounts = account.getPriceAdjHelper().getDiscounts();
            if (!discounts.isEmpty()) {
                Price totalDiscounts = this.getTotalAdjustments(discounts);
                this.discountLabel.setText("-" + totalDiscounts.toString(true));
                this.discountNameLabel.setText("Discount:");
            } else {
                this.discountLabel.setText(BLANK);
                this.discountNameLabel.setText(BLANK);
            }
            List surcharges = account.getPriceAdjHelper().getSurcharges();
            if (!surcharges.isEmpty()) {
                Price totalSurcharges = this.getTotalAdjustments(surcharges);
                this.surchargeLabel.setText(totalSurcharges.toString(true));
                this.surchargeNameLabel.setText("Surcharge:");
            } else {
                this.surchargeLabel.setText(BLANK);
                this.surchargeNameLabel.setText(BLANK);
            }
            this.totalLabel.setText(account.getTotal().toString(true));
            this.paymentsLabel.setText(account.getTendered().toString(true));
            this.dueLabel.setText(account.getDue().toString(true));
            List txns = account.getFinanceTransactions();
            if (txns != null && !txns.isEmpty()) {
                this.tenderedLabel.setText(((FinanceTransaction)txns.get(txns.size() - 1)).getTendered().toString(true));
                this.changeLabel.setText(((FinanceTransaction)txns.get(txns.size() - 1)).getChange().toString(true));
                this.tenderedNameLabel.setText("Tendered:");
                this.changeNameLabel.setText("Change:");
            } else {
                this.tenderedNameLabel.setText(BLANK);
                this.changeNameLabel.setText(BLANK);
                this.tenderedLabel.setText(BLANK);
                this.changeLabel.setText(BLANK);
            }
            GiftVoucher voucher = VoucherTransactionHelper.getInstance().getLastValidRedeemVoucher(account);
            if (voucher != null) {
                this.voucherBalanceNameLabel.setText("Voucher Balance:");
                this.voucherBalanceLabel.setText(voucher.getCachedValue().toString(true));
            } else {
                this.voucherBalanceNameLabel.setText(BLANK);
                this.voucherBalanceLabel.setText(BLANK);
            }
            this.updateExTaxFields(account);
        }
    }

    private Price getTotalAdjustments(List<? extends SalesPriceAdjustment> adjustments) {
        Price price = Price.ZERO_DOLLAR;
        for (SalesPriceAdjustment salesPriceAdjustment : adjustments) {
            price = price.add(salesPriceAdjustment.getValue());
        }
        return price.abs();
    }

    private void updateExTaxFields(Account account) {
        if (SystemProperty.getInstance().isExTax()) {
            this.showExTaxFields(account);
        } else {
            this.hideExTaxFields();
        }
    }

    private void showExTaxFields(Account account) {
        ItemHelper itemHelper = account.getItemHelper();
        this.subtotalNameLabel.setText(SUBTOTAL_LABEL);
        this.totalTaxNameLabel.setText(TOTAL_TAX_LABEL);
        this.subtotalLabel.setText(itemHelper.getItemTotal().toString());
        this.totalTaxLabel.setText(itemHelper.getItemTaxTotal().toString());
    }

    private void hideExTaxFields() {
        this.subtotalNameLabel.setText(BLANK);
        this.totalTaxNameLabel.setText(BLANK);
        this.subtotalLabel.setText(BLANK);
        this.totalTaxLabel.setText(BLANK);
    }
}

