/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.customerdisplay.ordering;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.customerdisplay.OrderCustomerDisplay;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import waitermate.gui.customerdisplay.advertising.ImagedPanel;

class OrderingHeaderPanel
extends ImagedPanel {
    private static final int TOP_PAD = 5;
    private static final int BOTTOM_PAD = 5;
    private static final int LEFT_PAD = 5;
    private static final int RIGHT_PAD = 5;
    private JLabel customerLabel;
    private JLabel headerLabel;

    OrderingHeaderPanel() {
        super((Image)null);
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(null);
        this.setOpaque(false);
        this.customerLabel = new JLabel();
        this.headerLabel = new JLabel();
        this.headerLabel.setAlignmentX(0.5f);
        this.customerLabel.setAlignmentX(0.5f);
        this.add(this.headerLabel);
        this.add(this.customerLabel);
        this.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
    }

    void setAccount(Account theAccount) {
        if (theAccount == null) {
            this.headerLabel.setText(" ");
            this.customerLabel.setText(" ");
        } else {
            this.headerLabel.setText(theAccount.getLabel());
            if (theAccount.getCustomer() != null) {
                Customer customer = theAccount.getCustomer();
                if (customer.getCategory() != null && customer.getCategory().isLoyaltyPointsEnabled() && SystemProperty.getInstance().isLoyaltyEnabled()) {
                    StringBuilder SB = new StringBuilder(customer.getFirstName());
                    SB.append(" - ").append("Points:").append(customer.getLoyaltyPoints());
                    this.customerLabel.setText(SB.toString());
                } else {
                    this.customerLabel.setText(customer.getFirstName());
                }
            } else {
                this.customerLabel.setText(" ");
            }
        }
    }

    void applyCustomerDisplay(OrderCustomerDisplay display) {
        this.customerLabel.setFont(display.getHeaderAttributes().generateFont());
        this.headerLabel.setFont(display.getHeaderAttributes().generateFont());
        this.customerLabel.setForeground(display.getHeaderAttributes().getColour());
        this.headerLabel.setForeground(display.getHeaderAttributes().getColour());
        this.setPreferredSize(new Dimension(20, display.getOrderHeaderHeight()));
    }
}

