/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.customerdisplay.ordering.line;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.gui.FontAttributes;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryWeightUnit;
import ordermate.database.misc.customerdisplay.OrderCustomerDisplay;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesLineItemWrapper;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.SellableWrapperFactory;
import ordermate.database.sales.VoucherTransactionWrapper;
import ordermate.internationalization.Internationalization;
import waitermate.gui.customerdisplay.ordering.line.SalesComponentLineRenderer;
import waitermate.gui.customerdisplay.ordering.line.SalesObjectRenderer;
import waitermate.gui.customerdisplay.ordering.line.SimpleSellableRenderer;

public class SalesLineItemRenderer
implements SalesObjectRenderer<Sellable> {
    private Sellable item;
    private JPanel holder;
    private JPanel comboHolder;
    private JLabel comboLabel;
    private JLabel qtyLabel;
    private JPanel renderersPanel;
    private JLabel priceLabel;
    private JLabel dollarLabel;
    private JPanel pricePanel;
    private JPanel qtyPanel;
    private boolean dirty;
    private SellableWrapperFactory sellableFactory = new SellableWrapperFactory();
    private List<SalesObjectRenderer> renderers = new ArrayList<SalesObjectRenderer>();

    public SalesLineItemRenderer(Sellable theItem) {
        this.initComponents(theItem);
        if (this.item instanceof SalesLineItemWrapper) {
            SalesLineItem salesItem = (SalesLineItem)this.item.getSellingObject();
            if (salesItem instanceof SalesCombo) {
                this.comboHolder = new JPanel(new FlowLayout(0, 0, 0));
                this.comboHolder.setOpaque(false);
                this.comboLabel = new JLabel();
                this.comboLabel.setAlignmentX(0.0f);
                this.comboHolder.add(this.comboLabel);
            }
            if (salesItem instanceof SalesCombo || salesItem instanceof SalesItem && ((SalesItem)salesItem).getParentCombo() == null) {
                this.initQtyGUI();
                this.initPriceGUI();
            }
        } else if (this.item instanceof VoucherTransactionWrapper) {
            this.initPriceGUI();
        }
        this.rebuild();
    }

    private void initComponents(Sellable theItem) {
        this.item = theItem;
        this.holder = new JPanel(new BorderLayout(5, 0));
        this.holder.setOpaque(false);
        this.renderersPanel = new JPanel();
        this.renderersPanel.setOpaque(false);
        this.renderersPanel.setLayout(new BoxLayout(this.renderersPanel, 1));
        this.renderersPanel.setAlignmentX(0.0f);
        this.holder.add((Component)this.renderersPanel, "Center");
    }

    private void initQtyGUI() {
        this.qtyLabel = new JLabel();
        this.qtyLabel.setVerticalAlignment(1);
        this.qtyLabel.setHorizontalAlignment(2);
        this.qtyPanel = new JPanel(new FlowLayout(0, 5, 0));
        this.qtyPanel.setOpaque(false);
        this.qtyPanel.add(this.qtyLabel);
        this.qtyPanel.add(Box.createHorizontalStrut(10));
        this.holder.add((Component)this.qtyPanel, "West");
    }

    private void initPriceGUI() {
        this.priceLabel = new JLabel();
        this.priceLabel.setVerticalAlignment(1);
        this.priceLabel.setHorizontalAlignment(4);
        this.pricePanel = new JPanel(new BorderLayout());
        this.dollarLabel = new JLabel();
        this.dollarLabel.setVerticalAlignment(1);
        this.pricePanel.add((Component)this.dollarLabel, "West");
        this.priceLabel.setOpaque(false);
        this.pricePanel.add(this.priceLabel);
        this.pricePanel.setOpaque(false);
        this.pricePanel.add(Box.createHorizontalStrut(10), "East");
        this.holder.add((Component)this.pricePanel, "East");
    }

    @Override
    public JComponent getRenderingComponent() {
        return this.holder;
    }

    @Override
    public void applyCustomerDisplay(OrderCustomerDisplay display) {
        FontAttributes attributes = display.getLineAttributes();
        Font font = attributes.generateFont();
        FontMetrics metrics = null;
        int length = 0;
        if (this.qtyLabel != null) {
            metrics = this.qtyLabel.getFontMetrics(font);
            length = metrics.charWidth('m');
            this.qtyLabel.setFont(font);
            this.qtyLabel.setForeground(attributes.getColour());
            this.qtyLabel.setPreferredSize(new Dimension(length * 6, metrics.getHeight()));
        }
        if (this.priceLabel != null) {
            metrics = this.priceLabel.getFontMetrics(font);
            length = metrics.charWidth('m');
            this.dollarLabel.setFont(font);
            this.priceLabel.setFont(font);
            this.dollarLabel.setForeground(attributes.getColour());
            this.priceLabel.setForeground(attributes.getColour());
            this.priceLabel.setPreferredSize(new Dimension(length * 5, metrics.getHeight()));
        }
        if (this.comboLabel != null) {
            this.comboLabel.setFont(font);
            this.comboLabel.setForeground(attributes.getColour());
        }
        for (SalesObjectRenderer renderer : this.renderers) {
            renderer.applyCustomerDisplay(display);
        }
    }

    @Override
    public void setObject(Sellable object) {
        if (this.item != object) {
            this.renderersPanel.removeAll();
            this.renderers.clear();
            this.item = object;
            this.dirty = true;
        }
    }

    @Override
    public void updateRenderer() {
        if (this.dirty) {
            this.rebuild();
        } else {
            this.refresh();
        }
        this.dirty = false;
    }

    private void rebuild() {
        if (this.item instanceof SalesLineItemWrapper) {
            SalesLineItem salesLineItem = (SalesLineItem)this.item.getSellingObject();
            if (salesLineItem instanceof SalesCombo) {
                this.renderersPanel.add(this.comboHolder);
                this.comboLabel.setText(((SalesCombo)salesLineItem).getLabel());
                this.qtyLabel.setText(salesLineItem.getQuantity().toString());
                this.dollarLabel.setText(Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
                this.priceLabel.setText(salesLineItem.getSubtotalPrice().toString(false));
                for (SalesItem nextItem : salesLineItem.getSalesItems()) {
                    SalesLineItemWrapper sellableItem = this.sellableFactory.wrapItem((SalesLineItem)nextItem);
                    SalesLineItemRenderer rend = new SalesLineItemRenderer((Sellable)sellableItem);
                    rend.setObject((Sellable)sellableItem);
                    this.renderers.add(rend);
                    this.renderersPanel.add(rend.getRenderingComponent());
                    rend.updateRenderer();
                }
            } else if (salesLineItem instanceof SalesItem) {
                SalesItem salesItem = (SalesItem)salesLineItem;
                InventoryItemUnit unit = ((SalesComponent)salesItem.getComponentList().get(0)).getUnit();
                if (this.qtyLabel != null) {
                    if (unit.getItem().getSizes().size() == 1) {
                        this.qtyLabel.setText(this.resolveQuantityDisplay(salesItem));
                    } else {
                        this.qtyLabel.setText(salesItem.getQuantity().toString() + " " + unit.getSize().getShortName());
                    }
                    this.dollarLabel.setText(Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
                    this.priceLabel.setText(salesItem.getSubtotalPrice().toString(false));
                }
                for (SalesComponent component : salesItem.getComponentList()) {
                    SalesComponentLineRenderer rend = new SalesComponentLineRenderer();
                    rend.setObject(component);
                    this.renderers.add(rend);
                    this.renderersPanel.add(rend.getRenderingComponent());
                    rend.updateRenderer();
                    rend.getRenderingComponent().invalidate();
                }
            }
        } else if (this.item instanceof VoucherTransactionWrapper) {
            SimpleSellableRenderer rend = new SimpleSellableRenderer();
            rend.setObject(this.item);
            this.renderers.add(rend);
            this.renderersPanel.add(rend.getRenderingComponent());
            rend.updateRenderer();
            rend.getRenderingComponent().invalidate();
            VoucherTransactionWrapper vTxnWrapper = (VoucherTransactionWrapper)this.item;
            GiftVoucherTransaction voucherTxn = vTxnWrapper.getSellingObject();
            if (voucherTxn.isTopup() || voucherTxn.isTopupReversal()) {
                this.dollarLabel.setText(Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
                this.priceLabel.setText(this.item.getPrice().toString(false));
            }
        }
    }

    private void refresh() {
        for (SalesObjectRenderer nextRenderer : this.renderers) {
            nextRenderer.updateRenderer();
        }
    }

    private String resolveQuantityDisplay(SalesItem sItem) {
        InventoryItem iItem = sItem.getInventoryItemIfSingle();
        if (iItem != null && !InventoryWeightUnit.NA.equals((Object)iItem.getInventoryWeightUnit())) {
            return this.item.getQuantity().weightedQtyToString() + iItem.getInventoryWeightUnit().getDisplay();
        }
        return this.item.getQuantity().toString();
    }
}

