/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.customerdisplay.ordering.line;

import java.awt.BorderLayout;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.gui.FontAttributes;
import ordermate.database.misc.customerdisplay.OrderCustomerDisplay;
import ordermate.database.sales.Sellable;
import waitermate.gui.customerdisplay.ordering.line.SalesObjectRenderer;

class SimpleSellableRenderer
implements SalesObjectRenderer<Sellable> {
    private Sellable sellable;
    private JPanel fillPanel = new JPanel(new BorderLayout());
    private JPanel renderingPanel;
    private JLabel label;

    SimpleSellableRenderer() {
        this.fillPanel.setOpaque(false);
        this.renderingPanel = new JPanel();
        this.renderingPanel.setOpaque(false);
        this.renderingPanel.setAlignmentX(0.0f);
        this.renderingPanel.setLayout(new BoxLayout(this.renderingPanel, 1));
        this.label = new JLabel();
        this.renderingPanel.add(this.label);
        this.fillPanel.add(this.renderingPanel);
    }

    @Override
    public void updateRenderer() {
        this.renderingPanel.removeAll();
        this.label.setText(this.sellable.getLabel());
        this.renderingPanel.add(this.label);
        this.fillPanel.validate();
    }

    @Override
    public void setObject(Sellable object) {
        this.sellable = object;
    }

    @Override
    public JComponent getRenderingComponent() {
        return this.fillPanel;
    }

    @Override
    public void applyCustomerDisplay(OrderCustomerDisplay display) {
        FontAttributes attributes = display.getLineAttributes();
        this.label.setFont(attributes.generateFont());
        this.label.setForeground(attributes.getColour());
    }
}

