/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.dialogs;

import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.sales.SalesLineItem;
import waitermate.guikit.dialogs.PopupWindow;

public class ItemSplitDialog
extends PopupWindow {
    private JLabel leftLabel;
    private JLabel rightLabel;
    private JLabel itemNameLabel;
    private JLabel splitArrow;
    private JButton leftButton;
    private JButton rightButton;
    private SalesQuantity totalQuantity;
    private SalesQuantity splitQuantity;

    public ItemSplitDialog(SalesLineItem item) {
        this.setText("Split Item");
        this.totalQuantity = item.getQuantity();
        this.splitQuantity = SalesQuantity.ONE;
        this.leftLabel = new JLabel("Original");
        this.rightLabel = new JLabel("Split");
        this.splitArrow = new JLabel(IconLoader.get((String)"/waitermate/images/fatarrow.png"));
        this.itemNameLabel = new JLabel(item.toString());
        this.leftButton = new JButton();
        this.leftButton.setName("leftButton");
        this.rightButton = new JButton();
        this.rightButton.setName("rightButton");
        Dimension BUTTON_SIZE = new Dimension(50, 50);
        this.leftButton.setMinimumSize(BUTTON_SIZE);
        this.rightButton.setMinimumSize(BUTTON_SIZE);
        this.leftButton.setPreferredSize(BUTTON_SIZE);
        this.rightButton.setPreferredSize(BUTTON_SIZE);
        this.updateButtons();
        SplitButtonActionListener listener = new SplitButtonActionListener();
        this.leftButton.addActionListener(listener);
        this.rightButton.addActionListener(listener);
        JPanel allPanel = new JPanel(new BorderLayout());
        JPanel leftPanel = new JPanel(new BorderLayout());
        JPanel rightPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.leftLabel, "North");
        leftPanel.add((Component)this.leftButton, "Center");
        rightPanel.add((Component)this.rightLabel, "North");
        rightPanel.add((Component)this.rightButton, "Center");
        JPanel buttonPanel = new JPanel(new GridLayout(1, 3));
        buttonPanel.add(leftPanel);
        buttonPanel.add(this.splitArrow);
        buttonPanel.add(rightPanel);
        allPanel.add((Component)this.itemNameLabel, "North");
        allPanel.add((Component)buttonPanel, "Center");
        this.setComponent(allPanel);
    }

    private void updateButtons() {
        this.leftButton.setText("" + this.totalQuantity.subtract(this.splitQuantity));
        this.rightButton.setText("" + this.splitQuantity);
        this.leftButton.setEnabled(this.splitQuantity.greaterThan(1L));
        this.rightButton.setEnabled(this.splitQuantity.lessThan(this.totalQuantity.subtract(new SalesQuantity("1"))));
    }

    public SalesQuantity getSplitQuantity() {
        return this.splitQuantity;
    }

    private class SplitButtonActionListener
    implements ActionListener {
        private SplitButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ItemSplitDialog.this.leftButton) {
                if (ItemSplitDialog.this.splitQuantity.greaterThan(1L)) {
                    ItemSplitDialog.this.splitQuantity = ItemSplitDialog.this.splitQuantity.subtract(SalesQuantity.ONE);
                }
            } else if (e.getSource() == ItemSplitDialog.this.rightButton && ItemSplitDialog.this.splitQuantity.lessThan(ItemSplitDialog.this.totalQuantity)) {
                ItemSplitDialog.this.splitQuantity = ItemSplitDialog.this.splitQuantity.add(SalesQuantity.ONE);
            }
            ItemSplitDialog.this.updateButtons();
        }
    }
}

