/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.dialogs;

import au.com.ordermate.units.SalesQuantity;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import ordermate.database.sales.SalesLineItem;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DefaultScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.selectaccount.table.CoversHelper;

public class SeatDialogPanel
extends JPanel
implements ActionListener {
    public Signal seatFinished = Signals.createSignal();
    private final CustomScrollPane seats;
    private final DefaultScrollPaneModel seatPaneModel = new DefaultScrollPaneModel(4, 3);
    private List<JToggleButton> buttonGroup;
    private SalesLineItem currItem;
    private int qtyCount = 0;
    boolean singleQtyValue;
    private Integer selectedSeat;

    public SeatDialogPanel() {
        this.seats = new CustomScrollPane((CustomScrollPaneModel)this.seatPaneModel);
        this.add((Component)this.seats);
    }

    public void setup(SalesLineItem newItem, int numSeats) {
        this.singleQtyValue = this.checkSingleQty(newItem);
        this.currItem = newItem;
        this.seatPaneModel.reset();
        this.buttonGroup = new ArrayList<JToggleButton>();
        for (int i = 0; i < numSeats + 1; ++i) {
            JToggleButton newButton = new JToggleButton();
            newButton.setPreferredSize(new Dimension(150, 150));
            newButton.addActionListener(this);
            newButton.setModel(new SeatNumberButtonModel(i));
            this.buttonGroup.add(newButton);
            this.seatPaneModel.addComponent((Component)newButton);
            this.updateButton(newButton, (SeatNumberButtonModel)newButton.getModel());
        }
        this.clearQty();
    }

    private boolean checkSingleQty(SalesLineItem newItem) {
        SalesQuantity ordredQty = newItem.getQuantity();
        double unflooredValue = ordredQty.getValue().doubleValue();
        double salesQuantityValueFloored = Math.floor(unflooredValue);
        return !ordredQty.greaterThan(1L) || unflooredValue != salesQuantityValueFloored;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JToggleButton button;
        ButtonModel model;
        Object source = e.getSource();
        if (source instanceof JToggleButton && (model = (button = (JToggleButton)source).getModel()) instanceof SeatNumberButtonModel) {
            if (!this.singleQtyValue) {
                ++this.qtyCount;
                ((SeatNumberButtonModel)model).incQuantity();
                this.updateButton(button, (SeatNumberButtonModel)model);
                if (this.qtyCount >= this.currItem.getQuantity().getValue().intValue()) {
                    this.seatFinished.emit();
                }
            } else {
                this.selectedSeat = ((SeatNumberButtonModel)model).getSeatNumber();
                this.seatFinished.emit();
            }
        }
    }

    public void clearQty() {
        this.qtyCount = 0;
        for (JToggleButton button : this.buttonGroup) {
            ButtonModel model = button.getModel();
            if (!(model instanceof SeatNumberButtonModel)) continue;
            ((SeatNumberButtonModel)model).resetQuantity();
            this.updateButton(button, (SeatNumberButtonModel)model);
        }
    }

    public boolean isSingleQtyValue() {
        return this.singleQtyValue;
    }

    public Map<Integer, Integer> getSeatQuantityMap() {
        HashMap<Integer, Integer> toReturn = new HashMap<Integer, Integer>();
        for (JToggleButton button : this.buttonGroup) {
            ButtonModel model = button.getModel();
            if (!(model instanceof SeatNumberButtonModel)) continue;
            SeatNumberButtonModel butModel = (SeatNumberButtonModel)model;
            toReturn.put(butModel.getSeatNumber(), butModel.getSeatQty());
        }
        return toReturn;
    }

    public Integer getSeat() {
        return this.selectedSeat;
    }

    private void updateButton(JToggleButton button, SeatNumberButtonModel seatNumberButtonModel) {
        int seatNum = seatNumberButtonModel.getSeatNumber();
        String label = "";
        label = seatNum == 0 ? label + Internationalization.getLiteralFor((String)"ALL") : label + CoversHelper.getCorrectCoverLiteral() + " " + seatNum;
        int seatQty = seatNumberButtonModel.getSeatQty();
        if (seatQty > 0) {
            label = label + " (" + seatQty + ")";
            button.setSelected(true);
            OrderMateTheme.setupToggledButton((AbstractButton)button);
        } else {
            button.setSelected(false);
            OrderMateTheme.setupUntoggledButton((AbstractButton)button);
        }
        button.setText(label);
    }

    private class SeatNumberButtonModel
    extends JToggleButton.ToggleButtonModel {
        private int seatNumber;
        private int seatQty;

        public SeatNumberButtonModel(int seat) {
            this.seatNumber = seat;
            this.resetQuantity();
        }

        public int getSeatNumber() {
            return this.seatNumber;
        }

        public int getSeatQty() {
            return this.seatQty;
        }

        public void incQuantity() {
            ++this.seatQty;
        }

        public void resetQuantity() {
            this.seatQty = 0;
        }
    }
}

