/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.dialogs;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.PropertiedObject;
import ca.odell.glazedlists.EventList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.gui.autosuggestor.StringSearcherSuggestor;
import ordermate.gui.autosuggestor.Suggestor;
import ordermate.gui.keyboard.Keyboard;
import ordermate.gui.keypad.Keypad;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.scroll.renderer.StringRenderer;
import waitermate.guikit.ModalScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.PopupWindow;

public class SuggestDialog
extends ModalScreen {
    private static SuggestDialog dialog;
    private static boolean fullScreen;
    private static PopupWindow dialogWindow;
    private CustomScrollPane scrollPane;
    private RendererScrollPaneModel model;
    private Keypad numericKeyPad;
    private Keyboard normalKeyboard;
    private Suggestor suggestor;
    private Object selectedObject;
    private String text = "";
    private JLabel textLabel;
    private JLabel typeLabel;
    private JPanel mainArea;
    private NavBar navBar;
    private boolean result;
    private boolean useNumeric = false;

    SuggestDialog() {
        StringRenderer renderer = new StringRenderer();
        renderer.selected.connect((Object)this, "stringChosen");
        this.model = new RendererScrollPaneModel((Renderer)renderer, 1, 3);
        this.scrollPane = new CustomScrollPane((CustomScrollPaneModel)this.model);
        this.normalKeyboard = new Keyboard();
        this.normalKeyboard.updated.connect((Object)this, "stringEntered");
        this.numericKeyPad = new Keypad.KeypadBuilder().build();
        this.numericKeyPad.updated.connect((Object)this, "stringEntered");
        this.typeLabel = new JLabel("");
        this.typeLabel.setHorizontalAlignment(0);
        this.typeLabel.setVerticalAlignment(0);
        this.textLabel = new JLabel("");
        this.textLabel.setHorizontalAlignment(0);
        this.textLabel.setVerticalAlignment(0);
        this.navBar = new NavBar();
        this.navBar.addLeft((Component)this.navBar.getBackButton());
        this.navBar.addRight((Component)this.navBar.getOkButton());
        this.navBar.back.connect((Object)this, "back");
        this.navBar.ok.connect((Object)this, "ok");
        this.mainArea = new JPanel();
        this.mainArea.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(20, 50)));
        this.mainArea.add((Component)this.typeLabel, new Rectangle(0, 9, 10, 3));
        this.mainArea.add((Component)this.textLabel, new Rectangle(0, 13, 10, 3));
        this.mainArea.add((Component)this.scrollPane, new Rectangle(15, 0, 5, 20));
        this.mainArea.add((Component)this.normalKeyboard, new Rectangle(0, 21, 20, 29));
    }

    void reset() {
        this.text = "";
        this.setText(this.text);
        this.selectedObject = null;
        this.result = false;
        this.model.removeAllObjects();
        this.normalKeyboard.clear();
        this.numericKeyPad.resetModel();
        this.scrollPane.displayPage(0);
        dialogWindow = null;
        fullScreen = true;
    }

    void setType(String type) {
        this.typeLabel.setText("<html><h1>" + type + "</h1></html>");
    }

    Object getSelectedObject() {
        if (this.selectedObject == null) {
            return this.text;
        }
        return this.selectedObject;
    }

    void setTitle(String title) {
        this.navBar.setText(title);
    }

    void setText(String theText) {
        this.textLabel.setText("<html><h1>" + theText + "</h1></html>");
    }

    void setSuggestor(Suggestor newSuggestor) {
        this.suggestor = newSuggestor;
    }

    void stringEntered(String str) {
        this.text = str;
        this.setText(this.text);
        this.updateSuggestions();
    }

    void stringChosen(Object str) {
        this.text = String.valueOf(str);
        this.setText(this.text);
        this.selectedObject = str;
        this.ok();
    }

    void updateSuggestions() {
        EventList list = null;
        if (this.suggestor != null) {
            this.suggestor.setSuggestionCriteria(this.text);
            list = this.suggestor.getSuggestions();
        } else {
            list = new ArrayList();
        }
        this.model.setObjects(list);
        this.scrollPane.displayPage(0);
    }

    public NavBar getNavBar() {
        return this.navBar;
    }

    public JComponent getMainArea() {
        return this.mainArea;
    }

    void back() {
        this.result = false;
        this.stopDisplay();
    }

    void ok() {
        this.result = true;
        this.stopDisplay();
    }

    public void stopDisplay() {
        if (fullScreen) {
            super.stopDisplay();
        } else {
            ScreenResource.stopWindow((JComponent)dialogWindow);
        }
    }

    void setKeyBoardValue(String value) {
        if (this.useNumeric) {
            this.numericKeyPad.setValue(value);
        } else {
            this.normalKeyboard.setValue(value);
        }
    }

    void setUseNumericKeyPad(boolean useIt) {
        this.useNumeric = useIt;
        if (this.useNumeric) {
            if (this.mainArea.isAncestorOf((Component)this.normalKeyboard)) {
                this.mainArea.remove((Component)this.normalKeyboard);
            }
            if (!this.mainArea.isAncestorOf((Component)this.numericKeyPad)) {
                this.mainArea.add((Component)this.numericKeyPad, new Rectangle(5, 21, 10, 29));
            }
        } else {
            if (this.mainArea.isAncestorOf((Component)this.numericKeyPad)) {
                this.mainArea.remove((Component)this.numericKeyPad);
            }
            if (!this.mainArea.isAncestorOf((Component)this.normalKeyboard)) {
                this.mainArea.add((Component)this.normalKeyboard, new Rectangle(0, 21, 20, 29));
            }
        }
    }

    public static Object getSuggestion(String label, String currentText, String title, PropertiedObject.Property toSuggest, boolean useNumeric) {
        return SuggestDialog.getSuggestion(label, currentText, title, toSuggest, useNumeric, true);
    }

    public static Object getSuggestion(String label, String currentText, String title, PropertiedObject.Property toSuggest, boolean useNumeric, boolean fullScreen) {
        StringSearcherSuggestor suggestor = new StringSearcherSuggestor(toSuggest);
        return SuggestDialog.getSuggestion(label, currentText, title, (Suggestor)suggestor, useNumeric, fullScreen);
    }

    public static Object getSuggestion(String label, String currentText, String title, Suggestor suggestor, boolean useNumeric, boolean fullScreen) {
        if (dialog == null) {
            dialog = new SuggestDialog();
        }
        dialog.reset();
        dialog.setType(label);
        dialog.setSuggestor(suggestor);
        dialog.setText(currentText);
        dialog.setTitle(title);
        dialog.setUseNumericKeyPad(useNumeric);
        dialog.setKeyBoardValue(currentText);
        if (!fullScreen) {
            return SuggestDialog.doSuggestDialogInADialog(dialog);
        }
        dialog.display();
        Object result = SuggestDialog.dialog.result ? dialog.getSelectedObject() : "\u0000";
        dialog.reset();
        return result;
    }

    private static Object doSuggestDialogInADialog(SuggestDialog theDialog) {
        fullScreen = false;
        theDialog.getMainArea().setPreferredSize(ScreenResource.getMaxDialogDimension());
        dialogWindow = new PopupWindow(theDialog.getNavBar(), false);
        dialogWindow.setComponent(theDialog.getMainArea());
        dialogWindow.setBaseDialog(false);
        dialogWindow.start();
        Object result = theDialog.result ? theDialog.getSelectedObject() : "\u0000";
        return result;
    }

    static {
        fullScreen = true;
    }
}

