/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.dialogs;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Time;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import ordermate.internationalization.Internationalization;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.PopupWindow;

public class TimeSelectDialog
extends PopupWindow
implements ActionListener {
    private JLabel ampmLabel;
    private JButton prevMinute;
    private JButton nextMinute;
    private JLabel minuteLabel;
    private JButton prevHour;
    private JButton nextHour;
    private JLabel hourLabel;
    private Calendar theCalendar;
    private int minuteChange = 5;

    public TimeSelectDialog() {
        super(new NavBar());
        NavBar nav = this.getNavBar();
        nav.addLeft((Component)nav.getCancelButton());
        nav.addRight((Component)nav.getOkButton());
        this.theCalendar = new GregorianCalendar();
        this.setComponent(this.setupPanel());
    }

    public boolean go(Date currentTime) {
        this.theCalendar.setTime(new Date(currentTime.getTime()));
        this.displayTime();
        return this.start();
    }

    private JPanel setupPanel() {
        JPanel date = new JPanel();
        date.setPreferredSize(new Dimension(300, 150));
        date.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(10, 4), 5, 0));
        date.setBorder(new TitledBorder("Time:"));
        this.ampmLabel = new JLabel("");
        this.prevHour = new JButton(IconLoader.get((String)"/waitermate/images/downarrow.png"));
        this.prevHour.addActionListener(this);
        this.hourLabel = new JLabel("<html><h2>" + Internationalization.getLiteralFor((String)"MONTH") + "</h2></html>");
        this.nextHour = new JButton(IconLoader.get((String)"/waitermate/images/uparrow.png"));
        this.nextHour.setName("nextHour");
        this.nextHour.addActionListener(this);
        this.prevMinute = new JButton(IconLoader.get((String)"/waitermate/images/downarrow.png"));
        this.prevMinute.addActionListener(this);
        this.minuteLabel = new JLabel("<html><h2>" + Internationalization.getLiteralFor((String)"DAY") + "</h2></html>");
        this.nextMinute = new JButton(IconLoader.get((String)"/waitermate/images/uparrow.png"));
        this.nextMinute.addActionListener(this);
        date.add((Component)this.hourLabel, new Rectangle(1, 0, 2, 4));
        date.add((Component)this.nextHour, new Rectangle(2, 1, 2, 1));
        date.add((Component)this.prevHour, new Rectangle(2, 2, 2, 1));
        date.add((Component)this.minuteLabel, new Rectangle(4, 0, 2, 4));
        date.add((Component)this.nextMinute, new Rectangle(5, 1, 2, 1));
        date.add((Component)this.prevMinute, new Rectangle(5, 2, 2, 1));
        date.add((Component)this.ampmLabel, new Rectangle(7, 0, 2, 4));
        return date;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.prevMinute) {
            this.theCalendar.roll(12, -this.minuteChange);
            this.displayTime();
        } else if (e.getSource() == this.nextMinute) {
            this.theCalendar.roll(12, this.minuteChange);
            this.displayTime();
        } else if (e.getSource() == this.prevHour) {
            this.theCalendar.add(10, -1);
            this.displayTime();
        } else if (e.getSource() == this.nextHour) {
            this.theCalendar.add(10, 1);
            this.displayTime();
        }
    }

    private void displayTime() {
        Time time = this.getNewTime();
        this.hourLabel.setText("<html><h1>" + DateTimeUtils.getHoursFromTime((Time)time) + "</h1><html>");
        this.minuteLabel.setText("<html><h1>" + DateTimeUtils.getMinutesFromTime((Time)time) + "</h1><html>");
        this.ampmLabel.setText("<html><h1>" + DateTimeUtils.amOrPm((Time)time) + "</h1><html>");
    }

    public Time getNewTime() {
        return new Time(this.theCalendar.getTimeInMillis());
    }

    public void setMinuteChange(int minute) {
        this.minuteChange = minute;
    }
}

