/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.displayitems;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.inventory.combos.InventoryComboGroupItemUnitLink;
import ordermate.database.misc.SystemProperty;
import ordermate.gui.button.CustomButton;
import waitermate.gui.displayitems.SelectItemButtonRenderer;

public class SelectComboItemButtonRenderer
extends SelectItemButtonRenderer {
    private InventoryComboGroup comboGroup;

    public SelectComboItemButtonRenderer(boolean isShowItemsQuantity, InventoryComboGroup comboGroup) {
        super(isShowItemsQuantity);
        this.comboGroup = comboGroup;
    }

    @Override
    protected String getButtonText(CustomButton button, Displayable item) {
        String toDisplay = super.getButtonText(button, item);
        return this.appendPriceAddAndSizeInformationString(toDisplay, item);
    }

    private String appendPriceAddAndSizeInformationString(String defaultStr, Displayable item) {
        StringBuilder result = new StringBuilder(defaultStr);
        if (item instanceof InventoryItem) {
            InventoryItem invItem = (InventoryItem)item;
            List allLinks = this.comboGroup.getUnitLinksForItem(invItem, false);
            if (allLinks.size() == 1 && !Price.ZERO_DOLLAR.equals((Object)((InventoryComboGroupItemUnitLink)allLinks.get(0)).getPriceAdd())) {
                result.append(" +").append(((InventoryComboGroupItemUnitLink)allLinks.get(0)).getPriceAdd().toString(true));
            }
            if (SystemProperty.getInstance().isShowSizesOnComboItems() && allLinks.size() >= 1) {
                result.append(" (");
                if (allLinks.size() == 1) {
                    result.append(((InventoryComboGroupItemUnitLink)allLinks.get(0)).getItemUnit().getSizeLabel());
                } else {
                    ArrayList<InventoryItemSize> allSizes = new ArrayList<InventoryItemSize>();
                    for (InventoryComboGroupItemUnitLink unitLink : allLinks) {
                        if (allSizes.contains(unitLink.getItemUnit().getSize())) continue;
                        allSizes.add(unitLink.getItemUnit().getSize());
                    }
                    if (!allSizes.isEmpty()) {
                        int numOfAddedSizes = 0;
                        for (InventoryItemSize size : allSizes) {
                            if (numOfAddedSizes > 0) {
                                result.append(", ");
                            }
                            result.append(size.toString());
                            ++numOfAddedSizes;
                        }
                    }
                }
                result.append(")");
            }
            if (result.length() > 0) {
                return result.toString();
            }
        }
        return defaultStr;
    }
}

