/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.displayitems;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.OrderedQuantity;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.gui.button.CustomButton;
import ordermate.gui.button.MultiLineCustomButton;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class SelectItemButtonRenderer
implements Renderer {
    private static final ImageIcon back = IconLoader.get((String)"/waitermate/images/back-translucent.png");
    private static final ImageIcon forwards = IconLoader.get((String)"/waitermate/images/forward-translucent.png");
    private InventoryGroup currentGroup;
    public final Signal groupSelected = Signals.createSignal(InventoryGroup.class, (String)"group");
    public final Signal itemSelected = Signals.createSignal(InventoryItem.class, (String)"item");
    public final Signal comboSelected = Signals.createSignal(InventoryCombo.class, (String)"combo");
    private OrderedQuantity orderedQuantity;
    private OrderedQuantity uncommitedData;
    private ButtonListener listener = new ButtonListener();
    private CustomButton lastSelectedButton;
    private InventoryGroup lastSelectedGroup;
    private boolean highlightSelected;
    private int itemTextWidth = 15;
    private int groupTextWidth = 15;
    private boolean showItemsQuantity;

    public SelectItemButtonRenderer(boolean isShowItemsQuantity) {
        this.showItemsQuantity = isShowItemsQuantity;
    }

    public void setOrderedQuantities(OrderedQuantity newOrderedQuantity, OrderedQuantity newUncommitedData) {
        this.orderedQuantity = newOrderedQuantity;
        this.uncommitedData = newUncommitedData;
    }

    public Component createComponent() {
        MultiLineCustomButton button = new MultiLineCustomButton();
        button.addActionListener((ActionListener)this.listener);
        return button;
    }

    public void setItemTextWidth(int charWidth) {
        this.itemTextWidth = charWidth;
    }

    public void setGroupTextWidth(int groupWidth) {
        this.groupTextWidth = groupWidth;
    }

    public void setupComponent(Component component, Object object, int index) {
        MultiLineCustomButton button = (MultiLineCustomButton)component;
        button.setEnabled(true);
        button.setIcon(null);
        OrderMateTheme.setupUntoggledButton((AbstractButton)button);
        if (object instanceof InventoryGroup) {
            button.setShowIconOnly(false);
            button.setTextWidth(this.groupTextWidth);
            InventoryGroup group = (InventoryGroup)object;
            button.setData((Displayable)group);
            if (this.currentGroup != null) {
                if (group.equals((Object)this.currentGroup) || group.isParent(this.currentGroup)) {
                    button.setHorizontalTextPosition(4);
                    button.setIcon((Icon)back);
                } else {
                    button.setHorizontalTextPosition(2);
                    button.setIcon((Icon)forwards);
                }
            }
            if (this.highlightSelected && group.equals((Object)this.lastSelectedGroup)) {
                OrderMateTheme.setupToggledButton((AbstractButton)button);
            }
        } else if (object instanceof InventoryCombo || object instanceof InventoryItem) {
            button.setShowIconOnly(true);
            button.setTextWidth(this.itemTextWidth);
            button.setData((Displayable)object);
            this.setupButtonQuantity((CustomButton)button);
        } else {
            throw new IllegalArgumentException("Cannot render object of type " + object.getClass());
        }
    }

    private void setupButtonQuantity(CustomButton button) {
        Displayable item = button.getData();
        button.setText(this.getButtonText(button, item));
    }

    protected String getButtonText(CustomButton button, Displayable item) {
        InventoryCombo combo;
        SalesQuantity itemQty;
        String text = item.getLabel();
        if (item instanceof InventoryItem) {
            InventoryItem invItem = (InventoryItem)item;
            SalesQuantity itemQty2 = this.orderedQuantity.getQuantity(invItem);
            InventoryItemUnit singleUnit = invItem.getUnitIfSingle();
            if (singleUnit != null && this.showItemsQuantity) {
                text = text + singleUnit.getStockQuantityString(itemQty2, this.uncommitedData.getQuantity(invItem));
            }
            if (itemQty2.notEquals(0)) {
                OrderMateTheme.setupToggledButton((AbstractButton)button);
                if (this.showItemsQuantity) {
                    text = "(" + itemQty2 + ") " + text;
                }
            }
        } else if (item instanceof InventoryCombo && (itemQty = this.orderedQuantity.getQuantity(combo = (InventoryCombo)item)).notEquals(0)) {
            OrderMateTheme.setupToggledButton((AbstractButton)button);
            if (this.showItemsQuantity) {
                text = "(" + itemQty + ") " + text;
            }
        }
        return text;
    }

    public void highlightSelected(boolean doHighlight, InventoryGroup initGroup) {
        this.highlightSelected = doHighlight;
        this.lastSelectedGroup = initGroup;
    }

    public void setShowItemsQuantity(boolean showQuantity) {
        this.showItemsQuantity = showQuantity;
    }

    public boolean isShowItemsQuantity() {
        return this.showItemsQuantity;
    }

    public InventoryGroup getCurrentGroup() {
        return this.currentGroup;
    }

    public void setCurrentGroup(InventoryGroup currentGroup) {
        this.currentGroup = currentGroup;
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomButton source = (CustomButton)e.getSource();
            Displayable data = source.getData();
            if (data instanceof InventoryGroup) {
                if (SelectItemButtonRenderer.this.highlightSelected) {
                    SelectItemButtonRenderer.this.lastSelectedGroup = (InventoryGroup)source.getData();
                    if (SelectItemButtonRenderer.this.lastSelectedButton != null) {
                        SelectItemButtonRenderer.this.lastSelectedButton.setData((Displayable)SelectItemButtonRenderer.this.lastSelectedGroup);
                    }
                    SelectItemButtonRenderer.this.lastSelectedButton = source;
                }
                SelectItemButtonRenderer.this.groupSelected.emit((Object)data);
            } else if (data instanceof InventoryItem) {
                SelectItemButtonRenderer.this.itemSelected.emit((Object)data);
            } else if (data instanceof InventoryCombo) {
                SelectItemButtonRenderer.this.comboSelected.emit((Object)data);
            }
        }
    }
}

