/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.displayitems.accountitems;

import java.awt.Component;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.Sellable;
import ordermate.gui.scroll.Renderer;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.displayitems.accountitems.ListedSalesItemPanel;

public class DefaultItemRenderer
implements Renderer {
    public final Signal<Sellable, ?, ?, ?, ?> item = Signals.createSignal(Sellable.class, (String)"selectedItem");
    public final Signal<Sellable, ?, ?, ?, ?> quantity = Signals.createSignal(Sellable.class, (String)"selectedItem");
    public final Signal<Sellable, ?, ?, ?, ?> delete = Signals.createSignal(Sellable.class, (String)"selectedItem");
    public final Signal<Sellable, ?, ?, ?, ?> upgrade = Signals.createSignal(Sellable.class, (String)"selectedItem");
    protected boolean showSeats = false;
    private boolean deleteAllowed;
    private TriggerActivationContext context;

    public DefaultItemRenderer() {
        this(true);
    }

    public DefaultItemRenderer(boolean showDelete) {
        this.deleteAllowed = showDelete;
    }

    public void setShowSeats(boolean value) {
        this.showSeats = value;
    }

    public Component createComponent() {
        return this.initializeComponent(new ListedSalesItemPanel(this.deleteAllowed, this.showSeats));
    }

    protected boolean isDeleteAllowed() {
        return this.deleteAllowed;
    }

    protected final Component initializeComponent(ListedSalesItemPanel panel) {
        panel.deletePressed.connect((Object)this, "gotDeletePressed");
        panel.quantityPressed.connect((Object)this, "gotQuantityPressed");
        panel.itemPressed.connect((Object)this, "gotItemPressed");
        panel.upgradePressed.connect((Object)this, "gotUpgradePressed");
        return panel;
    }

    public void setupComponent(Component component, Object object, int index) {
        ListedSalesItemPanel panel = (ListedSalesItemPanel)component;
        panel.setName("itemPanel");
        panel.setItem(this.context, (Sellable)object);
    }

    public void setTriggerEventContext(TriggerActivationContext context) {
        this.context = context;
    }

    public void gotDeletePressed(Sellable it) {
        this.delete.emit((Object)it);
    }

    public void gotQuantityPressed(Sellable it) {
        this.quantity.emit((Object)it);
    }

    public void gotItemPressed(Sellable it) {
        this.item.emit((Object)it);
    }

    public void gotUpgradePressed(Sellable it) {
        this.upgrade.emit((Object)it);
    }
}

