/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.displayitems.accountitems;

import au.com.ordermate.util.image.IconLoader;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.HashMap;
import javax.swing.ImageIcon;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.VoucherTransactionWrapper;

class ItemIconGenerator {
    private static final int PAD = 10;
    private static final int ICON_WIDTH = 15;
    private static HashMap iconCache = new HashMap(9);

    ItemIconGenerator() {
    }

    public static ImageIcon generateIcon(Sellable item) {
        IconSpecification spec = new IconSpecification(item);
        if (iconCache.containsValue(spec)) {
            return (ImageIcon)iconCache.get(spec);
        }
        ImageIcon theIcon = spec.generateIcon();
        iconCache.put(spec, theIcon);
        return theIcon;
    }

    private static class IconSpecification {
        private boolean hasPluses;
        private boolean hasMinuses;
        private boolean hasPrice;
        private boolean printed;
        private boolean refund;
        private boolean isVoucher;

        public IconSpecification(boolean newHasPluses, boolean newHasMinuses, boolean newHasPrice, boolean newPrinted, boolean refund, boolean voucher) {
            this.hasPluses = newHasPluses;
            this.hasMinuses = newHasMinuses;
            this.hasPrice = newHasPrice;
            this.printed = newPrinted;
            this.refund = refund;
            this.isVoucher = voucher;
        }

        public IconSpecification(Sellable lineItem) {
            this.hasPluses = false;
            this.hasMinuses = false;
            for (SalesItem item : lineItem.getSalesItems()) {
                for (SalesComponent component : item.getComponentList()) {
                    this.hasPluses = this.hasPluses || component.hasPlusses();
                    this.hasMinuses = this.hasMinuses || component.hasMinuses();
                }
            }
            this.hasPrice = lineItem.isPriceEdited();
            this.printed = lineItem.isPrinted();
            this.refund = false;
            if (lineItem.isQuantifiable()) {
                this.refund = lineItem.getQuantity().lessThan(0L);
            }
            this.isVoucher = false;
            if (lineItem instanceof VoucherTransactionWrapper) {
                this.isVoucher = true;
            }
        }

        public int getWidth() {
            int width = 0;
            int numIcons = 0;
            if (this.hasPluses) {
                width += 15;
                ++numIcons;
            }
            if (this.hasMinuses) {
                width += 15;
                ++numIcons;
            }
            if (this.hasPrice) {
                width += 15;
                ++numIcons;
            }
            if (this.printed) {
                width += 15;
                ++numIcons;
            }
            if (this.refund) {
                width += 15;
                ++numIcons;
            }
            if (this.isVoucher) {
                width += 15;
                ++numIcons;
            }
            return width += (numIcons - 1) * 10;
        }

        public ImageIcon generateIcon() {
            if (!(this.hasPluses || this.hasMinuses || this.hasPrice || this.printed || this.refund || this.isVoucher)) {
                return null;
            }
            GraphicsConfiguration gConf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            BufferedImage mainIcon = gConf.createCompatibleImage(this.getWidth(), 15, 3);
            int currentX = 0;
            if (this.printed) {
                this.drawIcon("/waitermate/images/smallPrint.png", mainIcon, currentX, 0, null);
                currentX += 25;
            }
            if (this.hasPluses) {
                this.drawIcon("/waitermate/images/plus.png", mainIcon, currentX, 0, null);
                currentX += 25;
            }
            if (this.hasMinuses) {
                this.drawIcon("/waitermate/images/minus.png", mainIcon, currentX, 0, null);
                currentX += 25;
            }
            if (this.hasPrice) {
                this.drawIcon("/waitermate/images/price.png", mainIcon, currentX, 0, null);
                currentX += 25;
            }
            if (this.refund) {
                this.drawIcon("/waitermate/images/redo15.png", mainIcon, currentX, 0, null);
                currentX += 25;
            }
            if (this.isVoucher) {
                this.drawIcon("/waitermate/images/giftVoucher_15.png", mainIcon, currentX, 0, null);
                currentX += 25;
            }
            return new ImageIcon(mainIcon);
        }

        private void drawIcon(String iconPath, Image mainIcon, int x, int y, ImageObserver observer) {
            ImageIcon refundIcon = IconLoader.get((String)iconPath);
            mainIcon.getGraphics().drawImage(refundIcon.getImage(), x, y, observer);
        }

        public int hashCode() {
            int hash = 13;
            int hasMinusesCode = this.hasMinuses ? 1 : 0;
            int hasPlusesCode = this.hasPluses ? 1 : 0;
            int hasPriceCode = this.hasPrice ? 1 : 0;
            int isPrintedCode = this.printed ? 1 : 0;
            int isRefund = this.refund ? 1 : 0;
            hash = 17 * hash + hasMinusesCode;
            hash = 19 * hash + hasPlusesCode;
            hash = 23 * hash + hasPriceCode;
            hash = 29 * hash + isPrintedCode;
            hash = 31 * hash + isRefund;
            return hash;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            IconSpecification otherSpec = (IconSpecification)other;
            return otherSpec.hasMinuses == this.hasMinuses && otherSpec.hasPluses == this.hasPluses && otherSpec.hasPrice == this.hasPrice && otherSpec.printed == this.printed && otherSpec.refund == this.refund;
        }
    }
}

