/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.displayitems.accountitems;

import au.com.ordermate.units.SalesQuantity;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesLineItemWrapper;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.SellableWrapperFactory;
import ordermate.gui.button.CustomToggleButton;
import ordermate.gui.scroll.Renderer;
import waitermate.LoginManager;
import waitermate.gui.dialogs.ItemSplitDialog;
import waitermate.gui.displayitems.accountitems.SalesItemDisplayFormat;
import waitermate.gui.displayitems.accountitems.SelectItemsPanel;
import waitermate.gui.displayitems.accountitems.SplittableItemPanel;

public class ItemToggleRenderer
implements Renderer,
ActionListener {
    private final SelectItemsPanel panel;
    private SalesItemDisplayFormat format;
    private SellableWrapperFactory sellableFactory = new SellableWrapperFactory();

    public ItemToggleRenderer(SelectItemsPanel panel) {
        this.panel = panel;
    }

    public Component createComponent() {
        SplittableItemPanel button = new SplittableItemPanel();
        if (this.format != null) {
            button.setFormat(this.format);
        }
        button.quantityPressed.connect((Object)this, "gotQuantityPressed");
        button.addActionListener(this);
        return button;
    }

    public void setupComponent(Component component, Object object, int index) {
        SplittableItemPanel splitPanel = (SplittableItemPanel)component;
        splitPanel.setItem((Sellable)object);
        if (this.panel.getSelectedItems().contains(object)) {
            splitPanel.setSelected(true);
        } else {
            splitPanel.setSelected(false);
        }
    }

    protected void gotQuantityPressed(Sellable forItem) {
        if (forItem.isQuantifiable() && forItem.isSplittable()) {
            if (forItem.getSellingObject() instanceof SalesLineItem) {
                SalesLineItem splitItem;
                SalesQuantity splitQty;
                boolean ok;
                SalesLineItem unwrappedSellable = (SalesLineItem)forItem.getSellingObject();
                if (forItem.getQuantity().equals(2L)) {
                    ok = true;
                    splitQty = SalesQuantity.ONE;
                } else {
                    ItemSplitDialog itemSplitDialog = new ItemSplitDialog(unwrappedSellable);
                    ok = itemSplitDialog.start();
                    splitQty = itemSplitDialog.getSplitQuantity();
                }
                if (ok && (splitItem = unwrappedSellable.split(splitQty, LoginManager.getEventContext())) != null) {
                    SalesLineItemWrapper splitSellable = this.sellableFactory.wrapItem(splitItem);
                    this.panel.itemsSplit.emit((Object)forItem.getAccount());
                    boolean itemWasSelected = this.panel.getSelectedItems().contains(forItem);
                    if (itemWasSelected) {
                        this.panel.addSelection((Sellable)splitSellable);
                        this.panel.selectionChanged.emit(this.panel.getSelectedItems());
                    }
                    List<Sellable> items = this.panel.getItems();
                    items.add((Sellable)splitSellable);
                    this.panel.setItems(items);
                }
            } else if (forItem.getSellingObject() instanceof GiftVoucherTransaction) {
                // empty if block
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof CustomToggleButton) {
            CustomToggleButton button = (CustomToggleButton)e.getSource();
            if (button.isSelected()) {
                this.panel.addSelection((Sellable)button.getData());
            } else {
                this.panel.removeSelection((Sellable)button.getData());
            }
            this.panel.selectionChanged.emit(this.panel.getSelectedItems());
        }
    }

    public SalesItemDisplayFormat getFormat() {
        return this.format;
    }

    public void setFormat(SalesItemDisplayFormat format) {
        this.format = format;
    }
}

