/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.displayitems.accountitems;

import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import ordermate.database.sales.Account;
import ordermate.database.sales.Sellable;
import ordermate.gui.scroll.Renderer;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.collections.set.MapBackedSet;
import org.apache.commons.collections.set.UnmodifiableSet;
import waitermate.gui.displayitems.accountitems.CourseItemsPanel;
import waitermate.gui.displayitems.accountitems.DefaultItemRenderer;
import waitermate.gui.displayitems.accountitems.ItemToggleRenderer;
import waitermate.gui.displayitems.accountitems.SalesItemDisplayFormat;
import waitermate.gui.displayitems.accountitems.saleslineitemrenderer.TotalSalesLineItemRenderer;

public class SelectItemsPanel
extends CourseItemsPanel {
    public final Signal<Set, ?, ?, ?, ?> selectionChanged = Signals.createSignal(Set.class, (String)"selectedItems");
    public final Signal<Account, ?, ?, ?, ?> itemsSplit = Signals.createSignal(Account.class, (String)"fromAccount");
    private final Set<Sellable> selectedItems = this.createSelectedItemsSet();

    public SelectItemsPanel() {
        this(3);
    }

    public SelectItemsPanel(int numColumns) {
        this(numColumns, "");
    }

    public SelectItemsPanel(int numColumns, String newKeyPrefix) {
        super(new DefaultItemRenderer(), newKeyPrefix);
        ItemToggleRenderer renderer = new ItemToggleRenderer(this);
        renderer.setFormat(new SalesItemDisplayFormat(){

            @Override
            public String getText(Sellable theItem) {
                return new TotalSalesLineItemRenderer().getHTMLWaitermateFullText(theItem);
            }
        });
        super.setRenderer(renderer);
        this.setColumns(numColumns);
    }

    @Override
    public void setRenderer(Renderer newRendered) {
        super.setRenderer(newRendered);
    }

    public void addSelection(Sellable selectedObj) {
        this.selectedItems.add(selectedObj);
    }

    public void removeSelection(Sellable obj) {
        this.selectedItems.remove(obj);
    }

    public void setSelectedItems(List<Sellable> selectedObjs) {
        this.selectedItems.clear();
        this.selectedItems.addAll(selectedObjs);
        this.selectionChanged.emit(this.selectedItems);
        this.redrawItems();
    }

    public Set<Sellable> getSelectedItems() {
        return UnmodifiableSet.decorate(new HashSet<Sellable>(this.selectedItems));
    }

    public void selectAll() {
        this.selectedItems.clear();
        this.selectedItems.addAll(this.getItems());
        this.selectionChanged.emit(this.selectedItems);
        this.redrawItems();
    }

    public void selectNone() {
        this.selectedItems.clear();
        this.selectionChanged.emit(this.selectedItems);
        this.redrawItems();
    }

    private Set<Sellable> createSelectedItemsSet() {
        return ListOrderedSet.decorate((Set)MapBackedSet.decorate(new IdentityHashMap()), new LinkedList());
    }

    @Override
    public void setItems(Collection<Sellable> items) {
        this.clearItems();
        this.addCourseItemsV1(items);
        this.rebuildGui();
        this.resetTabColours();
        this.updateItems();
        this.selectedItems.retainAll(this.getItems());
        this.selectionChanged.emit(this.selectedItems);
        this.redrawItems();
    }
}

