/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.displayitems.accountitems;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.units.SalesQuantity;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import ordermate.database.sales.Sellable;
import ordermate.gui.button.CustomToggleButton;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.displayitems.accountitems.ItemIconGenerator;
import waitermate.gui.displayitems.accountitems.SalesItemDisplayFormat;
import waitermate.gui.displayitems.accountitems.saleslineitemrenderer.DefaultSalesLineItemRenderer;
import waitermate.gui.displayitems.accountitems.saleslineitemrenderer.SalesLineItemRenderer;

public class SplittableItemPanel
extends JPanel {
    private final SalesLineItemRenderer renderer = new DefaultSalesLineItemRenderer();
    public final Signal quantityPressed = Signals.createSignal(Sellable.class, (String)"forItem");
    private Sellable item;
    private final CustomToggleButton<Sellable> itemButton;
    private final JButton quantityButton;
    private boolean quantityShowing;
    private SalesItemDisplayFormat format;

    public SplittableItemPanel() {
        this.setLayout(new BorderLayout());
        this.itemButton = new CustomToggleButton();
        this.itemButton.setHorizontalTextPosition(2);
        this.add((Component)this.itemButton, "Center");
        this.quantityButton = new JButton();
        this.quantityButton.setRolloverEnabled(false);
        this.quantityButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplittableItemPanel.this.quantityPressed.emit((Object)SplittableItemPanel.this.item);
            }
        });
        this.quantityShowing = false;
        this.format = new SalesItemDisplayFormat(){

            @Override
            public String getText(Sellable theItem) {
                return SplittableItemPanel.this.renderer.getHTMLWaitermateTitle(theItem);
            }
        };
    }

    public void setItem(Sellable newItem) {
        this.item = newItem;
        this.itemButton.setData((Displayable)this.item);
        String itemString = this.format.getText(this.item);
        this.itemButton.setText(itemString);
        this.itemButton.setIcon((Icon)ItemIconGenerator.generateIcon(this.item));
        this.quantityButton.setEnabled(this.item.isQuantifiable() && this.item.isSplittable());
        if (this.item.isQuantifiable()) {
            SalesQuantity qty = this.item.getQuantity();
            if (qty.greaterThan(1L)) {
                this.quantityButton.setText(String.valueOf(qty));
                if (!this.quantityShowing) {
                    this.add((Component)this.quantityButton, "West");
                    this.quantityButton.putClientProperty("substancelaf.buttonopenSide", "RIGHT");
                    this.itemButton.putClientProperty((Object)"substancelaf.buttonopenSide", (Object)"LEFT");
                    this.quantityShowing = true;
                }
            } else if (this.quantityShowing) {
                this.remove(this.quantityButton);
                this.quantityButton.putClientProperty("substancelaf.buttonopenSide", null);
                this.itemButton.putClientProperty((Object)"substancelaf.buttonopenSide", null);
                this.quantityShowing = false;
            }
        }
    }

    public boolean isSelected() {
        return this.itemButton.isSelected();
    }

    public void setSelected(boolean b) {
        this.itemButton.setSelected(b);
    }

    public Sellable getSalesItem() {
        return this.item;
    }

    public void addActionListener(ActionListener al) {
        this.itemButton.addActionListener(al);
    }

    public SalesItemDisplayFormat getFormat() {
        return this.format;
    }

    public void setFormat(SalesItemDisplayFormat format) {
        this.format = format;
    }
}

