/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.displayitems.accountitems.saleslineitemrenderer;

import au.com.ordermate.util.HtmlUtils;
import java.util.List;
import ordermate.database.config.ExperimentalFeatureHelper;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.misc.SeatsMode;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesLineItemWrapper;
import ordermate.database.sales.SalesOption;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.VoucherTransactionWrapper;
import waitermate.gui.displayitems.accountitems.saleslineitemrenderer.SalesLineItemRenderer;

public class DefaultSalesLineItemRenderer
implements SalesLineItemRenderer {
    private static final int MAX_COMBO_COUNT = 3;

    @Override
    public String getHTMLWaitermateTitle(Sellable item) {
        StringBuilder SB = new StringBuilder("");
        if (item instanceof SalesLineItemWrapper) {
            if (item.getSellingObject() instanceof SalesLineItem) {
                SalesLineItem sellableItem = (SalesLineItem)item.getSellingObject();
                if (sellableItem instanceof SalesCombo) {
                    this.appendSalesComboLabel((SalesCombo)sellableItem, SB);
                } else if (sellableItem instanceof SalesItem) {
                    this.appendSalesItemLabel((SalesItem)sellableItem, SB);
                } else {
                    this.appendSalesLineItemLabel(sellableItem, SB);
                }
            }
        } else {
            this.appendSellableLabel(item, SB);
        }
        if (item.getCustomer() != null) {
            SB.append("<font color='#808080'> - " + item.getCustomer().getFirstName() + "</font>");
        }
        if (item.hasDisplayablePriceLevels()) {
            SB.append("<br><font color='#595454'>").append(item.getDisplayablePriceLevels()).append("</font>");
        }
        return HtmlUtils.html((String)SB.toString());
    }

    @Override
    public String getHTMLWaitermateFullText(Sellable sellableItem) {
        StringBuilder SB = new StringBuilder("<html>");
        if (sellableItem instanceof SalesLineItemWrapper) {
            if (sellableItem.getSellingObject() instanceof SalesLineItem) {
                SalesLineItem item = (SalesLineItem)sellableItem.getSellingObject();
                String middleText = this.getHTMLMiddleText(sellableItem);
                if (item instanceof SalesCombo) {
                    this.appendSalesComboLabel((SalesCombo)item, SB);
                } else if (item instanceof SalesItem) {
                    this.appendSalesItemLabel((SalesItem)item, SB);
                } else {
                    this.appendSalesLineItemLabel(item, SB);
                }
                if (middleText != null) {
                    SB.append(HtmlUtils.newline((int)1)).append(middleText.replace("<html>", "").replace("</html>", ""));
                }
            }
        } else {
            this.appendSellableLabel(sellableItem, SB);
        }
        if (sellableItem.getCustomer() != null) {
            SB.append("<font color='#808080'> - " + sellableItem.getCustomer().getFirstName() + "</font>");
        }
        if (sellableItem.hasDisplayablePriceLevels()) {
            SB.append("<br><font color='#595454'>").append(sellableItem.getDisplayablePriceLevels()).append("</font>");
        }
        SB.append("</html>");
        return SB.toString();
    }

    private void appendSalesComboLabel(SalesCombo combo, StringBuilder SB) {
        SB.append(combo.getLabel());
    }

    private void appendSalesComboExtra(SalesCombo combo, StringBuilder SB) {
        SB.append("( ");
        List items = combo.getSalesItems();
        for (int i = 0; i < items.size(); ++i) {
            if (i >= 3) {
                SB.append("...");
                i = items.size();
                continue;
            }
            SB.append(((SalesItem)items.get(i)).getLabel(InventoryItem.Properties.SHORT_NAME, true));
            if (i >= items.size() - 1) continue;
            SB.append(", ");
        }
        SB.append(" )");
    }

    protected void appendSalesItemLabel(SalesItem item, StringBuilder SB) {
        SB.append(item.getLabel(InventoryItem.Properties.LABEL, true));
    }

    protected void appendSalesItemExtraInfo(SalesItem item, StringBuilder SB) {
        for (SalesComponent comp : item.getComponentList()) {
            if (!comp.hasOption()) continue;
            boolean openBrace = false;
            for (SalesOption option : comp.getCurrentOptions()) {
                if (!option.isPrintable()) continue;
                if (!openBrace) {
                    SB.append("[");
                    openBrace = true;
                } else {
                    SB.append(", ");
                }
                SB.append(option.toString());
            }
            if (!openBrace) continue;
            SB.append("]");
        }
    }

    private void appendSalesLineItemLabel(SalesLineItem item, StringBuilder SB) {
        SB.append(item.getLabel());
    }

    @Override
    public String getHTMLMiddleText(Sellable item) {
        StringBuilder SB = new StringBuilder();
        if (item.getSellingObject() instanceof SalesCombo) {
            this.appendSalesComboExtra((SalesCombo)item.getSellingObject(), SB);
        } else if (item.getSellingObject() instanceof SalesItem) {
            SalesItem salesItem;
            this.appendSalesItemExtraInfo((SalesItem)item.getSellingObject(), SB);
            if (!ExperimentalFeatureHelper.isWMShowComboItemsInOldWay() && (salesItem = (SalesItem)item.getSellingObject()).getParentCombo() != null) {
                SalesCombo parentCombo = salesItem.getParentCombo();
                SB.append("-").append(parentCombo.getLabel());
            }
        }
        if (SB.length() > 0) {
            return HtmlUtils.html((String)SB.toString());
        }
        return null;
    }

    private void appendSellableLabel(Sellable item, StringBuilder SB) {
        if (item instanceof VoucherTransactionWrapper) {
            SB.append(item.getLabel()).append(" ").append(item.getPrice());
        } else if (item instanceof SalesItem) {
            this.appendSalesItemExtraInfo((SalesItem)item, SB);
        }
    }

    @Override
    public String getHTMLBottomText(Sellable item) {
        if (item.getAccount() instanceof TableAccount && SeatsMode.FineDining.equals((Object)SystemProperty.getInstance().getSeatsMode())) {
            StringBuilder SB = new StringBuilder("<html><font size=2>");
            SB.append("Seat: ");
            if (item.getSeat() == 0) {
                SB.append("All");
            } else {
                SB.append(item.getSeat());
            }
            SB.append("</font></html>");
            return SB.toString();
        }
        return null;
    }
}

