/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.displayitems.customer;

import java.awt.Component;
import ordermate.database.sales.Customer;
import ordermate.gui.scroll.Renderer;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.displayitems.customer.CustomerPanel;
import waitermate.gui.screens.customer.SalesHistoryPanel;

public class CustomerRenderer
implements Renderer {
    public final Signal<Customer, ?, ?, ?, ?> selected = Signals.createSignal(Customer.class, (String)"selected");
    public final Signal<Customer, ?, ?, ?, ?> edit = Signals.createSignal(Customer.class, (String)"edit");
    boolean showSalesHistoryButtonFlag = false;
    boolean showEdit = false;

    public CustomerRenderer(boolean showSalesHistoryButton, boolean showEdit) {
        this.showSalesHistoryButtonFlag = showSalesHistoryButton;
        this.showEdit = showEdit;
    }

    public Component createComponent() {
        CustomerPanel customerPanel = new CustomerPanel();
        customerPanel.selected.connect((Object)this, "select");
        customerPanel.edit.connect((Object)this, "edit");
        customerPanel.salesHistorySignal.connect((Object)this, "gotSalesHistorySelected");
        customerPanel.setEditVisible(this.showEdit);
        customerPanel.setHistoryVisible(this.showSalesHistoryButtonFlag);
        return customerPanel;
    }

    void gotSalesHistorySelected(Customer cust) {
        SalesHistoryPanel.displayDialog(cust);
    }

    public void setupComponent(Component component, Object object, int index) {
        CustomerPanel customerPanel = (CustomerPanel)component;
        Customer customer = (Customer)object;
        customerPanel.setCustomer(customer);
    }

    public void select(Customer customer) {
        this.selected.emit((Object)customer);
    }

    public void edit(Customer customer) {
        this.edit.emit((Object)customer);
    }
}

