/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.displayitems.stockitems;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;
import ordermate.gui.breadcrumb.Breadcrumb;
import ordermate.gui.breadcrumb.ChildTreeNodeScrollPane;
import ordermate.gui.scroll.CustomButtonRenderer;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.displayitems.stockitems.StockGroupItemsRenderer;

public class StockItemBrowser
extends JPanel {
    private static final int ROWS = 6;
    private static final int COLS = 4;
    private static final int SIDE_PANEL_ROWS = 6;
    public Signal itemSelected = Signals.createSignal(StockItem.class, (String)"theNewItem");
    private StockGroup selectedStockGroup = null;
    private List<StockItem> currentItems;
    private Breadcrumb<StockGroup> stockGroupBreadcrumb;
    private ChildTreeNodeScrollPane<StockGroup> childNodeScroll;
    private StockGroupItemsRenderer childRenderer;
    private CustomButtonRenderer<StockItem> itemRenderer;
    private RendererScrollPaneModel itemModel;
    private CustomScrollPane scroller;
    private JPanel centerPanel;

    public StockItemBrowser() {
        this.setup();
    }

    private void setup() {
        this.setLayout(new BorderLayout());
        this.stockGroupBreadcrumb = new Breadcrumb<StockGroup>(){

            public Class<StockGroup> getGenericClass() {
                return StockGroup.class;
            }
        };
        this.stockGroupBreadcrumb.breadcrumbSelected.connect((Object)this, "gotStockGroup");
        this.add((Component)this.stockGroupBreadcrumb, "North");
        this.centerPanel = new JPanel(new BorderLayout());
        this.childRenderer = new StockGroupItemsRenderer();
        this.childRenderer.selected.connect((Object)this, "gotStockGroup");
        this.childNodeScroll = new ChildTreeNodeScrollPane<StockGroup>(6, (Renderer)this.childRenderer){

            public List<StockGroup> getTopLevelObjects() {
                return StockGroup.getTopLevelStockGroups();
            }
        };
        this.centerPanel.add((Component)this.childNodeScroll, "West");
        this.itemRenderer = new CustomButtonRenderer<StockItem>(){

            public Class<StockItem> getSelectedClassType() {
                return StockItem.class;
            }

            protected String createComponentText(StockItem object) {
                StringBuilder SB = new StringBuilder("<html><body>");
                SB.append("<B>" + object.getLabel() + "</B>");
                SB.append("</body></html>");
                return SB.toString();
            }
        };
        this.itemRenderer.selected.connect((Object)this, "gotItem");
        this.itemModel = new RendererScrollPaneModel(this.itemRenderer);
        this.itemModel.setColumns(4);
        this.itemModel.setRowsPerPage(6);
        this.scroller = new CustomScrollPane((CustomScrollPaneModel)this.itemModel);
        this.scroller.setName("stockItemSelect");
        this.centerPanel.add((Component)this.scroller, "Center");
        this.add((Component)this.centerPanel, "Center");
    }

    public void reset() {
        this.selectedStockGroup = null;
        this.updateResults();
    }

    public void updateResults() {
        this.currentItems = new ArrayList<StockItem>();
        this.stockGroupBreadcrumb.setObject((TreeNode)this.selectedStockGroup);
        this.childNodeScroll.setObject((TreeNode)this.selectedStockGroup);
        if (this.selectedStockGroup != null) {
            this.currentItems = this.selectedStockGroup.getStockItems();
        }
        this.itemModel.setObjects(this.currentItems);
    }

    protected void gotItem(StockItem selectedItem) {
        this.itemSelected.emit((Object)selectedItem);
    }

    protected void gotStockGroup(StockGroup selectedGroup) {
        this.selectedStockGroup = selectedGroup;
        this.updateResults();
    }

    Breadcrumb<StockGroup> getStockGroupBreadcrumb() {
        return this.stockGroupBreadcrumb;
    }

    ChildTreeNodeScrollPane<StockGroup> getChildNodeScroll() {
        return this.childNodeScroll;
    }

    CustomScrollPane getScroller() {
        return this.scroller;
    }
}

