/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.displayitems.stockwastage;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.stock.usage.StockWastage;
import ordermate.database.users.AllPermissions;
import ordermate.gui.button.CustomButton;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.displayitems.stockwastage.DefaultWastageRenderer;
import waitermate.gui.displayitems.stockwastage.StockWastageRenderer;

class ListedStockWastagePanel
extends JPanel
implements ActionListener {
    private static final StockWastageRenderer renderer = new DefaultWastageRenderer();
    public Signal<StockWastage, ?, ?, ?, ?> itemPressed = Signals.createSignal(StockWastage.class, (String)"stockItemWastage");
    public Signal<StockWastage, ?, ?, ?, ?> deletePressed = Signals.createSignal(StockWastage.class, (String)"stockItemWastage");
    private StockWastage stockItem;
    protected CustomButton<StockWastage> itemButton;
    protected CustomButton<StockWastage> deleteButton;
    protected StandardSecurityDecorator deleteDecorator;
    protected JLabel priceLabel;
    private JPanel leftButtonHolder;

    public ListedStockWastagePanel() {
        this(true);
    }

    public ListedStockWastagePanel(boolean deleteAllowed) {
        this.createPanel(deleteAllowed);
    }

    protected void createItemButton() {
        this.itemButton = new CustomButton();
        this.itemButton.addActionListener((ActionListener)this);
        this.itemButton.setHorizontalTextPosition(2);
        this.itemButton.setHorizontalAlignment(2);
        this.itemButton.putClientProperty((Object)"substancelaf.buttonopenSide", (Object)"LEFT");
        this.itemButton.setVerticalTextPosition(1);
    }

    protected void createPanel(boolean deleteAllowed) {
        this.setLayout((LayoutManager)new GraphPaperLayout(21, 1));
        this.createItemButton();
        if (deleteAllowed) {
            this.deleteButton = new CustomButton();
            this.deleteButton.addActionListener((ActionListener)this);
            this.deleteButton.setName("deleteItem");
            this.deleteButton.setIcon((Icon)IconLoader.get((String)"/waitermate/images/delete.png"));
            this.deleteDecorator = new StandardSecurityDecorator(this.deleteButton, AllPermissions.DELETE_STOCK_ITEMS);
            this.deleteDecorator.setSecurityOn(false);
            this.deleteDecorator.setName("deleteItemDec");
            this.add((Component)this.itemButton, new Rectangle(0, 0, 17, 1));
            this.add((Component)this.deleteDecorator, new Rectangle(17, 0, 4, 1));
        } else {
            this.add((Component)this.itemButton, new Rectangle(0, 0, 17, 1));
        }
    }

    public void setItem(StockWastage newItem) {
        this.stockItem = newItem;
        this.itemButton.setData((Displayable)this.stockItem);
        String itemString = renderer.getHTMLWaitermateLabel(this.stockItem);
        this.itemButton.setText(itemString);
        this.itemButton.setEnabled(true);
        if (this.deleteDecorator != null) {
            this.updateDeleteButtonState();
        }
    }

    private void updateDeleteButtonState() {
        if (this.deleteButton == null) {
            return;
        }
        this.deleteButton.setName("deleteItem");
        this.deleteDecorator.setEnabled(true);
    }

    public StandardSecurityDecorator getDeleteSecurityDecorator() {
        return this.deleteDecorator;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.itemButton) {
            this.itemPressed.emit((Object)this.stockItem);
        } else if (source == this.deleteDecorator.getDecorateComponent()) {
            this.deletePressed.emit((Object)this.stockItem);
        }
    }

    public void refreshValues() {
        this.itemButton.setText(String.valueOf(this.stockItem.getLabel()));
    }

    private Price getPriceLevel() {
        return this.stockItem.getStockItem().getPrice().multiply((Number)this.stockItem.getQuantityUsed());
    }

    private String getQuantityLabel() {
        return this.stockItem.getQuantityUsed().toString();
    }
}

