/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.displayitems.voucher;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.HtmlUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import ordermate.OrderMate;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.sales.VoucherTransactionWrapper;
import ordermate.gui.button.CustomButton;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class VoucherPanel
extends JPanel
implements ActionListener {
    public final Signal<GiftVoucherTransaction, ?, ?, ?, ?> selected = Signals.createSignal(GiftVoucherTransaction.class, (String)"selected");
    private GiftVoucherTransaction voucherTxn;
    private CustomButton custButton = new CustomButton();
    private CustomButton balanceButton;

    public VoucherPanel() {
        this.custButton.setHorizontalAlignment(2);
        this.custButton.addActionListener((ActionListener)this);
        this.custButton.putClientProperty((Object)"substancelaf.buttonopenSide", (Object)"RIGHT");
        this.custButton.putClientProperty((Object)"substancelaf.buttonShaper", (Object)"org.jvnet.substance.button.ClassicButtonShaper");
        this.balanceButton = new CustomButton();
        this.balanceButton.setFont(OrderMateTheme.getLargeFont());
        this.balanceButton.putClientProperty((Object)"substancelaf.buttonopenSide", (Object)"LEFT");
        this.setLayout((LayoutManager)new GraphPaperLayout(20, 1));
        this.add((Component)this.custButton, new Rectangle(0, 0, 14, 1));
        this.add((Component)this.balanceButton, new Rectangle(14, 0, 6, 1));
    }

    public void setVoucherTxn(GiftVoucherTransaction gVoucher) {
        if (gVoucher == null) {
            OrderMate.LOG.error("Voucher txn is NULL, can't display in panel.");
            return;
        }
        this.voucherTxn = gVoucher;
        this.custButton.setData((Displayable)new VoucherTransactionWrapper(this.voucherTxn));
        this.custButton.setText(HtmlUtils.html((String)(gVoucher.getGiftVoucher().getUniqueId() + HtmlUtils.newline((int)1) + "Last Active: " + DateTimeUtils.getMediumDateFormat().format(gVoucher.getCreationDate()))));
        this.balanceButton.setText(HtmlUtils.html((String)gVoucher.getGiftVoucher().getCachedValue().toString(true)));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.custButton) {
            this.selected.emit((Object)this.voucherTxn);
        }
    }
}

