/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.fingerprint;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import com.digitalpersona.onetouch.DPFPDataPurpose;
import com.digitalpersona.onetouch.DPFPGlobal;
import com.digitalpersona.onetouch.DPFPSample;
import com.digitalpersona.onetouch.DPFPTemplate;
import com.digitalpersona.onetouch.processing.DPFPEnrollment;
import com.digitalpersona.onetouch.processing.DPFPFeatureExtraction;
import com.digitalpersona.onetouch.processing.DPFPFeatureExtractionFactory;
import com.digitalpersona.onetouch.processing.DPFPImageQualityException;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.hardware.Terminal;
import ordermate.database.users.User;
import ordermate.database.users.UserFingerprint;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.fingerprint.ScanFinger;

public class EnrolFingerprint {
    private static final int NUM_SCANS = 4;
    private final GuiHandler gui;
    private final Signal gotScan = Signals.createSignal(DPFPSample.class, (String)"sample");
    private final Signal gotCancel = Signals.createSignal();
    private List<DPFPSample> samples;

    public EnrolFingerprint(GuiHandler handler) {
        this.gotScan.connect((Object)this, "gotScan");
        this.gotCancel.connect((Object)this, "gotCancel");
        this.gui = handler;
        if (this.gui == null) {
            throw new IllegalStateException("Cannot have a null Gui handler.");
        }
    }

    public void enrolFingerprint(User user, Signal callback) {
        if (user == null) {
            callback.emit();
            return;
        }
        UserFingerprint.Finger finger = this.selectFinger();
        if (finger != null) {
            this.enrolFinger(user, finger);
        }
        callback.emit();
    }

    private UserFingerprint.Finger selectFinger() {
        return UserFingerprint.Finger.RightIndex;
    }

    private void enrolFinger(User user, UserFingerprint.Finger finger) {
        if (!Terminal.getLocalHost().isFingerprintScanner()) {
            this.gui.displayOkDialog("No Scanner", "<html>There is no scanner attached to this Terminal.<br><br>Please enrol your fingerprints on a Terminal that does have a scanner.</html>");
            return;
        }
        this.samples = new ArrayList<DPFPSample>();
        DPFPEnrollment enrolment = DPFPGlobal.getEnrollmentFactory().createEnrollment();
        DPFPFeatureExtractionFactory extractionFactory = DPFPGlobal.getFeatureExtractionFactory();
        DPFPFeatureExtraction extraction = extractionFactory.createFeatureExtraction();
        for (int i = 0; i < 4; ++i) {
            if (this.samples != null) {
                ScanFinger.getInstance().scanFinger(this.gotScan, this.gotCancel, this.gui, "<html>Scanning " + (i + 1) + " of " + 4 + "</html>");
            }
            if (this.samples == null || this.samples.isEmpty()) continue;
            DPFPSample sample = this.samples.get(this.samples.size() - 1);
            try {
                enrolment.addFeatures(extraction.createFeatureSet(sample, DPFPDataPurpose.DATA_PURPOSE_ENROLLMENT));
                continue;
            }
            catch (DPFPImageQualityException ex) {
                this.gui.displayOkDialog("Bad Sample", "That sample was not sufficient. Please scan again.");
                --i;
            }
        }
        if (this.samples == null) {
            return;
        }
        DPFPTemplate template = enrolment.getTemplate();
        if (template != null) {
            this.updateTemplate(user, finger, template);
        } else {
            this.gui.displayOkDialog("Too many bad scans.", "You have dodgy fingers");
        }
    }

    private void updateTemplate(User user, UserFingerprint.Finger finger, DPFPTemplate template) {
        UserFingerprint print = (UserFingerprint)PersistenceManager.getObject(UserFingerprint.class, (String)Query.select(UserFingerprint.class).equals(UserFingerprint.Properties.USER, (Object)user).equals(UserFingerprint.Properties.FINGER, (Object)finger).toString(), null);
        if (print == null) {
            print = new UserFingerprint(user, finger);
        }
        print.setTemplate(template.serialize());
        print.save();
        this.samples = null;
    }

    void gotScan(DPFPSample sample) {
        this.samples.add(sample);
    }

    void gotCancel() {
        this.samples = null;
    }
}

